/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Arc2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.AbstractLabeling;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import jsinterop.annotations.JsType;

@JsType
public class ExpandLabeling<N, Row, Column, Color, Font>
extends AbstractLabeling<N, Row, Column, Color, Font> {
    @Override
    public void paintParent(TGraphics<Color, Font> g2, Rectangle bounds, N node, TreeMapView view, int pass, int passes) {
        if (pass == passes - 1 && bounds.width > 20 && bounds.height > 16) {
            Rectangle rectangle;
            TreeMapModel treeMapModel = view.getModel();
            g2.save();
            g2.setGlobalAlpha(0.5);
            EnhancedLabel enhancedLabel = view.getHeaderRenderer().getTreeMapHeaderRendererComponent(treeMapModel, node, new Dimension(bounds.width, bounds.height));
            PreferredSize preferredSize = g2.sizeLabel(enhancedLabel, bounds.width, bounds.height);
            TreeMapField treeMapField = treeMapModel.getGroupByField(node);
            CPFont cPFont = treeMapModel.getSettings().getFieldSettings(treeMapField).getHeaderFont();
            enhancedLabel.setFont(cPFont);
            Dimension dimension = preferredSize.getPreferredSize();
            float f2 = (float)bounds.getWidth() / (float)dimension.getWidth();
            float f3 = (float)bounds.getHeight() / (float)dimension.getHeight();
            float f4 = Math.min(f2, f3);
            double d2 = Math.max(cPFont.getSize2D(), cPFont.getSize2D() * (double)f4);
            CPColor cPColor = treeMapModel.getSettings().getFieldSettings(treeMapField).getHeaderForeground();
            CPColor cPColor2 = treeMapModel.getSettings().getFieldSettings(treeMapField).getHeaderEffectColor();
            CPFont cPFont2 = cPFont.deriveFontSize(d2);
            enhancedLabel.setFont(cPFont2);
            enhancedLabel.setForeground(cPColor);
            enhancedLabel.setBackground(cPColor2);
            dimension = preferredSize.getPreferredSize();
            Shape shape = treeMapModel.getShape(node);
            Point2D point2D = shape instanceof Arc2D ? ExpandLabeling.getCentroid(shape) : null;
            if (point2D != null) {
                int n2 = dimension.width;
                if (shape instanceof Arc2D) {
                    Arc2D arc2D = (Arc2D)shape;
                    Point2D point2D2 = arc2D.getStartPoint();
                    Point2D point2D3 = arc2D.getEndPoint();
                    Point2D.Double double_ = new Point2D.Double((double)view.worldToScreenX(point2D2.getX()), (double)view.worldToScreenY(point2D2.getY()));
                    Point2D.Double double_2 = new Point2D.Double((double)view.worldToScreenX(point2D3.getX()), (double)view.worldToScreenY(point2D3.getY()));
                    n2 = (int)Math.min(double_.distance((Point2D)double_2), (double)n2);
                }
                int n3 = dimension.height;
                int n4 = view.worldToScreenX(point2D.getX()) - n2 / 2;
                int n5 = view.worldToScreenY(point2D.getY()) - n3 / 2;
                rectangle = new Rectangle(n4, n5, n2, n3).intersection(bounds);
            } else {
                rectangle = bounds;
            }
            g2.paintLabel(enhancedLabel, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            g2.restore();
        }
    }

    public String toString() {
        return "Expand";
    }
}

