/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Arc2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.Insets;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.AbstractLabeling;
import com.treemap.DefaultTreeMapHeaderRenderer;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import jsinterop.annotations.JsType;

@JsType
public class SurroundLabeling<N, Row, Column, Color, Font>
extends AbstractLabeling<N, Row, Column, Color, Font> {
    private Headless b;
    private final double c = 0.0;
    private final double d = 0.0;
    protected static final float MINIMUM_FONT_SIZE_TO_DISPLAY = 5.0f;

    public void setHeadless(Headless headless) {
        this.b = headless;
    }

    @Override
    public double getTopSpace(TreeMapModel<N, Row, Column, Color, Font> model) {
        CPFont<Font> cPFont = model.getSettings().getDefaultFieldSettings().getHeaderFont();
        return cPFont != null ? cPFont.getSize2D() + 2.0 : 0.0;
    }

    @Override
    public double getLeftSpace(TreeMapModel<N, Row, Column, Color, Font> model) {
        return 3.0;
    }

    @Override
    public Shape subtract(TreeMapModel<N, Row, Column, Color, Font> model, Shape shape, N node) {
        if (!model.isRoot(node) && model.getShape(node) instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double d2 = this.computePreferredHeight(model, null, rectangle2D, node);
            double d3 = this.a(d2, rectangle2D);
            double d4 = this.a(model, rectangle2D, node);
            double d5 = rectangle2D.getWidth() - 2.0 * d4;
            double d6 = rectangle2D.getHeight() - (d4 + d3);
            if (d5 > 0.0 && d6 > 0.0) {
                return new Rectangle2D.Double(rectangle2D.getX() + d4, rectangle2D.getY() + d3, d5, d6);
            }
            return rectangle2D;
        }
        return shape;
    }

    private double a(double d2, Rectangle2D rectangle2D) {
        return Math.min(rectangle2D.getHeight() / 5.0, d2);
    }

    protected double computePreferredHeight(TreeMapModel<N, Row, Column, Color, Font> model, TGraphics<Color, Font> g2, Rectangle2D rectangle, N node) {
        double d2 = 0.0;
        TreeMapFieldSettings<Color, Font> treeMapFieldSettings = model.getSettings().getFieldSettings(model.getGroupByField(node));
        CPFont<Font> cPFont = treeMapFieldSettings.getHeaderFont();
        if (cPFont != null && model.getLabelName(node) != null) {
            try {
                if (rectangle != null && rectangle.getHeight() > 3.0) {
                    DefaultTreeMapHeaderRenderer defaultTreeMapHeaderRenderer = new DefaultTreeMapHeaderRenderer();
                    defaultTreeMapHeaderRenderer.setFont(cPFont);
                    EnhancedLabel enhancedLabel = defaultTreeMapHeaderRenderer.getTreeMapHeaderRendererComponent(model, node, new Dimension((int)rectangle.getWidth(), (int)rectangle.getHeight()));
                    assert (this.b != null);
                    PreferredSize preferredSize = this.b.sizeLabel(enhancedLabel, g2, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                    return preferredSize.getPreferredHeight();
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                d2 = 0.0;
            }
        } else {
            d2 = 0.0;
        }
        return d2;
    }

    private double a(TreeMapModel<N, Row, Column, Color, Font> treeMapModel, Rectangle2D rectangle2D, N n2) {
        double d2 = rectangle2D.getWidth() * rectangle2D.getHeight() * 5.0E-4;
        return Math.max(0.0, Math.min(0.0, d2));
    }

    @Override
    public void paintParent(TGraphics<Color, Font> g2, Rectangle bounds, N node, TreeMapView view, int pass, int passes) {
        if (pass == 0) {
            TreeMapModel treeMapModel = view.getModel();
            TreeMapField treeMapField = treeMapModel.getGroupByField(node);
            TreeMapFieldSettings treeMapFieldSettings = treeMapModel.getSettings().getFieldSettings(treeMapField);
            CPFont cPFont = treeMapFieldSettings.getHeaderFont();
            if (cPFont != null && treeMapModel.getLabelName(node) != null) {
                Shape shape = treeMapModel.getShape(node);
                Rectangle2D rectangle2D = shape.getBounds2D();
                Point2D point2D = shape instanceof Arc2D ? SurroundLabeling.getCentroid(shape) : null;
                double d2 = this.computePreferredHeight(treeMapModel, g2, rectangle2D, node);
                double d3 = this.a(d2, rectangle2D);
                if (rectangle2D != null || point2D != null && d3 > 0.0) {
                    Rectangle2D rectangle2D2;
                    double d4;
                    Dimension dimension;
                    Object object;
                    Object object2;
                    EnhancedLabel enhancedLabel;
                    Rectangle2D rectangle2D3;
                    Rectangle2D rectangle2D4 = view.worldToScreenPrecise(rectangle2D);
                    double d5 = cPFont.getSize2D() * (double)view.getZoomFactor();
                    if (d5 >= 5.0) {
                        rectangle2D3 = this.getForegroundColor(node, treeMapModel);
                        enhancedLabel = view.getHeaderRenderer().getTreeMapHeaderRendererComponent(treeMapModel, node, new Dimension(bounds.width, bounds.height));
                        object2 = g2.sizeLabel(enhancedLabel, bounds.width, bounds.height);
                        object = treeMapFieldSettings.getHeaderInsets();
                        enhancedLabel.setInsets((int)((float)((Insets)object).top * view.getZoomFactor()), (int)((float)((Insets)object).left * view.getZoomFactor()), (int)((float)((Insets)object).bottom * view.getZoomFactor()), (int)((float)((Insets)object).right * view.getZoomFactor()));
                        CPColor<Color> cPColor = this.getEffectColor(node, treeMapModel);
                        CPFont cPFont2 = d5 != cPFont.getSize2D() ? cPFont.deriveFontSize(d5) : cPFont;
                        enhancedLabel.setFont(cPFont2);
                        enhancedLabel.setForeground((CPColor)rectangle2D3);
                        enhancedLabel.setBackground(cPColor);
                        dimension = object2.getPreferredSize();
                        if (point2D != null) {
                            double d6 = Math.min((double)dimension.width, rectangle2D4.getWidth());
                            if (shape instanceof Arc2D) {
                                Arc2D arc2D = (Arc2D)shape;
                                Point2D point2D2 = arc2D.getStartPoint();
                                Point2D point2D3 = arc2D.getEndPoint();
                                Point2D.Double double_ = new Point2D.Double((double)view.worldToScreenX(point2D2.getX()), (double)view.worldToScreenY(point2D2.getY()));
                                Point2D.Double double_2 = new Point2D.Double((double)view.worldToScreenX(point2D3.getX()), (double)view.worldToScreenY(point2D3.getY()));
                                d6 = (int)Math.min(double_.distance((Point2D)double_2), d6);
                            }
                            d4 = Math.min((double)dimension.height, rectangle2D4.getHeight());
                            double d7 = (double)view.worldToScreenX(point2D.getX()) - d6 / 2.0;
                            double d8 = (double)view.worldToScreenY(point2D.getY()) - d4 / 2.0;
                            rectangle2D2 = new Rectangle2D.Double(d7, d8, d6, d4).createIntersection((Rectangle2D)bounds);
                        } else {
                            Shape shape2 = treeMapModel.getNestedShape(node);
                            Rectangle2D rectangle2D5 = shape2.getBounds2D();
                            d4 = this.computePreferredHeight(treeMapModel, null, rectangle2D, node);
                            double d9 = this.a(d4, rectangle2D);
                            double d10 = this.a(treeMapModel, rectangle2D, node);
                            rectangle2D2 = view.worldToScreenPrecise((Rectangle2D)new Rectangle2D.Double(rectangle2D5.getX() + d10, rectangle2D.getY(), rectangle2D5.getWidth() - 2.0 * d10, d9));
                        }
                    } else {
                        enhancedLabel = null;
                        rectangle2D3 = treeMapModel.getNestedShape(node);
                        object2 = rectangle2D3.getBounds2D();
                        double d11 = this.computePreferredHeight(treeMapModel, null, rectangle2D, node);
                        double d12 = this.a(d11, rectangle2D);
                        double d13 = this.a(treeMapModel, rectangle2D, node);
                        rectangle2D2 = view.worldToScreenPrecise((Rectangle2D)new Rectangle2D.Double(object2.getX() + d13, rectangle2D.getY(), object2.getWidth() - 2.0 * d13, d12));
                    }
                    if (shape instanceof Rectangle2D) {
                        rectangle2D3 = this.getBackgroundColor(node, treeMapModel);
                        g2.setFill(rectangle2D3);
                        g2.fillRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
                    }
                    if (enhancedLabel != null && rectangle2D2.getWidth() > 8.0) {
                        rectangle2D3 = rectangle2D2.getBounds2D();
                        enhancedLabel.setDesiredWidth(Integer.valueOf((int)(rectangle2D3.getWidth() - (double)enhancedLabel.getInsetLeft().intValue() - (double)enhancedLabel.getInsetRight().intValue())));
                        enhancedLabel.setDesiredHeight(Integer.valueOf((int)(rectangle2D3.getHeight() - (double)enhancedLabel.getInsetTop().intValue() - (double)enhancedLabel.getInsetBottom().intValue())));
                        object2 = enhancedLabel.getFont();
                        object = g2.sizeLabel(enhancedLabel, (int)rectangle2D3.getWidth(), (int)rectangle2D3.getHeight());
                        boolean bl = true;
                        boolean bl2 = false;
                        if (treeMapFieldSettings.getHeaderRendering() != EnhancedLabel.Rendering.WordWrap) {
                            double d14;
                            dimension = object.getPreferredSize();
                            d4 = d14 = (rectangle2D3.getHeight() - (double)enhancedLabel.getInsetTop().intValue() - (double)enhancedLabel.getInsetBottom().intValue()) / (dimension.getHeight() - (double)enhancedLabel.getInsetTop().intValue() - (double)enhancedLabel.getInsetBottom().intValue());
                            d5 = cPFont.getSize2D() * (double)view.getZoomFactor() * d4 * 1.0;
                        } else {
                            d5 = g2.fitTextInsideRectangle(enhancedLabel, (PreferredSize)object, object2, rectangle2D3, 0.99, false);
                        }
                        d5 = Math.min(object2.getSize2D(), d5);
                        dimension = d5 != enhancedLabel.getFont().getSize2D() ? enhancedLabel.getFont().deriveFontSize(d5) : enhancedLabel.getFont();
                        enhancedLabel.setFont((CPFont)dimension);
                        g2.paintLabel(enhancedLabel, (int)rectangle2D3.getX(), (int)rectangle2D3.getY(), (int)rectangle2D3.getWidth(), (int)rectangle2D3.getHeight());
                    }
                }
            }
        }
    }

    protected CPColor<Color> getBackgroundColor(N node, TreeMapModel model) {
        return model.getSettings().getFieldSettings(model.getGroupByField(node)).getHeaderBackground();
    }

    protected CPColor<Color> getForegroundColor(N node, TreeMapModel model) {
        return model.getSettings().getFieldSettings(model.getGroupByField(node)).getHeaderForeground();
    }

    protected CPColor<Color> getEffectColor(N node, TreeMapModel model) {
        return model.getSettings().getFieldSettings(model.getGroupByField(node)).getHeaderEffectColor();
    }

    public String toString() {
        return "Surround";
    }
}

