/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.application.document.AbstractDocument;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.persistence.DataSourcePersistence;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import com.treemap.AbstractTreeMapNode;
import com.treemap.DefaultTreeMapModel;
import com.treemap.TreeMapFilterCoordinator;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapProbingCoordinator;
import com.treemap.TreeMapSelectionCoordinator;
import com.treemap.treeplot.DefaultTreePlotModel;
import com.treemap.treeplot.TreePlotModel;

public class TreeMapDocument<N extends AbstractTreeMapNode<N, Integer, String, Color, Font>, Color, Font, File>
extends AbstractDocument {
    private WrappedDataFrame<Integer, String, ?> dataFrame;
    private final DataSourcePersistence<File> dataSourcePersistence;
    private SubsetDataFrame<Integer, String, ?> subsetDataFrame;
    private final DefaultTreeMapModel<N, Integer, String, Color, Font> treeMapModel;
    private final DefaultTreePlotModel<N, Integer, String, Color, Font> treePlotModel;
    private SimpleVisual<Color, Integer, String> visual;
    private boolean modified;

    public TreeMapDocument(String name, String url, DataFrame<Integer, String, ?> dataFrame, DataSourcePersistence<File> dataSourcePersistence, CPFactory<?, Font, ?, Color> cpFactory, ColorMapFactory<Color> colorMapFactory, CPImageFactory imageFactory) {
        super(name, url);
        if (dataFrame instanceof WrappedDataFrame) {
            this.dataFrame = (WrappedDataFrame)dataFrame;
        } else {
            this.dataFrame = new WrappedDataFrame(dataFrame);
            this.dataFrame.addOriginalColumns();
        }
        this.dataSourcePersistence = dataSourcePersistence;
        this.treeMapModel = new DefaultTreeMapModel(this.dataFrame, cpFactory, colorMapFactory, imageFactory);
        this.treeMapModel.getSettings().getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                TreeMapDocument.this.setModified(true);
            }
        });
        this.visual = new SimpleVisual((VisualObjects)new SimpleVisualObjects(this.dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, this.dataFrame));
        this.subsetDataFrame = new SubsetDataFrame(this.dataFrame, this.visual.getFilter(), this.visual.getSelection());
        this.subsetDataFrame.setTimer(cpFactory.createTimer("Subset", 50, true));
        new TreeMapProbingCoordinator(this.visual.getProbing(), this.treeMapModel);
        new TreeMapSelectionCoordinator(this.visual.getSelection(), this.treeMapModel);
        new TreeMapFilterCoordinator((MutableFilter)this.visual.getFilter(), this.treeMapModel);
        this.treePlotModel = new DefaultTreePlotModel(this.treeMapModel, cpFactory, cpFactory, cpFactory);
    }

    public WrappedDataFrame getDataFrame() {
        return this.dataFrame;
    }

    public DataSourcePersistence<File> getDataSourcePersistence() {
        return this.dataSourcePersistence;
    }

    public SubsetDataFrame<Integer, String, ?> getSubsetDataFrame() {
        return this.subsetDataFrame;
    }

    public TreeMapModel<N, Integer, String, Color, Font> getTreeMapModel() {
        return this.treeMapModel;
    }

    public TreePlotModel<N, Integer, String, Color, Font> getTreePlotModel() {
        return this.treePlotModel;
    }

    public Visual<Color, Integer, String> getVisual() {
        return this.visual;
    }

    public void setDataFrame(DataFrame dataFrame) {
        if (dataFrame instanceof WrappedDataFrame) {
            this.dataFrame = (WrappedDataFrame)dataFrame;
        } else {
            this.dataFrame = new WrappedDataFrame(dataFrame);
            this.dataFrame.addOriginalColumns();
        }
        this.treeMapModel.setDataFrame(this.dataFrame);
        this.subsetDataFrame.setDataFrame(this.dataFrame);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void save() {
    }
}

