/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JProgressBar;
import javax.swing.plaf.synth.SynthContext;

public class ProgressBarPainter
extends de.javasoft.plaf.synthetica.painter.ProgressBarPainter {
    private static final float ARC = 4.0f;

    public void paintProgressBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JProgressBar pb = (JProgressBar)sc.getComponent();
        int orientation = pb.getOrientation();
        Insets stInsets = sc.getStyle().getInsets(sc, null);
        Insets insets = pb.getInsets();
        Graphics2D g2 = this.prepareGraphics2D(sc, g, x += insets.left - stInsets.left, y += insets.top - stInsets.top, true);
        Shape shape = this.createShape(0.0f, 0.0f, ProgressBarPainter.calcRelativeLength((Graphics2D)g2, (float)(w -= insets.left + insets.right - stInsets.left - stInsets.right), (float)0.0f), ProgressBarPainter.calcRelativeLength((Graphics2D)g2, (float)(h -= insets.top + insets.bottom - stInsets.top - stInsets.bottom), (float)0.0f), this.scaleArc(4.0f));
        float borderWidth = 1.0f;
        if (orientation == 0) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, (float)h - 1.0f, -borderWidth), new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(0xFFFFFF), new Color(0xF7F7F7), new Color(0xECECEC), new Color(0xF7F7F7), new Color(0xFFFFFF)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, (float)w - 1.0f, -borderWidth), 0.0f, new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(0xFFFFFF), new Color(0xF7F7F7), new Color(0xECECEC), new Color(0xF7F7F7), new Color(0xFFFFFF)}));
        }
        g2.fill(ProgressBarPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        this.restoreGraphics2D(g2);
        if (pb.getBorder() != null && !pb.getBorder().getClass().getName().endsWith(".synth.SynthBorder")) {
            this.paintProgressBarBorder(sc, g2, x, y, w, h);
        }
    }

    public void paintProgressBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JProgressBar pb = (JProgressBar)sc.getComponent();
        Graphics2D g2 = this.prepareGraphics2D(sc, g, x, y, true);
        Shape shape = this.createShape(0.0f, 0.0f, ProgressBarPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ProgressBarPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), this.scaleArc(4.0f));
        if (pb.getOrientation() == 0) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, (float)h - 1.0f, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(0x33000000, true), new Color(0x4C000000, true)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, (float)w - 1.0f, 0.0f), 0.0f, new float[]{0.0f, 1.0f}, new Color[]{new Color(0x33000000, true), new Color(0x4C000000, true)}));
        }
        g2.draw(shape);
        this.restoreGraphics2D(g2);
    }

    public void paintProgressBarForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        JProgressBar pb = (JProgressBar)sc.getComponent();
        Insets insets = pb.getInsets();
        int wBar = pb.getWidth() - insets.left - insets.right;
        int hBar = pb.getHeight() - insets.top - insets.bottom;
        if (!pb.isIndeterminate()) {
            boolean ltr = pb.getComponentOrientation().isLeftToRight();
            x = ltr ? insets.left : wBar + insets.left - w;
            y = orientation == 0 ? insets.top : hBar - h + insets.top;
            w = orientation == 0 ? w : wBar;
            int n = h = orientation == 0 ? hBar : h;
        }
        if (w <= 1 || h <= 1) {
            return;
        }
        Graphics2D g2 = this.prepareGraphics2D(sc, g, x, y, true);
        Shape shape = this.createShape(0.0f, 0.0f, ProgressBarPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ProgressBarPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), this.scaleArc(4.0f));
        if ((sc.getComponentState() & 8) > 0) {
            g2.setPaint(new Color(0x1F000000, true));
        } else {
            float borderWidth = 1.0f;
            if (orientation == 0) {
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -borderWidth), new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(1601228031, true), new Color(1602275319, true), new Color(-2139569937, true), new Color(1602275319, true), new Color(1601228031, true)}));
            } else {
                g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, w - 1, -borderWidth), 0.0f, new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(1601228031, true), new Color(1602275319, true), new Color(-2139569937, true), new Color(1602275319, true), new Color(1601228031, true)}));
            }
        }
        g2.fill(ProgressBarPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        this.restoreGraphics2D(g2);
    }

    private Shape createShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(0.0f, 0.0f, w, h, arc, arc);
    }
}

