/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.RowMajorDataModel;
import com.macrofocus.data.SimpleDataModel;
import com.macrofocus.data.row.RowModel;
import com.macrofocus.geo.map.Geometry;
import com.macrofocus.geo.map.LayerModel;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class SimpleLayerModel<G extends Geometry>
implements LayerModel<G>,
Externalizable {
    private static final long serialVersionUID = 3420491172402523865L;
    private String name;
    private List<G> polygons;
    private Rectangle2D bounds;
    private DataModel dataModel;

    public SimpleLayerModel() {
    }

    public SimpleLayerModel(String name) {
        this.name = name;
        this.polygons = new ArrayList<G>();
        this.dataModel = new RowMajorDataModel();
        this.bounds = null;
    }

    public void addGeometry(G polygon, RowModel row) {
        if (this.bounds == null) {
            Rectangle2D b = polygon.getBounds();
            this.bounds = new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
        } else {
            this.bounds.add(polygon.getBounds());
        }
        this.polygons.add(polygon);
        if (this.dataModel instanceof RowMajorDataModel && row != null) {
            ((RowMajorDataModel)this.dataModel).addRowModel(row);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public Iterable<G> getGeometries() {
        return this.polygons;
    }

    @Override
    public G getGeometry(int index) {
        return (G)((Geometry)this.polygons.get(index));
    }

    @Override
    public int getGeometryCount() {
        return this.polygons.size();
    }

    @Override
    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void pack() {
        this.dataModel = new SimpleDataModel(this.dataModel);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeUTF(this.name);
        out.writeInt(this.polygons.size());
        for (Geometry geometry : this.polygons) {
            out.writeObject(geometry);
        }
        if (!(this.dataModel instanceof SimpleDataModel)) {
            this.dataModel = new SimpleDataModel(this.dataModel);
        }
        out.writeObject(this.dataModel);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            this.name = in.readUTF();
            int size = in.readInt();
            this.polygons = new ArrayList<G>(size);
            for (int i = 0; i < size; ++i) {
                this.addGeometry((Geometry)in.readObject(), null);
            }
            this.dataModel = (DataModel)in.readObject();
        }
    }
}

