/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.geo.map.Point;
import com.macrofocus.geo.map.Polygon;
import com.macrofocus.geo.map.SimplePoint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class SimplePolygon
implements Polygon,
Externalizable {
    private static final long serialVersionUID = 7680818795446624154L;
    private List<Point> points;
    private Rectangle2D bounds = null;
    private GeneralPath path = null;
    private Double area = null;

    public SimplePolygon() {
        this.points = new ArrayList<Point>();
    }

    public SimplePolygon(List<Point> points) {
        this.points = new ArrayList<Point>(points.size());
        for (Point point : points) {
            this.points.add(point);
        }
    }

    public SimplePolygon(Point[] points) {
        for (int i = 0; i < points.length; ++i) {
            Point point = points[i];
            this.points.add(point);
        }
    }

    public void addPoint(Point point) {
        this.points.add(point);
        this.bounds = null;
        this.path = null;
        this.area = null;
    }

    @Override
    public Iterable<Point> getPoints() {
        return this.points;
    }

    @Override
    public Point getPoint(int i) {
        return this.points.get(i);
    }

    @Override
    public int getPointCount() {
        return this.points.size();
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            for (Point point : this.points) {
                if (this.bounds == null) {
                    this.bounds = new Rectangle2D.Double(point.getX(), point.getY(), 0.0, 0.0);
                    continue;
                }
                this.bounds.add(point.getX(), point.getY());
            }
        }
        return this.bounds;
    }

    @Override
    public Shape getShape() {
        if (this.path == null) {
            this.path = new GeneralPath();
            this.path.moveTo((float)this.points.get(0).getX(), (float)this.points.get(0).getY());
            for (int pi = 1; pi < this.points.size(); ++pi) {
                Point p = this.points.get(pi);
                this.path.lineTo((float)p.getX(), (float)p.getY());
            }
            this.path.closePath();
        }
        return this.path;
    }

    @Override
    public double getArea() {
        if (this.area == null) {
            double area = 0.0;
            for (int i = 0; i < this.points.size() - 1; ++i) {
                area -= 0.5 * (this.points.get(i).getX() + this.points.get(i + 1).getX()) * (this.points.get(i + 1).getY() - this.points.get(i).getY());
            }
            this.area = area -= 0.5 * (this.points.get(this.points.size() - 1).getX() + this.points.get(0).getX()) * (this.points.get(0).getY() - this.points.get(this.points.size() - 1).getY());
        }
        return this.area;
    }

    @Override
    public boolean isCrossing(double x, double y) {
        boolean c = false;
        int i = 0;
        int j = this.points.size() - 1;
        while (i < this.points.size()) {
            if ((this.points.get(i).getY() <= y && y < this.points.get(j).getY() || this.points.get(j).getY() <= y && y < this.points.get(i).getY()) && x < (this.points.get(j).getX() - this.points.get(i).getX()) * (y - this.points.get(i).getY()) / (this.points.get(j).getY() - this.points.get(i).getY()) + this.points.get(i).getX()) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeInt(this.points.size());
        for (Point p : this.points) {
            out.writeFloat((float)p.getX());
            out.writeFloat((float)p.getY());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            int size = in.readInt();
            this.points = new ArrayList<Point>(size);
            for (int i = 0; i < size; ++i) {
                this.addPoint(new SimplePoint(in.readFloat(), in.readFloat()));
            }
        }
    }
}

