/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.view;

import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.Row;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.geo.model.GeoListener;
import com.macrofocus.geo.model.GeoModel;
import com.macrofocus.geo.view.GeoRenderer;
import com.macrofocus.geo.view.Java2DConverter;
import com.macrofocus.geo.view.SimpleGeoRenderer;
import com.macrofocus.soom.coordinator.AspectRangesCoordinator;
import com.macrofocus.soom.coordinator.RangesCoordinateAxisCoordinator;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisListener;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.coordinate.OptimizedRangeCoordinateAxisModel;
import com.macrofocus.timing.BoundedRangeTimingTarget;
import com.macrofocus.timing.TimingHelper;
import com.macrofocus.util.java2d.RenderingHintsModel;
import com.macrofocus.util.range.MBoundedRangeModel;
import com.macrofocus.util.range.SimpleBoundedRangeModel;
import com.macrofocus.util.swing.MComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.TimingTarget;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class GeoView
extends MComponent {
    private GeoModel interactiveModel;
    private List<GeoModel> models;
    private Map<GeoModel, GeoRenderer> renderers;
    private final MBoundedRangeModel xRangeModel;
    private final MBoundedRangeModel yRangeModel;
    private final CoordinateAxisModel xCoordinateAxis;
    private final CoordinateAxisModel yCoordinateAxis;
    private Animator animator;
    private boolean fps = false;
    private double resolution = 0.025;
    private double verticalAlignment = 0.5;
    private double horizontalAlignment = 0.5;
    private final GeoListener listener = new GeoListener(){

        @Override
        public void geoChanged() {
            GeoView.this.repaint();
        }
    };
    private SelectionListener<Row> selectionListener = new SelectionListener<Row>(){

        public void selectionChanged(SelectionEvent<Row> rowSelectionEvent) {
            GeoView.this.repaint();
        }
    };
    private FilterListener<Row> filterListener = new FilterListener<Row>(){

        public void filterChanged(FilterEvent<Row> event) {
            GeoView.this.repaint();
        }
    };
    private SelectionListener<Column> colorColumnListener = new SelectionListener<Column>(){

        public void selectionChanged(SelectionEvent<Column> event) {
            GeoView.this.repaint();
        }
    };
    Java2DConverter converter = new Java2DConverter(new Java2DConverter.PointConverter(){

        @Override
        public Point2D toViewPoint(Coordinate modelCoordinate) {
            return new Point2D.Double(GeoView.this.xCoordinateAxis.worldToScreen(modelCoordinate.getX()), GeoView.this.yCoordinateAxis.worldToScreen(modelCoordinate.getY()));
        }

        @Override
        public double getScale() {
            return (GeoView.this.xRangeModel.getMaximum() - GeoView.this.xRangeModel.getMinimum()) / GeoView.this.xRangeModel.getExtent();
        }
    }, this.resolution);

    public Point2D modelToView(double x, double y) {
        return new Point2D.Double(this.xCoordinateAxis.worldToScreen(x), this.yCoordinateAxis.worldToScreen(y));
    }

    public GeoView(RenderingHintsModel renderingHintsModel) {
        super(renderingHintsModel);
        this.setOpaque(true);
        Dimension d = this.getSize();
        this.models = new ArrayList<GeoModel>();
        this.renderers = new HashMap<GeoModel, GeoRenderer>();
        this.xRangeModel = new SimpleBoundedRangeModel(0.0, (double)Math.max(1, d.width), 0.0, (double)Math.max(1, d.width));
        this.yRangeModel = new SimpleBoundedRangeModel(0.0, (double)Math.max(1, d.height), 0.0, (double)Math.max(1, d.height));
        this.xCoordinateAxis = new OptimizedRangeCoordinateAxisModel(this.xRangeModel);
        this.yCoordinateAxis = new OptimizedRangeCoordinateAxisModel(this.yRangeModel);
        this.yCoordinateAxis.setDeviceCoordinatesInverted(true);
        this.xCoordinateAxis.setScreenSize(d.width);
        this.yCoordinateAxis.setScreenSize(d.height);
        new RangesCoordinateAxisCoordinator(this.xRangeModel, this.yRangeModel);
        new AspectRangesCoordinator(this.xRangeModel, this.yRangeModel, (Component)((Object)this));
        this.xCoordinateAxis.addCoordinateListener(new CoordinateAxisListener(){

            public void rangeChanged(CoordinateAxisEvent e) {
                GeoView.this.repaint();
            }
        });
        this.yCoordinateAxis.addCoordinateListener(new CoordinateAxisListener(){

            public void rangeChanged(CoordinateAxisEvent e) {
                GeoView.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = GeoView.this.getSize();
                GeoView.this.xCoordinateAxis.setScreenSize(d.width);
                GeoView.this.yCoordinateAxis.setScreenSize(d.height);
            }
        });
    }

    public void setInteractiveModel(GeoModel interactiveModel) {
        if (this.interactiveModel != null) {
            this.interactiveModel.removeListener(this.listener);
            this.interactiveModel.getProbing().removeSelectionListener(this.selectionListener);
            this.interactiveModel.getSelection().removeSelectionListener(this.selectionListener);
            this.interactiveModel.getFilter().removeFilterListener(this.filterListener);
            this.interactiveModel.getColorColumn().removeSelectionListener(this.colorColumnListener);
        }
        this.interactiveModel = interactiveModel;
        if (this.interactiveModel != null) {
            interactiveModel.addListener(this.listener);
            interactiveModel.getProbing().addSelectionListener(this.selectionListener);
            interactiveModel.getSelection().addSelectionListener(this.selectionListener);
            interactiveModel.getFilter().addFilterListener(this.filterListener);
            interactiveModel.getColorColumn().addSelectionListener(this.colorColumnListener);
        }
        this.repaint();
    }

    public void setModel(GeoModel model) {
        this.models.clear();
        this.renderers.clear();
        this.addModel(model);
    }

    public void addModel(GeoModel model) {
        if (this.models.isEmpty()) {
            this.setInteractiveModel(model);
        }
        this.models.add(model);
        this.setRenderer(model, this.createGeoRenderer(model));
        Rectangle2D.Double bounds = null;
        for (GeoModel geoModel : this.models) {
            Rectangle2D.Double b = geoModel.getBounds();
            if (b == null) continue;
            if (bounds != null) {
                bounds.add(b);
                continue;
            }
            bounds = b;
        }
        if (bounds != null) {
            double rangeX = bounds.getWidth();
            double rangeY = bounds.getHeight();
            double range = Math.max(rangeX, rangeY);
            double minX = bounds.getMinX();
            double maxX = bounds.getMaxX();
            double minY = bounds.getMinY();
            double maxY = bounds.getMaxY();
            this.xRangeModel.setMinMax((Object)this, minX, maxX);
            this.yRangeModel.setMinMax((Object)this, minY, maxY);
            this.xRangeModel.setValue((Object)this, minX, maxX - minX);
            this.yRangeModel.setValue((Object)this, minY, maxY - minY);
            this.adjust();
        }
    }

    protected GeoRenderer createGeoRenderer(GeoModel model) {
        return new SimpleGeoRenderer();
    }

    public void removeModel(GeoModel model) {
        if (model == this.interactiveModel) {
            this.setInteractiveModel(null);
        }
        this.models.remove(model);
        this.removeRenderer(model);
        this.repaint();
    }

    public void removeModels() {
        for (GeoModel model : this.models) {
            this.removeRenderer(model);
        }
        this.models.clear();
        this.interactiveModel = null;
        this.repaint();
    }

    public Iterable<GeoModel> getModels() {
        return this.models;
    }

    public void setRenderer(GeoModel model, GeoRenderer renderer) {
        this.renderers.put(model, renderer);
        this.repaint();
    }

    public void removeRenderer(GeoModel model) {
        this.renderers.remove(model);
        this.repaint();
    }

    public void paintComponent(Graphics gr) {
        long current = System.currentTimeMillis();
        Graphics2D g2 = (Graphics2D)gr;
        gr.setColor(this.getBackground());
        gr.fillRect(0, 0, this.getSize().width, this.getSize().height);
        for (GeoModel model : this.getModels()) {
            this.renderers.get(model).render(g2, this, model);
        }
        if (this.fps) {
            g2.setColor(Color.red);
            g2.drawString(System.currentTimeMillis() - current + " milliseconds", 5, this.getSize().height - 5);
        }
    }

    public Shape getShape(GeoModel model, int r) {
        Geometry geometry = model.getGeometry(r);
        if (geometry != null) {
            return this.getShape(geometry);
        }
        return null;
    }

    public Shape getShape(Geometry geometry) {
        return this.converter.toShape(geometry);
    }

    public GeoModel getInteractiveModel() {
        return this.interactiveModel;
    }

    public MBoundedRangeModel getXRangeModel() {
        return this.xRangeModel;
    }

    public MBoundedRangeModel getYRangeModel() {
        return this.yRangeModel;
    }

    public CoordinateAxisModel getXCoordinateAxis() {
        return this.xCoordinateAxis;
    }

    public CoordinateAxisModel getYCoordinateAxis() {
        return this.yCoordinateAxis;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public void zoom(boolean animate, double x1, double x2, double y1, double y2) {
        this.animator = TimingHelper.getAnimator((Animator)this.animator, (long)(animate ? 700L : 0L), (boolean)true);
        if (this.animator != null) {
            this.animator.addTarget((TimingTarget)new BoundedRangeTimingTarget(this.getXRangeModel(), x1, x2));
            this.animator.addTarget((TimingTarget)new BoundedRangeTimingTarget(this.getYRangeModel(), y1, y2));
        } else {
            this.getXRangeModel().setValue((Object)this, x1, x2 - x1);
            this.getYRangeModel().setValue((Object)this, y1, y2 - y1);
        }
        if (this.animator != null) {
            this.animator.start();
        }
    }

    public Row getRow(Point p) {
        if (this.interactiveModel != null) {
            for (int r = 0; r < this.interactiveModel.getRowCount(); ++r) {
                Shape shape = this.getShape(this.interactiveModel, r);
                if (shape == null || !shape.contains(p)) continue;
                return this.interactiveModel.getRow(r);
            }
        }
        return null;
    }

    public void setVerticalAlignment(double verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.adjust();
    }

    public void setHorizontalAlignment(double horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.adjust();
    }

    private void adjust() {
        double shareY;
        Double minX = this.xRangeModel.getMinimum();
        Double maxX = this.xRangeModel.getMaximum();
        Double minY = this.yRangeModel.getMinimum();
        Double maxY = this.yRangeModel.getMaximum();
        double shareX = (maxX - minX) / (double)this.getWidth();
        double share = Math.max(shareX, shareY = (maxY - minY) / (double)this.getHeight());
        if (!Double.isInfinite(share)) {
            this.adjust(this.getWidth(), share, this.xRangeModel, minX, maxX, this.horizontalAlignment);
            this.adjust(this.getHeight(), share, this.yRangeModel, minY, maxY, 1.0 - this.verticalAlignment);
        }
    }

    private void adjust(int size, double share, MBoundedRangeModel range, double min, double max, double alignment) {
        double desiredRange = share * (double)size;
        double diff = max - min - desiredRange;
        double newMin = min + diff * alignment;
        double newMax = max - diff * (1.0 - alignment);
        double newRange = newMax - newMin;
        double valueP = (range.getValue() - range.getMinimum()) / (range.getMaximum() - range.getMinimum());
        double extentP = range.getExtent() / (range.getMaximum() - range.getMinimum());
        range.setMinMax((Object)this, newMin, newMax);
        range.setValue((Object)this, newMin, newMax - newMin);
    }
}

