/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane.ui.controls;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.tabpane.ui.controls.IButtonFactory;
import de.javasoft.tabpane.ui.controls.TabOverviewPreviewPanel;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class TabOverviewDialog
extends JDialog {
    private JYTabbedPane tabPane;
    private IButtonFactory buttonFactory;
    private TabOverviewPanel overviewPanel;
    private PreviewThread previewThread;
    private PropertyChangeListener lafSwitchListener;

    public TabOverviewDialog(JYTabbedPane tabPane, IButtonFactory factory) {
        super(SwingUtilities.getWindowAncestor(tabPane) instanceof Frame ? (Frame)SwingUtilities.getWindowAncestor(tabPane) : (Dialog)SwingUtilities.getWindowAncestor(tabPane));
        this.tabPane = tabPane;
        this.buttonFactory = factory;
        this.setLayout(new BorderLayout());
        Rectangle screenBounds = this.getPreviewDialogScreenBounds(tabPane);
        this.installOverviewPanel(screenBounds);
        this.applyComponentOrientation(tabPane.getComponentOrientation());
        this.setTitle(UIManager.getString("JYTabbedPane.tabOverviewDialog.title"));
        this.setDefaultCloseOperation(2);
        this.setLocation(screenBounds.x, screenBounds.y);
        this.setSize(screenBounds.width, screenBounds.height);
        this.setResizable(false);
        this.installListener();
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CloseTabOverview");
        this.getRootPane().getActionMap().put("CloseTabOverview", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabOverviewDialog.this.dispose();
            }
        });
    }

    private void installListener() {
        final Window owner = SwingUtilities.getWindowAncestor(this.tabPane);
        final WindowAdapter ownerWindowListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                TabOverviewDialog.this.dispose();
            }
        };
        owner.addWindowListener(ownerWindowListener);
        final PropertyChangeListener activeWindowListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("activeWindow".equals(evt.getPropertyName()) && TabOverviewDialog.this == evt.getOldValue()) {
                    TabOverviewDialog.this.dispose();
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(activeWindowListener);
        this.lafSwitchListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.updateComponentTreeUI(TabOverviewDialog.this);
                        }
                    });
                }
            }
        };
        UIManager.addPropertyChangeListener(this.lafSwitchListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                if (TabOverviewDialog.this.previewThread != null) {
                    TabOverviewDialog.this.previewThread.interrupt();
                }
                owner.removeWindowListener(ownerWindowListener);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(activeWindowListener);
                UIManager.removePropertyChangeListener(TabOverviewDialog.this.lafSwitchListener);
            }
        });
    }

    Rectangle getPreviewDialogScreenBounds(JTabbedPane tabPane) {
        Rectangle tabPaneBounds = tabPane.getBounds();
        Point tabPaneScreenLoc = tabPane.getLocationOnScreen();
        return new Rectangle(tabPaneScreenLoc.x, tabPaneScreenLoc.y, tabPaneBounds.width, tabPaneBounds.height);
    }

    void installOverviewPanel(Rectangle screenBounds) {
        if (this.overviewPanel != null) {
            this.remove(this.overviewPanel);
        }
        int titlePaneHeight = 24;
        if (this.getRootPane().getUI() instanceof SyntheticaRootPaneUI) {
            titlePaneHeight = ((SyntheticaRootPaneUI)this.getRootPane().getUI()).getTitlePane().getPreferredSize().height;
        }
        Insets insets = this.getRootPane().getInsets();
        this.overviewPanel = new TabOverviewPanel(screenBounds.width - insets.left - insets.right, screenBounds.height - insets.top - insets.bottom - titlePaneHeight);
        this.add((Component)this.overviewPanel, "Center");
    }

    private static interface PreviewImageProvider {
        public void init(JYTabbedPane var1);

        public void provide(JYTabbedPane var1, int var2, BufferedImage var3, int var4, int var5);
    }

    private class PreviewThread
    extends Thread {
        private int tabPreviewIndex;
        private PreviewImageProvider provider;
        private boolean processing;

        public PreviewThread(int tabPreviewIndex, PreviewImageProvider provider) {
            this.tabPreviewIndex = tabPreviewIndex;
            this.provider = provider;
            this.setName("JYTabbedPane-TabPreview");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    int refresh;
                    if (!this.processing) {
                        this.processing = true;
                        this.provider.init(TabOverviewDialog.this.tabPane);
                        if (this.tabPreviewIndex >= 0) {
                            this.setPreviewImage(TabOverviewDialog.this.tabPane, this.tabPreviewIndex, this.getPreviewImageWidth(), this.getPreviewImageHeight(), true);
                        } else {
                            int tabCount = TabOverviewDialog.this.tabPane.getTabCount();
                            int i = 0;
                            while (i < tabCount) {
                                this.setPreviewImage(TabOverviewDialog.this.tabPane, i, this.getPreviewImageWidth(), this.getPreviewImageHeight(), tabCount - 1 == i);
                                ++i;
                            }
                        }
                    }
                    if ((refresh = SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.tabOverview.refreshTime", (Component)TabOverviewDialog.this.tabPane, (int)-1)) <= 0) break;
                    Thread.sleep(Math.max(100, refresh));
                }
                catch (InterruptedException ie) {
                    this.interrupt();
                }
            }
        }

        private int getPreviewImageWidth() {
            return Math.max(0, TabOverviewDialog.this.overviewPanel.previewWidth - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).previewPanelInsets.left - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).previewPanelInsets.right - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).tabOverviewGridInsets.left - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).tabOverviewGridInsets.right);
        }

        private int getPreviewImageHeight() {
            return Math.max(0, TabOverviewDialog.this.overviewPanel.previewHeight - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).previewPanelInsets.top - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).previewPanelInsets.bottom - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).tabOverviewGridInsets.top - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).tabOverviewGridInsets.bottom);
        }

        private void setPreviewImage(final JYTabbedPane tabPane, final int tabIndex, final int previewWidth, final int previewHeight, final boolean isLastTab) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (tabIndex < tabPane.getTabCount()) {
                        boolean center = SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabOverview.centerThumbnails", (Component)tabPane, (boolean)true);
                        BufferedImage image = WidgetUtils.createPreviewImage(tabPane.getComponentAt(tabIndex), 0, 0, previewWidth, previewHeight, center);
                        PreviewThread.this.provider.provide(tabPane, tabIndex, image, previewWidth, previewHeight);
                        PreviewThread.this.processing = !isLastTab;
                    }
                }
            });
        }
    }

    private class TabOverviewPanel
    extends JPanel {
        private TabOverviewPreviewPanel[] previewPanels;
        private Insets overviewPanelInsets;
        private Insets previewPanelInsets;
        private Insets tabOverviewGridInsets;
        private int previewWidth;
        private int previewHeight;

        public TabOverviewPanel(final int width, final int height) {
            this.setName("JYTabbedPane.TabOverviewPanel");
            this.overviewPanelInsets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.tabOverviewPanel.insets", (Component)TabOverviewDialog.this.tabPane, (Insets)new Insets(1, 1, 1, 1), (boolean)true);
            this.setBorder(new EmptyBorder(this.overviewPanelInsets));
            this.previewPanelInsets = TabOverviewPreviewPanel.getPreviewPanelInsets(TabOverviewDialog.this.tabPane);
            this.tabOverviewGridInsets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.tabOverview.gridInsets", (Component)TabOverviewDialog.this.tabPane, (Insets)new Insets(1, 1, 1, 1), (boolean)true);
            PreviewImageProvider provider = new PreviewImageProvider(){

                @Override
                public void init(final JYTabbedPane tabPane) {
                    final int tabCount = tabPane.getTabCount();
                    final int columns = TabOverviewPanel.this.calcColumns(tabCount);
                    TabOverviewPanel.this.initPreviewSize(width, height, columns);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GridBagConstraints gbc = new GridBagConstraints();
                            gbc.weightx = 0.0;
                            gbc.weighty = 0.0;
                            gbc.insets = TabOverviewPanel.this.tabOverviewGridInsets;
                            gbc.anchor = 23;
                            if (TabOverviewPanel.this.previewPanels == null || TabOverviewPanel.this.previewPanels.length != tabCount) {
                                TabOverviewPanel.this.removeAll();
                                TabOverviewPanel.this.previewPanels = new TabOverviewPreviewPanel[tabCount];
                                int i = 0;
                                while (i < tabCount) {
                                    TabOverviewPreviewPanel previewPanel = new TabOverviewPreviewPanel(tabPane, i, TabOverviewDialog.this.buttonFactory);
                                    previewPanel.setPreferredSize(new Dimension(TabOverviewPanel.this.previewWidth, TabOverviewPanel.this.previewHeight));
                                    previewPanel.setMinimumSize(new Dimension(TabOverviewPanel.this.previewWidth, TabOverviewPanel.this.previewHeight));
                                    ((TabOverviewPanel)(this).TabOverviewPanel.this).previewPanels[i] = previewPanel;
                                    gbc.gridx = i % columns;
                                    gbc.gridy = i / columns;
                                    TabOverviewPanel.this.add((Component)previewPanel, gbc);
                                    ++i;
                                }
                                ++gbc.gridy;
                                gbc.fill = 3;
                                gbc.weighty = 1.0;
                                Box vFiller = Box.createVerticalBox();
                                TabOverviewPanel.this.add((Component)vFiller, gbc);
                                TabOverviewPanel.this.repaint();
                            }
                        }
                    });
                }

                @Override
                public void provide(JYTabbedPane tabPane, int tabIndex, BufferedImage preview, int w, int h) {
                    TabOverviewPanel.this.previewPanels[tabIndex].setPreviewImage(preview, w, h);
                }
            };
            this.setLayout(new GridBagLayout());
            provider.init(TabOverviewDialog.this.tabPane);
            TabOverviewDialog.this.previewThread = new PreviewThread(-1, provider);
            TabOverviewDialog.this.previewThread.start();
        }

        private int calcColumns(int tabCount) {
            int cols = (int)Math.sqrt(tabCount);
            if (cols * cols < tabCount) {
                ++cols;
            }
            return cols;
        }

        private void initPreviewSize(int width, int height, int columns) {
            this.previewWidth = columns == 0 ? 0 : (width - this.overviewPanelInsets.left - this.overviewPanelInsets.right) / columns;
            this.previewHeight = columns == 0 ? 0 : (height - this.overviewPanelInsets.top - this.overviewPanelInsets.bottom) / columns;
        }
    }
}

