/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class SyntheticaState {
    private int cState = 0;

    public SyntheticaState() {
    }

    public SyntheticaState(int state) {
        this();
        this.cState = state;
    }

    public SyntheticaState(State state) {
        this.setState(state);
    }

    public int getState() {
        return this.cState;
    }

    public void setState(int state) {
        this.cState = state;
    }

    public void setState(State state) {
        this.cState |= state.toInt();
    }

    public void resetState(State state) {
        if (this.isSet(state)) {
            this.cState ^= state.toInt();
        }
    }

    public boolean isSet(State state) {
        return (this.getState() & state.toInt()) > 0;
    }

    public boolean isSet(int state) {
        return (this.getState() & state) != 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SyntheticaState) {
            return ((SyntheticaState)obj).getState() == this.getState();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        State[] stateArray = State.values();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            if ((this.getState() & state.toInt()) != 0) {
                sb.append(':');
                sb.append((Object)state);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static enum State {
        UNDEFINED("UNDEFINED", 0),
        ENABLED("ENABLED", 1),
        HOVER("HOVER", 2),
        PRESSED("PRESSED", 4),
        DISABLED("DISABLED", 8),
        FOCUSED("FOCUSED", 256),
        SELECTED("SELECTED", 512),
        DEFAULT("DEFAULT", 1024),
        LOCKED("LOCKED", 2048),
        ACTIVE("ACTIVE", 4096);

        private int state;
        private String name;
        private static Map<String, State> states;

        static {
            states = new HashMap<String, State>();
            State[] stateArray = State.values();
            int n = stateArray.length;
            int n2 = 0;
            while (n2 < n) {
                State state = stateArray[n2];
                states.put(state.name, state);
                ++n2;
            }
        }

        private State(String name, int state) {
            this.name = name;
            this.state = state;
        }

        public static State parse(String s) throws ParseException {
            State state = states.get(s.toUpperCase());
            if (state == null) {
                throw new ParseException("Unsupported state: " + s, -1);
            }
            return state;
        }

        public int toInt() {
            return this.state;
        }

        public String toString() {
            return this.name;
        }
    }
}

