/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.AnimationThreadFactory;
import de.javasoft.plaf.synthetica.util.HiDpi;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.ColorUIResource;

public class ImagePainter {
    public static final Logger logger = Logger.getLogger(ImagePainter.class.getName());
    public static final int STRETCHED = 0;
    public static final int TILED = 1;
    private Graphics g;
    private int x;
    private int y;
    private int w;
    private int h;
    private int iw;
    private int ih;
    private Image image;
    private Insets sInsets;
    private Insets dInsets;
    private int xPolicy;
    private int yPolicy;
    private WeakReference<JComponent> weakComponent;
    private AnimationThreadFactory.AnimationThread animationThread;
    private String id;
    private int angle = 0;
    private boolean flipHorizontal;
    private boolean flipVertical;
    private boolean animationEnabled;
    private static long initDuration = -1L;
    private static int initOperations = 0;
    private static long paintDuration = 0L;
    private static int paintOperations = 0;
    private static HashMap<String, Image> imageCache = new HashMap();
    private static boolean debug = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.debug");
    private static final String SYNTHETICA_BACKGROUND = "Synthetica.background";
    private static final String SYNTHETICA_BACKGROUND_ALPHA = "Synthetica.background.alpha";
    private static final String SYNTHETICA_BLEND_MODE = "Synthetica.background.blendMode";
    private static final String SYNTHETICA_DEFAULT_BLEND_MODE = "Synthetica.background.defaultBlendMode";
    private static final boolean RESPECT_PARENT_BACKGROUND = SyntheticaLookAndFeel.getBoolean("Synthetica.background.respectParent", null, false);

    public ImagePainter(JComponent c, int cycles, int delay, int type, int state, Graphics g, int x, int y, int w, int h, String imagePaths, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        this(c, null, cycles, delay, type, state, g, x, y, w, h, imagePaths, sourceInsets, destinationInsets, xPolicy, yPolicy);
    }

    public ImagePainter(JComponent c, String id, int cycles, int delay, int type, int state, Graphics g, int x, int y, int w, int h, String imagePaths, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        this(c, id, cycles, delay, type, state, g, x, y, w, h, imagePaths, sourceInsets, destinationInsets, xPolicy, yPolicy, false, false);
    }

    public ImagePainter(JComponent c, String id, int cycles, int delay, int type, int state, Graphics g, int x, int y, int w, int h, String imagePaths, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy, boolean hFlip, boolean vFlip) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Image Path: " + imagePaths);
        }
        if (!debug && imagePaths == null) {
            return;
        }
        if (debug && initDuration == -1L) {
            Frame[] frames = Frame.getFrames();
            int i = 0;
            while (i < frames.length) {
                if (frames[i] instanceof JFrame) {
                    ((JFrame)frames[i]).getRootPane().registerKeyboardAction(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            System.out.println("inits: " + initOperations + " in " + initDuration + " ms");
                            System.out.println("paint: " + paintOperations + " in " + paintDuration + " ms");
                            initDuration = 0L;
                            initOperations = 0;
                            paintDuration = 0L;
                            paintOperations = 0;
                            Frame[] frames = Frame.getFrames();
                            int i = 0;
                            while (i < frames.length) {
                                Frame frame = frames[i];
                                if (frame instanceof JFrame && ((JFrame)frame).getRootPane() != null) {
                                    frame.setSize(640, 550);
                                    frame.validate();
                                    ((JFrame)frame).getRootPane().repaint();
                                }
                                ++i;
                            }
                        }
                    }, "durationAction", KeyStroke.getKeyStroke(123, 640), 1);
                }
                ++i;
            }
        }
        long start = System.currentTimeMillis();
        if (id == null) {
            id = "null";
        }
        this.id = id;
        this.flipHorizontal = hFlip;
        this.flipVertical = vFlip;
        if (c != null) {
            this.weakComponent = new WeakReference<JComponent>(c);
            if (c.getClientProperty("Synthetica.flipHorizontal") != null && ((Boolean)c.getClientProperty("Synthetica.flipHorizontal")).booleanValue()) {
                this.flipHorizontal = true;
            }
            if (c.getClientProperty("Synthetica.flipVertical") != null && ((Boolean)c.getClientProperty("Synthetica.flipVertical")).booleanValue()) {
                this.flipVertical = true;
            }
        }
        if (this.flipHorizontal) {
            sourceInsets = this.flipLeftRight(sourceInsets);
            destinationInsets = this.flipLeftRight(destinationInsets);
        }
        if (this.flipVertical) {
            sourceInsets = this.flipTopBottom(sourceInsets);
            destinationInsets = this.flipTopBottom(destinationInsets);
        }
        String[] paths = imagePaths.split(",");
        this.animationEnabled = this.isAnimationEnabled(c);
        if (this.animationEnabled && c != null && delay > 0) {
            AnimationThreadFactory.AnimationThread at = AnimationThreadFactory.createThread(delay);
            Rectangle repaintRect = new Rectangle(x, y, w, h);
            if (c instanceof JTabbedPane && !id.equals("null")) {
                repaintRect = ((JTabbedPane)c).getBoundsAt(Integer.parseInt(id.split("/")[1]));
            }
            at.addComponent(c, this.id, state, type, paths, cycles, repaintRect);
            this.animationThread = at;
        }
        this.g = g;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.image = imageCache.get(path);
            if (this.image == null) {
                URL url = SyntheticaLookAndFeel.getResource(path);
                if (url == null) {
                    throw new RuntimeException("File not found: " + path);
                }
                try {
                    this.image = this.toCompatibleImage(ImageIO.read(url), true, this.isHiDpiImage(path));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                imageCache.put(path, this.image);
            }
            ++n2;
        }
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
        this.sInsets = sourceInsets == null ? null : SyntheticaLookAndFeel.getInstance().scaleInsets(sourceInsets);
        this.dInsets = destinationInsets == null ? null : SyntheticaLookAndFeel.getInstance().scaleInsets(destinationInsets);
        this.xPolicy = xPolicy;
        this.yPolicy = yPolicy;
        if (debug) {
            long stop = System.currentTimeMillis();
            long duration = stop - start;
            initDuration += duration;
            ++initOperations;
        }
    }

    private Insets flipLeftRight(Insets insets) {
        if (insets == null) {
            return null;
        }
        return new Insets(insets.top, insets.right, insets.bottom, insets.left);
    }

    private Insets flipTopBottom(Insets insets) {
        if (insets == null) {
            return null;
        }
        return new Insets(insets.bottom, insets.left, insets.top, insets.right);
    }

    private boolean isAnimationEnabled(JComponent c) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.animation.enabled", c, true);
    }

    public ImagePainter(JComponent c, Graphics g, int x, int y, int w, int h, String imagePaths, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        this(c, -1, -1, -1, -1, g, x, y, w, h, imagePaths, sourceInsets, destinationInsets, xPolicy, yPolicy);
    }

    public ImagePainter(Graphics g, int x, int y, int w, int h, String imagePath, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        this(null, g, x, y, w, h, imagePath, sourceInsets, destinationInsets, xPolicy, yPolicy);
    }

    public ImagePainter(JComponent c, int red, int green, int blue, Insets colorizeInsets, Graphics g, int x, int y, int w, int h, String imagePath, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        this(c, red, green, blue, colorizeInsets, g, x, y, w, h, imagePath, sourceInsets, destinationInsets, xPolicy, yPolicy, false, false);
    }

    public ImagePainter(JComponent c, int red, int green, int blue, Insets colorizeInsets, Graphics g, int x, int y, int w, int h, String imagePath, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy, boolean hFlip, boolean vFlip) {
        this(c, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sourceInsets, destinationInsets, xPolicy, yPolicy, hFlip, vFlip);
        if (!debug && imagePath == null) {
            return;
        }
        Image image = imageCache.get(imagePath);
        if (image == null || !(image instanceof BufferedImage)) {
            try {
                image = this.toCompatibleImage(ImageIO.read(SyntheticaLookAndFeel.getResource(imagePath)), true, this.isHiDpiImage(imagePath));
                imageCache.put(imagePath, image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.image = c.createImage(new FilteredImageSource(image.getSource(), new Colorizer(0, red, green, blue, image.getWidth(null), image.getHeight(null), colorizeInsets)));
    }

    public ImagePainter(JComponent c, Graphics g, int x, int y, int w, int h, String imagePath, Insets sInsets, Insets dInsets, Insets sInsets2, Insets dInsets2, int xPolicy, int yPolicy) {
        this(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
        String key = String.valueOf(imagePath) + "_EXCLUDED_OUTER_INSETS";
        Image image = imageCache.get(key);
        if (image == null) {
            int w2 = SyntheticaLookAndFeel.getInstance().scaleInteger(this.iw - sInsets.left - sInsets.right);
            int h2 = SyntheticaLookAndFeel.getInstance().scaleInteger(this.ih - sInsets.top - sInsets.bottom);
            BufferedImage bi = new BufferedImage(w2, h2, 2);
            Graphics2D g_ = bi.createGraphics();
            this.g = g_;
            this.x = 0;
            this.y = 0;
            this.w = w2;
            this.h = h2;
            this.draw();
            g_.dispose();
            imageCache.put(key, bi);
            image = bi;
            this.g = g;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
        this.image = image;
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
        this.sInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(sInsets2);
        this.dInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(dInsets2);
    }

    public ImagePainter(Image image, Graphics g, int x, int y, int w, int h, Insets sourceInsets, Insets destinationInsets) {
        this(image, g, x, y, w, h, sourceInsets, destinationInsets, true);
    }

    public ImagePainter(Image image, Graphics g, int x, int y, int w, int h, Insets sourceInsets, Insets destinationInsets, boolean scale) {
        this.image = this.toCompatibleImage(image, scale, false);
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
        this.g = g;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.sInsets = scale ? SyntheticaLookAndFeel.getInstance().scaleInsets(sourceInsets) : sourceInsets;
        this.dInsets = scale ? SyntheticaLookAndFeel.getInstance().scaleInsets(destinationInsets) : destinationInsets;
    }

    private boolean isHiDpiImage(String imagePath) {
        return imagePath.contains("@");
    }

    public static void clearImageCache() {
        imageCache.clear();
    }

    public void setAngle(int angle) {
        this.angle = angle;
        if (this.animationThread != null && this.weakComponent != null && !(this.weakComponent.get() instanceof JTabbedPane) && angle != 0) {
            this.animationThread.rotateRepaintRect((JComponent)this.weakComponent.get(), this.id);
        }
    }

    public void draw() {
        this.drawBorder();
        this.drawCenter();
    }

    public void drawBorder() {
        this.drawTopLeft();
        this.drawTopCenter();
        this.drawTopRight();
        this.drawLeft();
        this.drawRight();
        this.drawBottomLeft();
        this.drawBottomCenter();
        this.drawBottomRight();
    }

    public void drawCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y + this.dInsets.top, this.x + this.w - this.dInsets.right, this.y + this.h - this.dInsets.bottom, this.sInsets.left, this.sInsets.top, this.iw - this.sInsets.right, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawTopLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y, this.x + this.dInsets.left, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), 0, 0, this.sInsets.left, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), 0, 0);
    }

    public void drawTopRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y, this.x + this.w, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), this.iw - this.sInsets.right, 0, this.iw, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), 0, 0);
    }

    public void drawBottomLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y + this.h - this.dInsets.bottom, this.x + this.dInsets.left, this.y + this.h, 0, this.ih - this.sInsets.bottom, this.sInsets.left, this.ih, 0, 0);
    }

    public void drawBottomRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y + this.h - this.dInsets.bottom, this.x + this.w, this.y + this.h, this.iw - this.sInsets.right, this.ih - this.sInsets.bottom, this.iw, this.ih, 0, 0);
    }

    public void drawTopCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y, this.x + this.w - this.dInsets.right, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), this.sInsets.left, 0, this.iw - this.sInsets.right, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), this.xPolicy, this.yPolicy);
    }

    public void drawLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y + this.dInsets.top, this.x + this.dInsets.left, this.y + this.h - this.dInsets.bottom, 0, this.sInsets.top, this.sInsets.left, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y + this.dInsets.top, this.x + this.w, this.y + this.h - this.dInsets.bottom, this.iw - this.sInsets.right, this.sInsets.top, this.iw, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawBottomCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y + this.h - this.dInsets.bottom, this.x + this.w - this.dInsets.right, this.y + this.h, this.sInsets.left, this.ih - this.sInsets.bottom, this.iw - this.sInsets.right, this.ih, this.xPolicy, this.yPolicy);
    }

    /*
     * Unable to fully structure code
     */
    private void drawImage(Image image, Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, int xPolicy, int yPolicy) throws IllegalArgumentException {
        block22: {
            block21: {
                if (image == null) {
                    return;
                }
                if (this.angle != 0) {
                    this.rotateGraphics(g, true);
                }
                if (this.flipHorizontal) {
                    image = Synthetica2DUtils.flipHorizontal(image);
                }
                if (this.flipVertical) {
                    image = Synthetica2DUtils.flipVertical(image);
                }
                if (this.weakComponent != null) {
                    c = (JComponent)this.weakComponent.get();
                    background = ImagePainter.RESPECT_PARENT_BACKGROUND != false ? c.getBackground() : (c.isBackgroundSet() != false ? c.getBackground() : null);
                    alpha = (float)SyntheticaLookAndFeel.getInt("Synthetica.background.alpha", (Component)c, 10) / 100.0f;
                    if (c.getClientProperty("Synthetica.background") != null || background != null && !(background instanceof ColorUIResource) && !(background instanceof SystemColor)) {
                        if (!(image instanceof BufferedImage)) {
                            bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                            bi.getGraphics().drawImage(image, 0, 0, null);
                            image = bi;
                        }
                        background = SyntheticaLookAndFeel.getClientProperty("Synthetica.background", c, background);
                        alpha = SyntheticaLookAndFeel.getClientProperty("Synthetica.background.alpha", c, Float.valueOf(alpha)).floatValue();
                        v0 = bgAlpha = background == null ? 255 : background.getAlpha();
                        if (bgAlpha < 255) {
                            alpha = 0.99999f;
                        }
                        blendMode = SyntheticaLookAndFeel.getString("Synthetica.background.blendMode", c);
                        if ((blendMode = SyntheticaLookAndFeel.getClientProperty("Synthetica.background.blendMode", c, blendMode)) == null || blendMode.isEmpty()) {
                            if (alpha == 1.0f) {
                                blendMode = SyntheticaLookAndFeel.getString("Synthetica.background.defaultBlendMode", c, Synthetica2DUtils.BlendMode.MULTIPLY.toString());
                                image = Synthetica2DUtils.createColorizedImage((BufferedImage)image, background, blendMode);
                            } else {
                                image = Synthetica2DUtils.createColorizedImage((BufferedImage)image, background, alpha);
                            }
                        } else if (Synthetica2DUtils.BlendMode.ALPHA.toString().equals(blendMode)) {
                            image = Synthetica2DUtils.createColorizedImage((BufferedImage)image, background, alpha);
                        } else if (Synthetica2DUtils.BlendMode.valueOf(blendMode) != null) {
                            image = Synthetica2DUtils.createColorizedImage((BufferedImage)image, background, blendMode);
                        }
                    }
                }
                start = System.currentTimeMillis();
                if (xPolicy != 0 || yPolicy != 0) break block21;
                g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
                break block22;
            }
            dx = dx1;
            deltaX = sx2 - sx1;
            deltaY = sy2 - sy1;
            ** GOTO lbl64
            {
                dx2_ = dx2;
                if (xPolicy == 1) {
                    dx2_ = Math.min(dx2, dx1 + deltaX);
                }
                dy2_ = dy2;
                if (yPolicy == 1) {
                    dy2_ = Math.min(dy2, dy1 + deltaY);
                }
                sx2_ = xPolicy == 1 ? Math.min(sx2, sx1 + (dx2_ - dx1)) : sx2;
                sy2_ = yPolicy == 1 ? Math.min(sy2, sy1 + (dy2_ - dy1)) : sy2;
                g.drawImage(image, dx1, dy1, dx2_, dy2_, sx1, sy1, sx2_, sy2_, null);
                if (xPolicy == 0) ** GOTO lbl61
                dx1 += deltaX;
                do {
                    if (dx1 < dx2) continue block0;
lbl61:
                    // 2 sources

                    if (yPolicy == 0) break block0;
                    dx1 = dx;
                    dy1 += deltaY;
lbl64:
                    // 2 sources

                } while (dy1 < dy2);
            }
        }
        if (this.angle != 0) {
            this.rotateGraphics(g, false);
        }
        stop = System.currentTimeMillis();
        duration = stop - start;
        if (ImagePainter.debug && duration > 100L) {
            System.out.println("Paint performance lack: " + duration + " ms " + this.findImage(image));
        }
        ImagePainter.paintDuration += duration;
        ++ImagePainter.paintOperations;
    }

    private void rotateGraphics(Graphics g, boolean rotate) {
        Graphics2D g2 = (Graphics2D)g;
        if (rotate) {
            g2.translate(this.angle > 0 ? this.h : 0, this.angle > 0 ? 0 : this.w);
            g2.rotate(Math.toRadians(this.angle), this.x, this.y);
        } else {
            g2.rotate(Math.toRadians(-this.angle), this.x, this.y);
            g2.translate(this.angle > 0 ? -this.h : 0, this.angle > 0 ? 0 : -this.w);
        }
    }

    private String findImage(Image image) {
        String path = null;
        Set<Map.Entry<String, Image>> entries = imageCache.entrySet();
        for (Map.Entry<String, Image> entry : entries) {
            if (entry.getValue() != image) continue;
            path = entry.getKey();
            break;
        }
        return path;
    }

    private BufferedImage toCompatibleImage(Image image, boolean scale, boolean isHiDpi) {
        boolean scalingEnabled;
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (scale) {
            SyntheticaLookAndFeel sy = SyntheticaLookAndFeel.getInstance();
            w = !isHiDpi ? sy.scaleInteger(w) : sy.scaleInteger(w * 100) / sy.getHiDpiImageScaleFactor();
            h = !isHiDpi ? sy.scaleInteger(h) : sy.scaleInteger(h * 100) / sy.getHiDpiImageScaleFactor();
        }
        boolean bl = scalingEnabled = SyntheticaLookAndFeel.getInstance().getScaleFactor() != 1.0f;
        if (scale && scalingEnabled) {
            image = HiDpi.scaleImage(image, w, h);
        }
        BufferedImage compatibleImage = c.createCompatibleImage(w, h, 3);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, w, h, null);
        g.dispose();
        return compatibleImage;
    }

    private static class Colorizer
    extends RGBImageFilter {
        private int a;
        private int r;
        private int g;
        private int b;
        private int w;
        private int h;
        private Insets insets;

        public Colorizer(int alpha, int r, int g, int b, int w, int h, Insets insets) {
            this.canFilterIndexColorModel = true;
            this.a = alpha;
            this.r = r;
            this.g = g;
            this.b = b;
            this.w = w;
            this.h = h;
            this.insets = insets;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (x < this.insets.left || x > this.w - this.insets.right - 1 || y < this.insets.top || y > this.h - this.insets.bottom - 1) {
                return rgb;
            }
            Color c = new Color(rgb, true);
            int red = Math.min(Math.max(c.getRed() + c.getRed() * this.r / 100, 0), 255);
            int green = Math.min(Math.max(c.getGreen() + c.getGreen() * this.g / 100, 0), 255);
            int blue = Math.min(Math.max(c.getBlue() + c.getBlue() * this.b / 100, 0), 255);
            int alpha = Math.min(Math.max(c.getAlpha() + c.getAlpha() * this.a / 100, 0), 255);
            return new Color(red, green, blue, alpha).getRGB();
        }
    }
}

