/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;

public class PanelPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.PanelPainter";

    protected PanelPainter() {
    }

    public static PanelPainter getInstance() {
        return PanelPainter.getInstance(null);
    }

    public static PanelPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(PanelPainter.getPainterClassName(sc, PanelPainter.class, UI_KEY));
        if (instance == null) {
            instance = PanelPainter.getInstance(sc, PanelPainter.class, UI_KEY);
        }
        return (PanelPainter)instance;
    }

    public void paintPanelBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintPanelBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintPanelBackground(sc.getComponent(), new SyntheticaState(), g, x, y, w, h);
    }

    public void paintPanelBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        if (c.isOpaque() || SyntheticaLookAndFeel.getBoolean("Synthetica.panel.background.opaque", c, false)) {
            boolean backgroundImageEnabled;
            Color background = c.getBackground();
            String inactiveImagePath = this.resolveImagePath("Synthetica.panel.inactive.background.image", c);
            boolean inactive = false;
            if (inactiveImagePath != null) {
                Window win = SwingUtilities.getWindowAncestor(c);
                inactive = win != null && !win.isActive();
            }
            String imagePath = inactive ? inactiveImagePath : this.resolveImagePath("Synthetica.panel.background.image", c);
            boolean bl = backgroundImageEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.panel.background.image.enabled", c, true) && !(c.getParent() instanceof CellRendererPane);
            if (!(background == null || background instanceof ColorUIResource || backgroundImageEnabled && imagePath != null && !this.isInternalFrameContentPane(c))) {
                g.setColor(background);
                g.fillRect(x, y, w, h);
            } else if (backgroundImageEnabled && imagePath != null && (background == null || background != null && background instanceof ColorUIResource)) {
                Insets sInsets;
                int xPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.panel.background.horizontalTiled", c, false) ? 1 : 0;
                int yPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.panel.background.verticalTiled", c, false) ? 1 : 0;
                Insets dInsets = sInsets = this.getImageInsets("Synthetica.panel.background.image.insets", c);
                String origin = SyntheticaLookAndFeel.getString("Synthetica.panel.background.image.origin", c);
                if (origin != null && origin.equals("PANEL")) {
                    ImagePainter painter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
                    painter.draw();
                } else {
                    JRootPane container;
                    Container container2 = container = origin != null && origin.equals("CONTENT_PANE") ? c.getRootPane().getContentPane() : c.getRootPane();
                    if (container == null) {
                        return;
                    }
                    Rectangle bounds = container.getBounds();
                    bounds.width = Math.max(bounds.width, SyntheticaLookAndFeel.getInt("Synthetica.panel.minimumBackgroundWidth", c, bounds.width, true, false));
                    bounds.height = Math.max(bounds.height, SyntheticaLookAndFeel.getInt("Synthetica.panel.minimumBackgroundHeight", c, bounds.height, true, false));
                    boolean viewportAware = SyntheticaLookAndFeel.getClientProperty("Synthetica.panel.paintViewportAware", c, true);
                    JComponent comp = viewportAware ? this.findRelevantParent(c) : c;
                    Rectangle r = SwingUtilities.convertRectangle(comp, new Rectangle(x, y, w, h), container);
                    if (comp instanceof JViewport) {
                        JViewport v = (JViewport)comp;
                        Point p = SwingUtilities.convertPoint(c, new Point(), v);
                        Point vPos = v.getViewPosition();
                        r.x += p.x + vPos.x;
                        r.y += p.y + vPos.y;
                        Point vp = SwingUtilities.convertPoint(v, new Point(), container);
                        Dimension vDim = v.getViewSize();
                        bounds.width = vDim.width + vp.x;
                        bounds.height = vDim.height + vp.y;
                    }
                    ImagePainter painter = new ImagePainter(g, x - r.x, y - r.y, bounds.width, bounds.height, imagePath, sInsets, dInsets, xPolicy, yPolicy);
                    painter.draw();
                }
            }
        }
    }

    private boolean isInternalFrameContentPane(JComponent c) {
        return SwingUtilities.getAncestorOfClass(JInternalFrame.class, c) != null;
    }

    private Component findRelevantParent(Component c) {
        Container viewport = null;
        Container parent = c.getParent();
        while (parent != null) {
            if (parent instanceof JViewport) {
                viewport = parent;
            }
            parent = parent.getParent();
        }
        return viewport == null ? c : viewport;
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        return Cacheable.ScaleType.NINE_SQUARE;
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        return -1;
    }
}

