/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLogoRenderer;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaAddonsPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.synth.SynthContext;

public class RootPanePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.RootPanePainter";

    protected RootPanePainter() {
    }

    public static RootPanePainter getInstance() {
        return RootPanePainter.getInstance(null);
    }

    public static RootPanePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(RootPanePainter.getPainterClassName(sc, RootPanePainter.class, UI_KEY));
        if (instance == null) {
            instance = RootPanePainter.getInstance(sc, RootPanePainter.class, UI_KEY);
        }
        return (RootPanePainter)instance;
    }

    public void paintRootPaneBorder(JRootPane root, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        boolean titlePaneVisible;
        Window window = this.getWindow(root);
        boolean maximized = this.isMaximized(window);
        boolean opaque = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.opaque", window, true);
        if (maximized && opaque) {
            return;
        }
        boolean respectBorderFill = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.border.respectFill", window);
        String imagePath = "Synthetica.rootPane.border";
        if (window.isActive()) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = this.resolveImagePath(imagePath, window);
        Insets sInsets = (Insets)this.getImageInsets("Synthetica.rootPane.border.insets", window).clone();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.respectHeaderHeight", window)) {
            int height = ((SyntheticaRootPaneUI)root.getUI()).getTitlePane().getHeight();
            height += root.getJMenuBar() == null ? 0 : root.getJMenuBar().getHeight();
            sInsets.top = height += SyntheticaLookAndFeel.getInsets((String)"Synthetica.rootPane.border.size", (Component)window, (Insets)new Insets((int)4, (int)4, (int)4, (int)4), (boolean)true).top;
        }
        Insets dInsets = sInsets;
        int h_ = h;
        if (maximized) {
            if (!respectBorderFill) {
                h_ = sInsets.top;
            }
            sInsets = (Insets)this.getImageInsets("Synthetica.rootPane.border.size", window).clone();
            Insets insets = this.getImageInsets("Synthetica.rootPane.border.insets", window);
            sInsets.left = sInsets.left < insets.left ? insets.left : sInsets.left;
            sInsets.right = sInsets.right < insets.right ? insets.right : sInsets.right;
            dInsets = new Insets(0, 0, 0, 0);
        }
        int xPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.background.horizontalTiled", window)) {
            xPolicy = 1;
        }
        int yPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.background.verticalTiled", window)) {
            yPolicy = 1;
        }
        boolean evalCopy = SyntheticaRootPaneUI.isEvalCopy();
        RootPaneUI ui = root.getUI();
        String rootPaneText = ui instanceof SyntheticaRootPaneUI ? ((SyntheticaRootPaneUI)ui).getRootPaneBorderText() : null;
        int marginLeft = 0;
        int evalHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(16);
        if ((evalCopy || rootPaneText != null) && !maximized) {
            h_ -= evalHeight;
            marginLeft = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.margin.left", window, 0, true);
            x += marginLeft;
            w -= marginLeft;
        }
        this.paintBorder(root, g, x, y, w, h_, imagePath, sInsets, dInsets, xPolicy, yPolicy, window, maximized, respectBorderFill);
        imagePath = "Synthetica.rootPane.border.light";
        if (window.isActive()) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        if ((imagePath = this.resolveImagePath(imagePath, window)) != null) {
            this.paintBorder(root, g, x, y, w, h_, imagePath, sInsets, dInsets, 0, 1, window, maximized, respectBorderFill);
        }
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.paintStatusBar", window) && root.getClientProperty("Synthetica.statusBar") != null) {
            h_ = h;
            if ((evalCopy || rootPaneText != null) && !maximized) {
                h_ -= evalHeight;
            }
            int height = ((JComponent)root.getClientProperty("Synthetica.statusBar")).getHeight();
            SyntheticaAddonsPainter.getInstance("Synthetica.StatusBarPainter").paintStatusBarBackground(root, new SyntheticaState(), g, 0, h_ - (height += SyntheticaLookAndFeel.getInsets((String)"Synthetica.rootPane.border.size", (Component)window, (Insets)new Insets((int)4, (int)4, (int)4, (int)4), (boolean)true).top), w, height);
        }
        if (!maximized && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.paintTitlePaneInBorder", window, false)) {
            int lOffset = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePaneInBorder.leftOffset", window, 0, true);
            int rOffset = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePaneInBorder.rightOffset", window, 0, true);
            int height = ((SyntheticaRootPaneUI)root.getUI()).getTitlePane().getHeight();
            height += SyntheticaLookAndFeel.getInsets((String)"Synthetica.rootPane.border.size", (Component)window, (Insets)new Insets((int)4, (int)4, (int)4, (int)4), (boolean)true).top;
            if (window.isActive()) {
                state.setState(SyntheticaState.State.SELECTED);
            }
            this.paintTitlePaneBackground(root, state, g, lOffset, sInsets.top, w - lOffset - rOffset, height - sInsets.top);
        }
        imagePath = "Synthetica.rootPane.titlePane.background";
        boolean bl = titlePaneVisible = (imagePath = this.resolveImagePath(imagePath, window)) != null && opaque;
        if (!titlePaneVisible && root.getClientProperty("Synthetica.logoRenderer") != null) {
            this.renderLogo(root, window.isActive(), maximized, true, g, w, h);
        }
        if ((evalCopy || rootPaneText != null) && !maximized) {
            g.setColor(evalCopy ? UIManager.getColor("Panel.background") : SyntheticaLookAndFeel.getColor("Synthetica.rootPane.borderText.background", window, UIManager.getColor("Panel.background")));
            g.fillRect(x, h - evalHeight, w, evalHeight);
            if (marginLeft > 0) {
                g.fillRect(x - marginLeft, y, marginLeft, h);
            }
            g.setColor(evalCopy ? new Color(0xCC0000) : SyntheticaLookAndFeel.getColor("Synthetica.rootPane.borderText.foreground", window, UIManager.getColor("Label.foreground")));
            g.setFont(g.getFont().deriveFont(SyntheticaLookAndFeel.getInstance().scaleFontSize(10.0f)));
            String text = evalCopy ? "Synthetica - Unregistered Evaluation Copy!" : rootPaneText;
            g.drawString(text, (int)SyntheticaLookAndFeel.getInstance().scaleInteger(4), h - evalHeight + g.getFontMetrics().getAscent());
        }
    }

    private void paintBorder(JRootPane root, Graphics g, int x, int y, int w, int h, String imagePath, Insets sInsets, Insets dInsets, int xPolicy, int yPolicy, Window window, boolean maximized, boolean respectBorderFill) {
        if (maximized && respectBorderFill) {
            Insets sInsets2 = this.getImageInsets("Synthetica.rootPane.border.insets", window);
            sInsets2 = new Insets(sInsets2.top - sInsets.top, sInsets2.left - sInsets.left, sInsets2.bottom - sInsets.bottom, sInsets2.right - sInsets.right);
            ImagePainter iPainter = new ImagePainter(root, g, x, y, w, h, imagePath, sInsets, dInsets, sInsets2, sInsets2, xPolicy, yPolicy);
            iPainter.draw();
        } else {
            SyntheticaState state = new SyntheticaState(window.isActive() ? SyntheticaState.State.ACTIVE.toInt() : 0);
            UIKey key = new UIKey("rootPane.border", state);
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)root, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)root, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)root, window.isActive() ? 0 : 6);
            ImagePainter iPainter = new ImagePainter((JComponent)root, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
            if (maximized) {
                iPainter.drawCenter();
            } else if (respectBorderFill) {
                iPainter.draw();
            } else {
                iPainter.drawBorder();
            }
        }
    }

    public void paintRootPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        if (c instanceof JRootPane) {
            this.paintRootPaneBorder((JRootPane)c, new SyntheticaState(sc.getComponentState()), g, x, y, w, h);
        }
    }

    public void paintContentBackground(JRootPane root, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Window window = SwingUtilities.getWindowAncestor(root);
        String imagePath = "Synthetica.rootPane.border";
        if (window.isActive()) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = this.resolveImagePath(imagePath, window);
        Insets sInsets = (Insets)this.getImageInsets("Synthetica.rootPane.border.size", window, new Insets(4, 4, 4, 4)).clone();
        sInsets.top += ((SyntheticaRootPaneUI)root.getUI()).getTitlePane().getHeight();
        Insets dInsets = new Insets(0, 0, 0, 0);
        int xPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.background.horizontalTiled", window)) {
            xPolicy = 1;
        }
        int yPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.background.verticalTiled", window)) {
            yPolicy = 1;
        }
        ImagePainter iPainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
        iPainter.drawCenter();
        imagePath = "Synthetica.rootPane.border.light";
        if (window.isActive()) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        if ((imagePath = this.resolveImagePath(imagePath, window)) != null) {
            iPainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 1);
            iPainter.drawCenter();
        }
        MenuPainter.getInstance().paintMenuBarBackground(root, new SyntheticaState(), g, x, y, w, h);
    }

    protected void renderLogo(JRootPane root, boolean windowIsActive, boolean windowIsMaximized, boolean respectBorderSize, Graphics g, int w, int h) {
        boolean respectButtons;
        boolean titlePaneOnly;
        SyntheticaLogoRenderer r = (SyntheticaLogoRenderer)root.getClientProperty("Synthetica.logoRenderer");
        JComponent rc = r.getRendererComponent(root, windowIsActive);
        Window window = this.getWindow(root);
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.border.size", (Component)window, true, true);
        if (insets == null) {
            insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.border.insets", (Component)window, false, true);
        }
        int maxHeight = insets.top;
        maxHeight = windowIsMaximized || !respectBorderSize ? 0 : maxHeight;
        maxHeight += ((SyntheticaRootPaneUI)root.getUI()).getTitlePane().getHeight();
        JMenuBar mb = SyntheticaLookAndFeel.findComponent(JMenuBar.class, (Container)root);
        boolean bl = titlePaneOnly = root.getClientProperty("Synthetica.logoRenderer.titlePaneOnly") == null ? false : (Boolean)root.getClientProperty("Synthetica.logoRenderer.titlePaneOnly");
        if (mb != null && !mb.isOpaque() && SyntheticaLookAndFeel.get("Synthetica.menuBar.background.active", mb) == null && !titlePaneOnly) {
            maxHeight += mb.getHeight();
        }
        boolean bl2 = respectButtons = root.getClientProperty("Synthetica.logoRenderer.respectButtons") == null ? false : (Boolean)root.getClientProperty("Synthetica.logoRenderer.respectButtons");
        if (respectButtons) {
            Rectangle mRect = ((SyntheticaTitlePane)((SyntheticaRootPaneUI)root.getUI()).getTitlePane()).getMenuButtonBounds();
            Rectangle cRect = ((SyntheticaTitlePane)((SyntheticaRootPaneUI)root.getUI()).getTitlePane()).getControlButtonsBounds();
            int x = Math.min(mRect.x + mRect.width, cRect.x + cRect.width);
            int maxWidth = Math.max(mRect.x, cRect.x) - x;
            int n = windowIsMaximized || !respectBorderSize ? 0 : insets.left;
            rc.setSize(new Dimension(maxWidth, maxHeight));
            g.translate(x += n, 0);
            rc.paint(g);
            g.translate(-x, 0);
        } else {
            rc.setSize(new Dimension(w, maxHeight));
            rc.paint(g);
        }
    }

    public void paintTitlePaneBackground(JRootPane root, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        boolean render;
        Window window = this.getWindow(root);
        boolean opaque = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.opaque", window, true);
        String imagePath = "Synthetica.rootPane.titlePane.background";
        if (state.isSet(SyntheticaState.State.SELECTED)) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = this.resolveImagePath(imagePath, window);
        Insets insets = this.getImageInsets("Synthetica.rootPane.titlePane.background.insets", window);
        int xPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.background.horizontalTiled", window)) {
            xPolicy = 1;
        }
        int yPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.background.verticalTiled", window)) {
            yPolicy = 1;
        }
        ImagePainter iPainter = null;
        boolean bl = render = imagePath != null && opaque;
        if (render) {
            iPainter = new ImagePainter(g, x, y, w, h, imagePath, insets, insets, xPolicy, yPolicy);
            iPainter.draw();
        }
        imagePath = "Synthetica.rootPane.titlePane.background.light";
        if (state.isSet(SyntheticaState.State.SELECTED)) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        if ((imagePath = this.resolveImagePath(imagePath, window)) != null && opaque) {
            iPainter = new ImagePainter(g, x, y, w, h, imagePath, insets, insets, 0, yPolicy);
            iPainter.draw();
        }
        if (render && root.getClientProperty("Synthetica.logoRenderer") != null) {
            this.renderLogo(root, window.isActive(), this.isMaximized(window), false, g, w, h);
        }
    }

    public void paintTitlePaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JRootPane root = (JRootPane)sc.getComponent();
        this.paintTitlePaneBackground(root, new SyntheticaState(sc.getComponentState()), g, x, y, w, h);
    }

    protected boolean isMaximized(Window window) {
        return window instanceof Frame && (((Frame)window).getExtendedState() & 6) == 6;
    }

    public void paintButtonAreaBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JRootPane root = (JRootPane)sc.getComponent();
        Window window = this.getWindow(root);
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        Insets areaInsets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.buttonArea.insets", (Component)window, true, true);
        if (areaInsets != null) {
            x -= areaInsets.left;
            y -= areaInsets.top;
            w += areaInsets.left + areaInsets.right;
            h += areaInsets.top + areaInsets.bottom;
            String imagePath = "Synthetica.rootPane.titlePane.buttonArea.background";
            if (selected && this.resolveImagePath("Synthetica.rootPane.titlePane.buttonArea.background.selected", window) != null) {
                imagePath = String.valueOf(imagePath) + ".selected";
            }
            imagePath = this.resolveImagePath(imagePath, window);
            Insets insets = this.getImageInsets("Synthetica.rootPane.titlePane.buttonArea.background.insets", window);
            ImagePainter painter = new ImagePainter(g, x, y, w, h, imagePath, insets, insets, 0, 0);
            painter.draw();
        }
    }

    public void paintResizeBackground(JRootPane rootPane, SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Window win = this.getWindow(rootPane);
        g.setColor(SyntheticaLookAndFeel.getColor("Synthetica.rootPane.resizeFillColor", win, new Color(0x40000000, true)));
        g.fillRect(x, y, w, h);
        g.setColor(SyntheticaLookAndFeel.getColor("Synthetica.rootPane.resizeBorderColor", win, new Color(-2139062144, true)));
        g.drawRect(x, y, w - 1, h - 1);
    }

    public void paintSnapBackground(JRootPane rootPane, SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Window win = this.getWindow(rootPane);
        String imagePath = "Synthetica.rootPane.snap.background.image";
        if ((imagePath = this.resolveImagePath(imagePath, win)) != null) {
            Insets insets = this.getImageInsets("Synthetica.rootPane.snap.background.image.insets", win);
            ImagePainter iPainter = new ImagePainter(g, x, y, w, h, imagePath, insets, insets, 0, 0);
            iPainter.draw();
        } else {
            g.setColor(SyntheticaLookAndFeel.getColor("Synthetica.rootPane.snap.background", win, new Color(0x60000000, true)));
            int rectSize = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.snap.rectSize", win, 16, true);
            if (rectSize > 0) {
                int i = 0;
                while (i < rectSize) {
                    g.drawRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1);
                    ++i;
                }
            } else if (rectSize < 0) {
                g.fillRect(x, y, w, h);
            }
            g.setColor(SyntheticaLookAndFeel.getColor("Synthetica.rootPane.snap.borderColor", win, new Color(-2139062144, true)));
            g.drawRect(x, y, w - 1, h - 1);
        }
    }

    public void paintHeaderShadowBackground(JRootPane rootPane, SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Window win = this.getWindow(rootPane);
        String imagePath = "Synthetica.rootPane.headerShadow.background.image";
        if ((imagePath = this.resolveImagePath(imagePath, win)) != null) {
            Insets insets = this.getImageInsets("Synthetica.rootPane.headerShadow.background.image.insets", win);
            ImagePainter iPainter = new ImagePainter(g, x, y, w, h, imagePath, insets, insets, 0, 0);
            iPainter.draw();
        } else {
            g.setColor(new Color(0x60000000, true));
            g.drawLine(x, y, x + w - 1, y);
            g.setColor(new Color(0x26000000, true));
            g.drawLine(x, y + 1, x + w - 1, y + 1);
            g.setColor(new Color(0x12000000, true));
            g.drawLine(x, y + 2, x + w - 1, y + 2);
        }
    }

    protected Window getWindow(JRootPane root) {
        Container parent = root.getParent();
        return parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        if (id.equals("paintRootPaneBorder") || id.equals("paintRootPaneBackground")) {
            return Cacheable.ScaleType.NINE_SQUARE;
        }
        return super.getCacheScaleType(id);
    }
}

