/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.syntheticaaddons.table.MultiLineTableCellRenderer;
import de.javasoft.syntheticaaddons.ui.AboutDialogUI;
import de.javasoft.syntheticaaddons.ui.addons.AboutDialogAddon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class AboutDialog
extends JComponent {
    private static final long serialVersionUID = 3944221583946202891L;
    public static final String uiClassID = "AboutDialogUI";
    private JTextPane descriptionPane = null;
    private JScrollPane aboutScrollPane = null;
    private JTabbedPane tabbedPane = null;
    private JDialog dialog = null;
    private Dimension dialogSize = null;
    private boolean sortable;
    private String bgImage = null;
    private Insets bgInsets = null;
    protected static AbstractComponentAddon addon = new AboutDialogAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public AboutDialog(Window owner, boolean modal) {
        this(owner, modal, null);
    }

    public AboutDialog(Window owner, boolean modal, Locale locale) {
        this(owner, modal, null, true);
    }

    public AboutDialog(Window owner, boolean modal, Locale locale, boolean sortable) {
        this.dialog = owner instanceof Frame ? new JDialog((Frame)owner, modal) : new JDialog((Dialog)owner, modal);
        if (locale != null) {
            this.setLocale(locale);
        }
        this.sortable = sortable;
        this.setUI(UIManager.getUI(this));
        this.init();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, AboutDialogUI.class));
    }

    private void init() {
        this.descriptionPane = new JTextPane();
        this.descriptionPane.setText(UIManager.getString("AboutDialog.description"));
        this.aboutScrollPane = new JScrollPane(new JEditorPane());
        this.tabbedPane = this.createTabbedPane();
        this.tabbedPane.addTab(UIManager.getString("AboutDialog.aboutTab"), this.aboutScrollPane);
        JTable table = this.createSystemTable();
        JScrollPane tableScrollPane = new JScrollPane(table);
        JComponent cc = this.createSystemTableCorner(table);
        if (this.sortable && table != null) {
            ((JXTable)table).setColumnControl(cc);
        } else if (!this.sortable) {
            tableScrollPane.setCorner("UPPER_TRAILING_CORNER", cc);
        }
        if (table != null) {
            this.tabbedPane.addTab(UIManager.getString("AboutDialog.systemTab"), tableScrollPane);
        }
    }

    protected JTabbedPane createTabbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(10, 10, 10, 10, true));
        tabbedPane.setPreferredSize(SyntheticaLookAndFeel.getInstance().scaleDimension(580, 360));
        return tabbedPane;
    }

    protected JComponent createSystemTableCorner(JTable table) {
        JTableHeader th = new JTableHeader();
        th.setTable(table);
        return th;
    }

    protected JTable createSystemTable() {
        JTable table = null;
        if (this.sortable) {
            try {
                table = (JTable)Class.forName("org.jdesktop.swingx.JXTable").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            table = new JTable();
        }
        table.setModel(new DefaultTableModel(){
            private Map.Entry<?, ?>[] props = System.getProperties().entrySet().toArray(new Map.Entry[0]);

            @Override
            public int getRowCount() {
                if (this.props == null) {
                    return 0;
                }
                return this.props.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    return this.props[row].getKey();
                }
                return this.props[row].getValue();
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return UIManager.getString("AboutDialog.systemName");
                }
                return UIManager.getString("AboutDialog.systemValue");
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        table.getColumnModel().getColumn(1).setCellRenderer(new MultiLineTableCellRenderer(table.getDefaultRenderer(Object.class)));
        if (this.sortable) {
            JXTable t = (JXTable)table;
            t.packColumn(1, 100);
            t.setColumnControlVisible(true);
        }
        return table;
    }

    private void addComponents() {
        this.dialog.getContentPane().removeAll();
        this.dialog.setLayout(new BorderLayout());
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setCaretPosition(0);
        this.descriptionPane.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(10, 10, 10, 10, true));
        JPanel topPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (AboutDialog.this.bgImage != null) {
                    new ImagePainter(g, 0, 0, this.getSize().width, this.getSize().height, AboutDialog.this.bgImage, AboutDialog.this.bgInsets, AboutDialog.this.bgInsets, 0, 0).draw();
                }
            }
        };
        topPanel.add(this.descriptionPane);
        JSeparator separator = new JSeparator(0);
        separator.setName("AboutDialog.separator");
        topPanel.add((Component)separator, "South");
        topPanel.setBackground(new Color(UIManager.getColor("TextField.background").getRGB()));
        topPanel.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"AboutDialog.topPanel.opaque", (Component)this.dialog, (boolean)true));
        this.dialog.add((Component)topPanel, "North");
        JEditorPane aboutPane = (JEditorPane)this.aboutScrollPane.getViewport().getView();
        aboutPane.setBackground(new Color(UIManager.getColor("TextField.background").getRGB()));
        aboutPane.setEditable(false);
        aboutPane.setCaretPosition(0);
        aboutPane.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(10, 10, 10, 10, true));
        this.dialog.add(this.tabbedPane);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        bottomPanel.add(Box.createHorizontalGlue());
        JButton button = new JButton(UIManager.getString("AboutDialog.okButton")){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(80));
                return dim;
            }
        };
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dialog.dispose();
            }
        });
        bottomPanel.add(button);
        bottomPanel.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(10, 10, 10, 10, true));
        this.dialog.add((Component)bottomPanel, "South");
    }

    public static void showDialog(Window owner, String title, String description, String aboutText, URL base, Locale locale, boolean sortable) throws IOException {
        AboutDialog ad = new AboutDialog(owner, true, locale, sortable);
        ad.setTitle(title);
        ad.setDescription(description);
        ad.setAboutText(aboutText, base);
        ad.showDialog();
    }

    public static void showDialog(Window owner, String title, String description, String aboutText, Locale locale, boolean sortable) throws IOException {
        AboutDialog.showDialog(owner, title, description, aboutText, null, locale, true);
    }

    public static void showDialog(Window owner, String title, String description, String aboutText, Locale locale) throws IOException {
        AboutDialog.showDialog(owner, title, description, aboutText, null, null, true);
    }

    public static void showDialog(Window owner, String title, String description, String aboutText) throws IOException {
        AboutDialog.showDialog(owner, title, description, aboutText, null);
    }

    public void showDialog() {
        this.addComponents();
        if (this.dialog.getTitle() == null) {
            this.dialog.setTitle(UIManager.getString("AboutDialog.title"));
        }
        if (this.dialogSize == null) {
            this.dialog.pack();
        } else {
            this.dialog.setSize(this.dialogSize);
        }
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public String getTitle() {
        return this.dialog.getTitle();
    }

    public void setAboutText(String aboutText) throws IOException {
        this.setAboutText(aboutText, null);
    }

    public void setAboutText(String aboutText, URL base) throws IOException {
        if (aboutText.toUpperCase().trim().startsWith("<HTML>")) {
            JEditorPane aboutPane = new JEditorPane("text/html", aboutText);
            if (base != null) {
                ((HTMLDocument)aboutPane.getDocument()).setBase(base);
            }
            aboutPane.addHyperlinkListener(this.createHyperlinkListener());
            this.aboutScrollPane.getViewport().setView(aboutPane);
        } else {
            JEditorPane aboutPane = (JEditorPane)this.aboutScrollPane.getViewport().getView();
            aboutPane.setText(aboutText);
        }
    }

    protected HyperlinkListener createHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SyntheticaAddonsUtilities.openInBrowser(evt.getURL().toExternalForm());
                }
            }
        };
    }

    public void setAboutText(URL document) throws IOException {
        this.setAboutText(document.toString());
        JEditorPane aboutPane = new JEditorPane(document.toString());
        aboutPane.addHyperlinkListener(this.createHyperlinkListener());
        this.aboutScrollPane.getViewport().setView(aboutPane);
    }

    public String getAboutText() {
        JEditorPane aboutPane = (JEditorPane)this.aboutScrollPane.getViewport().getView();
        return aboutPane.getText();
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        if (description.toUpperCase().trim().startsWith("<HTML>")) {
            this.descriptionPane.setEditorKit(new HTMLEditorKit());
            this.descriptionPane.setContentType("text/html");
            this.descriptionPane.addHyperlinkListener(this.createHyperlinkListener());
        }
        this.descriptionPane.setText(description);
    }

    public String getDetails() {
        return this.descriptionPane.getText();
    }

    public void setBackgroundImage(String imagePath, Insets insets) {
        this.bgImage = imagePath;
        this.bgInsets = insets;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setDialogSize(Dimension dim) {
        this.dialogSize = dim;
    }

    public Dimension setDialogSize() {
        return this.dialogSize;
    }
}

