/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.syntheticaaddons.ui.DetailsDialogUI;
import de.javasoft.syntheticaaddons.ui.addons.DetailsDialogAddon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DetailsDialog
extends JComponent {
    private static final long serialVersionUID = 5226616259351485637L;
    public static final String uiClassID = "DetailsDialogUI";
    public static final int UNKNOWN_TYPE = -1;
    public static final int INFO_TYPE = 0;
    public static final int WARNING_TYPE = 1;
    public static final int ERROR_TYPE = 2;
    private final Icon INFO_ICON = UIManager.getIcon("OptionPane.informationIcon");
    private final Icon WARNING_ICON = UIManager.getIcon("OptionPane.warningIcon");
    private final Icon ERROR_ICON = UIManager.getIcon("OptionPane.errorIcon");
    private int type = -1;
    private JLabel icon = new JLabel();
    private JScrollPane messagePane;
    private JScrollPane detailsPane;
    private JButton detailsButton;
    private JButton okButton;
    private int messageWidth = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(400));
    private int messageHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(55));
    private int detailsHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(250));
    private boolean details = false;
    private boolean lineWrap = false;
    private int xGap = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(5));
    private int yGap = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(8));
    private JDialog dialog = null;
    protected static AbstractComponentAddon addon = new DetailsDialogAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public DetailsDialog(Window owner, boolean modal) {
        this(owner, modal, null);
    }

    public DetailsDialog(Window owner, boolean modal, Locale locale) {
        this.dialog = owner instanceof Frame ? new JDialog((Frame)owner, modal) : new JDialog((Dialog)owner, modal);
        if (locale != null) {
            this.setLocale(locale);
        }
        this.setUI(UIManager.getUI(this));
        this.init();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DetailsDialogUI.class));
    }

    public static void showDialog(Window owner, String title, String message, Throwable e, Locale locale) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.getBuffer().toString();
        if (message == null) {
            message = e.getMessage();
        }
        DetailsDialog.showDialog(owner, title, message, stackTrace, 2, locale);
    }

    public static void showDialog(Window owner, String title, String message, Throwable e) {
        DetailsDialog.showDialog(owner, title, message, e, null);
    }

    public static void showDialog(Window owner, String title, String message, String details, int type, Locale locale) {
        DetailsDialog dd = new DetailsDialog(owner, true, locale);
        dd.init();
        dd.setTitle(title);
        dd.setMessage(message);
        dd.setDetails(details);
        dd.setType(type);
        dd.showDialog();
    }

    public static void showDialog(Window owner, String title, String message, String details, int type) {
        DetailsDialog.showDialog(owner, title, message, details, type, null);
    }

    public void showDialog() {
        this.addComponents();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    private void init() {
        this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "closeDialog");
        this.dialog.getRootPane().getActionMap().put("closeDialog", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.getWindowAncestor((Component)evt.getSource()).dispose();
            }
        });
        this.messagePane = new JScrollPane(new JTextPane());
        this.messagePane.setOpaque(false);
        if (this.lineWrap) {
            this.detailsPane = new JScrollPane(new JTextPane());
        } else {
            JPanel p = new JPanel(new BorderLayout());
            p.add(new JTextPane());
            this.detailsPane = new JScrollPane(p);
        }
        this.detailsPane.setOpaque(false);
        this.addComponents();
        this.dialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DetailsDialog.this.addComponents();
                JDialog d = (JDialog)evt.getComponent();
                d.getRootPane().revalidate();
                d.getRootPane().repaint();
            }

            @Override
            public void componentMoved(ComponentEvent evt) {
            }

            @Override
            public void componentShown(ComponentEvent evt) {
            }

            @Override
            public void componentHidden(ComponentEvent evt) {
            }
        });
    }

    private void addComponents() {
        this.dialog.getContentPane().removeAll();
        this.dialog.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = this.details ? 0.0 : 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = this.details ? 2 : 1;
        gbc.insets = new Insets(0, 0, this.yGap, 0);
        this.dialog.add((Component)this.createMessagePanel(), gbc);
        if (this.details) {
            ++gbc.gridy;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.dialog.add((Component)this.createDetailsPanel(), gbc);
        }
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.dialog.add((Component)this.createButtonsPanel(), gbc);
        ((JPanel)this.dialog.getContentPane()).setBorder(new EmptyBorder(this.yGap, this.xGap, this.yGap, this.xGap));
    }

    private JPanel createMessagePanel() {
        this.messagePane.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        JTextPane tp = (JTextPane)this.messagePane.getViewport().getView();
        tp.setEditable(false);
        tp.setOpaque(false);
        tp.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        tp.setCaretPosition(0);
        JPanel panel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 8449172557508808235L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(DetailsDialog.this.messageWidth + ((DetailsDialog)DetailsDialog.this).icon.getSize().width + DetailsDialog.this.xGap, Math.max(((DetailsDialog)DetailsDialog.this).icon.getPreferredSize().height, Math.max(DetailsDialog.this.messageHeight, ((DetailsDialog)DetailsDialog.this).messagePane.getPreferredSize().height)));
            }
        };
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        panel.add((Component)this.icon, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        int yMessage = Math.max(0, (this.icon.getPreferredSize().height - tp.getPreferredSize().height) / 2);
        gbc.insets = new Insets(yMessage, this.xGap, 0, 0);
        panel.add((Component)this.messagePane, gbc);
        return panel;
    }

    private JPanel createDetailsPanel() {
        this.detailsPane.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        JTextPane tp = null;
        tp = this.lineWrap ? (JTextPane)this.detailsPane.getViewport().getView() : (JTextPane)((JPanel)this.detailsPane.getViewport().getView()).getComponent(0);
        tp.setEditable(false);
        tp.setOpaque(false);
        tp.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        tp.setCaretPosition(0);
        this.detailsPane.setPreferredSize(new Dimension(this.messageWidth, this.detailsHeight));
        JPanel panel = new JPanel(new BorderLayout());
        JXTitledSeparator separator = new JXTitledSeparator();
        separator.setHorizontalAlignment(0);
        separator.setTitle(UIManager.getString("DetailsDialog.details"));
        panel.add((Component)separator, "North");
        panel.add(this.detailsPane);
        if (this.lineWrap || this.detailsPane.getViewport().getSize().width >= this.detailsPane.getViewport().getPreferredSize().width) {
            panel.add((Component)new JSeparator(0), "South");
        }
        return panel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(UIManager.getString("DetailsDialog.okButton"));
            this.okButton.setName("DetailsDialog.OkButton");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DetailsDialog.this.dialog.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getDetailsButton() {
        if (this.detailsButton == null) {
            this.detailsButton = new JButton();
            this.detailsButton.setName("DetailsDialog.DetailsButton");
            this.detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DetailsDialog.this.details = !DetailsDialog.this.details;
                    DetailsDialog.this.addComponents();
                    DetailsDialog.this.dialog.pack();
                }
            });
        }
        if (this.details) {
            this.detailsButton.setText(UIManager.getString("DetailsDialog.detailsButtonClose"));
        } else {
            this.detailsButton.setText(UIManager.getString("DetailsDialog.detailsButtonOpen"));
        }
        return this.detailsButton;
    }

    private JPanel createButtonsPanel() {
        Component c;
        SpringLayout layout = new SpringLayout();
        JPanel panel = new JPanel(layout);
        panel.setName("DetailsDialog.ButtonPanel");
        JButton okButton = this.getOkButton();
        panel.add(okButton);
        JButton detailsButton = this.getDetailsButton();
        panel.add(detailsButton);
        layout.putConstraint("East", (Component)detailsButton, 0, "East", (Component)panel);
        layout.putConstraint("East", (Component)okButton, -this.xGap, "West", (Component)detailsButton);
        int totalWidth = 0;
        Spring maxWidth = Spring.constant(0);
        Component[] componentArray = panel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            maxWidth = Spring.max(maxWidth, layout.getConstraints(c).getWidth());
            ++n2;
        }
        componentArray = panel.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            SpringLayout.Constraints constraints = layout.getConstraints(c);
            constraints.setWidth(maxWidth);
            totalWidth += maxWidth.getMinimumValue() + this.xGap;
            ++n2;
        }
        Border panelBorder = panel.getBorder();
        Dimension dim = null;
        dim = panelBorder != null ? new Dimension(totalWidth += panelBorder.getBorderInsets((Component)panel).left + panelBorder.getBorderInsets((Component)panel).right - this.xGap, okButton.getPreferredSize().height + panelBorder.getBorderInsets((Component)panel).top + panelBorder.getBorderInsets((Component)panel).bottom) : new Dimension(totalWidth, okButton.getPreferredSize().height);
        panel.setPreferredSize(dim);
        panel.setMinimumSize(dim);
        return panel;
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public String getTitle() {
        return this.dialog.getTitle();
    }

    public void setMessage(String message) {
        JTextPane tp = (JTextPane)this.messagePane.getViewport().getView();
        if (message.toUpperCase().trim().startsWith("<HTML>")) {
            tp.setEditorKit(new HTMLEditorKit());
            tp.setContentType("text/html");
            tp.addHyperlinkListener(this.createHyperlinkListener(false));
        }
        tp.setText(message);
    }

    protected HyperlinkListener createHyperlinkListener(boolean detailsPane) {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SyntheticaAddonsUtilities.openInBrowser(evt.getURL().toExternalForm());
                }
            }
        };
    }

    public String getMessage() {
        return ((JTextPane)this.messagePane.getViewport().getView()).getText();
    }

    public void setDetails(String details) {
        JTextPane tp = null;
        tp = this.lineWrap ? (JTextPane)this.detailsPane.getViewport().getView() : (JTextPane)((JPanel)this.detailsPane.getViewport().getView()).getComponent(0);
        if (details.toUpperCase().trim().startsWith("<HTML>")) {
            tp.setEditorKit(new HTMLEditorKit());
            tp.setContentType("text/html");
            tp.addHyperlinkListener(this.createHyperlinkListener(true));
        }
        tp.setText(details);
    }

    public String getDetails() {
        if (this.lineWrap) {
            return ((JTextPane)this.detailsPane.getViewport().getView()).getText();
        }
        return ((JTextPane)((JPanel)this.detailsPane.getViewport().getView()).getComponent(0)).getText();
    }

    public void setIcon(Icon icon) {
        this.icon.setIcon(icon);
    }

    public Icon getIcon() {
        return this.icon.getIcon();
    }

    public void setType(int type) {
        this.type = type;
        if (type == 0) {
            if (this.icon.getIcon() == null) {
                this.setIcon(this.INFO_ICON);
            }
            if (this.getTitle() == null) {
                this.setTitle(UIManager.getString("DetailsDialog.infoTitle"));
            }
        } else if (type == 1) {
            if (this.icon.getIcon() == null) {
                this.setIcon(this.WARNING_ICON);
            }
            if (this.getTitle() == null) {
                this.setTitle(UIManager.getString("DetailsDialog.warningTitle"));
            }
        } else if (type == 2) {
            if (this.icon.getIcon() == null) {
                this.setIcon(this.ERROR_ICON);
            }
            if (this.getTitle() == null) {
                this.setTitle(UIManager.getString("DetailsDialog.errorTitle"));
            }
        } else if (this.icon.getIcon() == null) {
            this.setIcon(null);
        }
    }

    public int getType() {
        return this.type;
    }
}

