/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractTableCellRenderer<T extends JComponent>
extends JLabel
implements TableCellRenderer {
    protected TableCellRenderer delegate;
    protected T rendererComponent;
    private Color arrowForegroundSelected;
    private Color arrowForeground;

    public AbstractTableCellRenderer(TableCellRenderer defaultRenderer) {
        this.delegate = defaultRenderer;
        this.arrowForegroundSelected = UIManager.getColor("Synthetica.table.cellRenderer.selected.arrowButton.foreground");
        this.arrowForeground = UIManager.getColor("Synthetica.table.cellRenderer.arrowButton.foreground");
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        this.rendererComponent = this.createRendererComponent();
        this.add((Component)this.rendererComponent);
    }

    protected abstract T createRendererComponent();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        this.setValue(this.rendererComponent, value);
        this.configureRendererComponent(this.rendererComponent, c, table, value, isSelected, hasFocus, row, column);
        return this;
    }

    protected abstract void setValue(T var1, Object var2);

    protected void configureRendererComponent(T rendererComponent, JComponent defaultRendererComponent, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color foreground = new Color(defaultRendererComponent.getForeground().getRGB());
        if (isSelected && !table.hasFocus()) {
            foreground = SyntheticaLookAndFeel.getColor((String)"Synthetica.table.selectionForeground.inactive", rendererComponent, (Color)foreground);
        }
        ((JComponent)rendererComponent).setForeground(foreground);
        ((JComponent)rendererComponent).putClientProperty("Synthetica.table.cellRenderer.arrowButton.foreground", isSelected ? this.arrowForegroundSelected : this.arrowForeground);
    }
}

