/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.FormattedTextFieldTableCellEditor;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultFormatterFactory;

public class NumberTableCellEditor
extends FormattedTextFieldTableCellEditor {
    private Class<?> dataClass;
    private int minDigits;
    private int maxDigits;

    public NumberTableCellEditor(TableCellEditor defaultEditor, Class<?> dataClass, int minDigits, int maxDigits) {
        super(defaultEditor);
        this.dataClass = dataClass;
        this.minDigits = minDigits;
        this.maxDigits = maxDigits;
        ((JFormattedTextField)this.editorComponent).setFormatterFactory(new DefaultFormatterFactory(new Formatter()));
        ((JFormattedTextField)this.editorComponent).setHorizontalAlignment(4);
    }

    private class Formatter
    extends JFormattedTextField.AbstractFormatter {
        private Formatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            Number o = null;
            try {
                NumberFormat nf = NumberFormat.getNumberInstance();
                o = nf.parse(text);
                if (NumberTableCellEditor.this.dataClass == Float.class) {
                    o = Float.valueOf("" + o);
                } else if (NumberTableCellEditor.this.dataClass == Double.class) {
                    o = Double.valueOf("" + o);
                } else if (NumberTableCellEditor.this.dataClass == Integer.class) {
                    o = Integer.valueOf("" + o);
                } else if (NumberTableCellEditor.this.dataClass == Long.class) {
                    o = Long.valueOf("" + o);
                }
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), -1);
            }
            return o;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return null;
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            if (NumberTableCellEditor.this.dataClass == Float.class || NumberTableCellEditor.this.dataClass == Double.class) {
                nf.setMinimumFractionDigits(NumberTableCellEditor.this.minDigits);
                nf.setMaximumFractionDigits(NumberTableCellEditor.this.maxDigits);
            }
            return nf.format(value);
        }
    }
}

