/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.table.AbstractTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.table.TableCellRenderer;

public class SpinnerTableCellRenderer
extends AbstractTableCellRenderer<JSpinner> {
    public SpinnerTableCellRenderer(TableCellRenderer defaultRenderer) {
        super(defaultRenderer);
    }

    @Override
    protected JSpinner createRendererComponent() {
        JSpinner c = new JSpinner();
        c.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        c.putClientProperty("Synthetica.opaque", false);
        return c;
    }

    @Override
    protected void setValue(JSpinner rendererComponent, Object value) {
        if (value instanceof SpinnerModel) {
            rendererComponent.setModel((SpinnerModel)value);
        } else {
            rendererComponent.setValue(value);
        }
    }

    @Override
    protected void configureRendererComponent(JSpinner rendererComponent, JComponent defaultRendererComponent, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.configureRendererComponent(rendererComponent, defaultRendererComponent, table, value, isSelected, hasFocus, row, column);
        Color foreground = defaultRendererComponent.getForeground();
        if (isSelected && !table.hasFocus()) {
            foreground = SyntheticaLookAndFeel.getColor((String)"Synthetica.table.selectionForeground.inactive", (Component)rendererComponent, (Color)foreground);
        }
        ((JTextField)SyntheticaLookAndFeel.findComponent(JTextField.class, (Container)rendererComponent)).setForeground(foreground);
    }
}

