/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.AbstractTableCellEditor;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class TextFieldTableCellEditor
extends AbstractTableCellEditor<JTextField> {
    private Constructor<?> constructor;
    private Object value;

    public TextFieldTableCellEditor(TableCellEditor defaultEditor) {
        super(defaultEditor);
    }

    @Override
    public JTextField createEditorComponent() {
        JTextField c = new JTextField();
        c.putClientProperty("Synthetica.opaque", false);
        return c;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        try {
            Class<Object> type = value.getClass();
            if (type == Object.class) {
                type = String.class;
            }
            this.constructor = type.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JTextField)TextFieldTableCellEditor.this.editorComponent).requestFocusInWindow();
            }
        });
        return c;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public void setCellEditorValue(Object value) {
        if (value instanceof Number) {
            value = NumberFormat.getInstance().format(value);
        }
        ((JTextField)this.editorComponent).setText(value == null ? "" : value.toString());
    }

    @Override
    public boolean stopCellEditing() {
        String s = ((JTextField)this.editorComponent).getText();
        try {
            if (Number.class.isAssignableFrom(this.constructor.getDeclaringClass())) {
                s = "" + NumberFormat.getNumberInstance().parse(s);
            }
            this.value = this.constructor.newInstance(s);
        }
        catch (Exception e) {
            this.applyErrorBorder();
            return false;
        }
        return super.stopCellEditing();
    }

    public static class NumberEditor
    extends TextFieldTableCellEditor {
        public NumberEditor(TableCellEditor defaultEditor) {
            super(defaultEditor);
        }

        @Override
        public JTextField createEditorComponent() {
            JTextField tf = super.createEditorComponent();
            tf.setHorizontalAlignment(4);
            return tf;
        }
    }
}

