/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.syntheticaaddons.SystemMonitor;
import de.javasoft.syntheticaaddons.systemmonitor.CollectorFactory;
import de.javasoft.syntheticaaddons.systemmonitor.SystemMonitorModel;
import de.javasoft.syntheticaaddons.ui.painter.SystemMonitorPainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.UIResource;

public class SystemMonitorUI
extends PanelUI {
    @Override
    public void paint(Graphics g, JComponent c) {
        int x = 0;
        int y = 0;
        int w = c.getWidth();
        int height = ((SystemMonitor)c).getCaptionPanel() == null ? 0 : ((SystemMonitor)c).getCaptionPanel().getHeight();
        int h = c.getHeight() - height;
        if (c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            x = insets.left;
            y = insets.top;
            w -= insets.left + insets.right;
            h -= insets.top + insets.bottom;
        }
        SyntheticaState state = new SyntheticaState();
        SystemMonitorPainter.getInstance().paintSystemMonitorBackground(c, state, g, x, y, w, h);
        SystemMonitorPainter.getInstance().paintSystemMonitorForeground(c, state, g, x, y, w, h);
        SystemMonitorPainter.getInstance().paintSystemMonitorSpotlight(c, state, g, x, y, w, h);
    }

    public static PanelUI createUI(JComponent c) {
        return new SystemMonitorUI();
    }

    @Override
    public void installUI(final JComponent c) {
        super.installUI(c);
        this.installDefaults(c);
        JPanel southPanel = ((SystemMonitor)c).getCaptionPanel();
        if (southPanel == null) {
            southPanel = new JPanel(new GridBagLayout()){
                private static final long serialVersionUID = -4306816688362297522L;

                @Override
                public void updateUI() {
                    super.updateUI();
                    this.setBackground(c.getBackground());
                    super.setOpaque(true);
                }

                @Override
                public void setOpaque(boolean opaque) {
                }
            };
            southPanel.setName("SystemMonitor.CaptionPanel");
        }
        c.setLayout(new BorderLayout());
        c.add((Component)southPanel, "South");
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults(c);
    }

    protected void installDefaults(JComponent c) {
        SystemMonitorModel model;
        SystemMonitor sm = (SystemMonitor)c;
        if (sm.getForeground() == null || sm.getForeground() instanceof UIResource) {
            sm.setForeground(SyntheticaLookAndFeel.getColor((String)"Synthetica.systemMonitor.foreground.color", (Component)sm));
        }
        if (sm.getBackground() == null || sm.getBackground() instanceof UIResource) {
            sm.setBackground(SyntheticaLookAndFeel.getColor((String)"Synthetica.systemMonitor.background.color", (Component)sm));
        }
        if (sm.getGridColor() == null || sm.getGridColor() instanceof UIResource) {
            sm.setGridColor(SyntheticaLookAndFeel.getColor((String)"Synthetica.systemMonitor.grid.color", (Component)sm));
        }
        if (sm.getBorder() == null || sm.getBorder() instanceof UIResource) {
            sm.setBorder(new BorderUIResource(new Border(){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    SystemMonitorPainter.getInstance().paintSystemMonitorBorder((JComponent)c, new SyntheticaState(), g, x, y, width, height);
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return SyntheticaLookAndFeel.getInsets((String)"Synthetica.systemMonitor.border.insets", (Component)c, (boolean)false, (boolean)true);
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }
            }));
        }
        if ((model = sm.getModel()) != null) {
            String UIManagerKey = "Synthetica.systemMonitor.{id}.color";
            CollectorFactory.CollectorID[] collectorIDArray = CollectorFactory.CollectorID.values();
            int n = collectorIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                CollectorFactory.CollectorID id = collectorIDArray[n2];
                if (model.getColor(id.id) == null || model.getColor(id.id) instanceof UIResource) {
                    model.setColor(id.id, SyntheticaLookAndFeel.getColor((String)UIManagerKey.replace("{id}", id.id), (Component)sm));
                }
                ++n2;
            }
        }
        LookAndFeel.installProperty(c, "opaque", Boolean.FALSE);
    }

    protected void uninstallDefaults(JComponent c) {
    }
}

