/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui.datecombobox;

import de.javasoft.syntheticaaddons.DateComboBox;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxMonthView;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxPopup;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DatePickerFormatter;

public class DateComboBoxEditor
extends BasicComboBoxEditor.UIResource {
    private DateComboBox dateComboBox;
    private DateComboBoxPopup popup;
    private Date lastDate;

    public DateComboBoxEditor(DateComboBox dateComboBox, DateComboBoxPopup popup) {
        this.dateComboBox = dateComboBox;
        this.popup = popup;
        this.editor = new FormattedTextField();
        this.editor.setInheritsPopupMenu(true);
        this.editor.putClientProperty("Synthetica.opaque", false);
        ((FormattedTextField)this.editor).setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)new DatePickerFormatter(dateComboBox.getDateFormats())));
        if (!popup.getMonthView().getSelection().isEmpty()) {
            dateComboBox.configureEditor(this, popup.getMonthView().getSelection().first());
        }
        this.editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            this.editor.setBorder(((JComponent)new MetalComboBoxEditor().getEditorComponent()).getBorder());
        } else if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.editor.addFocusListener(this);
        this.editor.setName("ComboBox.textField");
        dateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateComboBoxEditor.this.lastDate = DateComboBoxEditor.this.dateComboBox.getDateTime();
            }
        });
    }

    @Override
    public void setItem(Object o) {
        if (this.popup.getMonthView().isSelectionEmpty()) {
            o = null;
        }
        if (o != null) {
            o = DateComboBoxEditor.getDateTime((Date)o, (Date)this.getItem(), this.popup.getMonthView().getTimeZone());
            ((JFormattedTextField)this.editor).setValue(o);
        } else {
            this.editor.setText("");
        }
    }

    @Override
    public Object getItem() {
        return ((JFormattedTextField)this.editor).getValue();
    }

    @Override
    public void focusLost(FocusEvent evt) {
        if (this.dateComboBox.isPopupVisible()) {
            this.dateComboBox.hidePopup();
        }
        if (this.commit() && this.dateComboBox.isShowing()) {
            this.actionPerformed();
        }
    }

    boolean commit() {
        Date date = null;
        Object value = ((JFormattedTextField)this.editor).getValue();
        if (value instanceof Long) {
            date = new Date((Long)value);
        } else if (value instanceof Date) {
            date = (Date)value;
        } else if (value == null) {
            date = new Date(Long.MAX_VALUE);
        }
        try {
            if (!this.editor.getText().equals(this.dateComboBox.getDateFormats()[0].format(date))) {
                ((JFormattedTextField)this.editor).commitEdit();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        value = ((JFormattedTextField)this.editor).getValue();
        JXMonthView monthView = this.popup.getMonthView();
        if (value instanceof Long) {
            date = new Date((Long)value);
        } else if (value instanceof Date) {
            date = (Date)value;
        } else if (value == null) {
            monthView.clearSelection();
            return true;
        }
        if (this.lastDate == null && this.dateComboBox.getItemCount() > 0) {
            this.lastDate = (Date)this.dateComboBox.getItemAt(0);
        }
        if (!monthView.isSelectionEmpty() && date.equals(this.lastDate)) {
            return false;
        }
        monthView.setSelectionInterval(date, date);
        return true;
    }

    private void actionPerformed() {
        ActionEvent ae = new ActionEvent(this.dateComboBox, 1001, "comboBoxEdited", System.currentTimeMillis(), 0);
        ActionListener[] actionListenerArray = this.dateComboBox.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener l = actionListenerArray[n2];
            l.actionPerformed(ae);
            ++n2;
        }
    }

    static Date getDateTime(Date date, Date dateTime, TimeZone tz) {
        GregorianCalendar time = new GregorianCalendar();
        ((Calendar)time).setTimeZone(tz);
        if (dateTime != null) {
            time.setTime(dateTime);
        }
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(tz);
        cal.setTime(date);
        cal.set(11, time.get(11));
        cal.set(12, time.get(12));
        cal.set(13, time.get(13));
        return cal.getTime();
    }

    private class FormattedTextField
    extends JFormattedTextField {
        private static final long serialVersionUID = 1888278314272092430L;

        private FormattedTextField() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                pref.height += 4;
            }
            return pref;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension min = super.getMinimumSize();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                min.height += 4;
            }
            return min;
        }

        @Override
        protected void processKeyEvent(KeyEvent evt) {
            boolean altDown;
            boolean popupVisible = DateComboBoxEditor.this.dateComboBox.isPopupVisible();
            boolean bl = altDown = evt.getKeyCode() == 40 && (evt.getModifiersEx() & 0x200) == 512;
            if (altDown) {
                evt = new KeyEvent(evt.getComponent(), evt.getID(), evt.getWhen(), 0, evt.getKeyCode(), evt.getKeyChar());
            }
            if (!(evt.getKeyCode() != 40 && evt.getKeyCode() != 38 || popupVisible)) {
                DateComboBoxEditor.this.commit();
                DateComboBoxEditor.this.dateComboBox.processKeyEvent(evt);
                DateComboBoxMonthView monthView = (DateComboBoxMonthView)DateComboBoxEditor.this.popup.getMonthView();
                if (!monthView.isSelectionEmpty()) {
                    DateComboBoxEditor.this.setItem(monthView.getSelection().first());
                    monthView.ensureDateVisible();
                }
                return;
            }
            if ((evt.getKeyCode() == 27 || evt.getKeyCode() == 10) && popupVisible) {
                DateComboBoxEditor.this.dateComboBox.hidePopup();
            }
            if (popupVisible && evt.getID() == 401) {
                ((DateComboBoxMonthView)DateComboBoxEditor.this.popup.getMonthView()).processKeyEvent(evt);
            } else {
                if (evt.getKeyCode() == 10 && evt.getID() == 401) {
                    if (DateComboBoxEditor.this.commit()) {
                        DateComboBoxEditor.this.actionPerformed();
                    }
                    if (!DateComboBoxEditor.this.popup.getMonthView().isSelectionEmpty()) {
                        DateComboBoxEditor.this.setItem(DateComboBoxEditor.this.popup.getMonthView().getSelection().first());
                    }
                }
                super.processKeyEvent(evt);
            }
        }
    }
}

