/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.java.document;

import com.macrofocus.application.document.DocumentBasedApplication;
import com.macrofocus.application.document.View;
import com.macrofocus.application.menu.CPMenu;
import com.macrofocus.application.properties.DocumentBasedApplicationProperties;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.docking.DockingFactory;
import com.treemap.AlgorithmFactory;
import com.treemap.app.document.AbstractTreeMapView;
import com.treemap.app.java.document.JavaTreeMapApplication;
import com.treemap.app.java.document.JavaTreeMapDocument;
import com.treemap.app.java.document.OpenDatabaseCommand;
import com.treemap.app.java.document.OpenDirectoryCommand;
import com.treemap.app.java.document.OpenGoogleSpreadsheetCommand;
import com.treemap.app.java.document.PopulateOpenDatasetCommand;
import java.util.List;

public abstract class JavaTreeMapView<Window, Component, Row, Column, Value, Color, Font>
extends AbstractTreeMapView<Component, JavaTreeMapDocument, Row, Column, Value, Color, Font> {
    public JavaTreeMapView(DockingFactory<Component> dockingFactory, CPFactory<Component, Font, ?, Color> factory, ColorMapFactory<Color> colorMapFactory, AlgorithmFactory algorithmFactory, boolean expertMode, DocumentBasedApplicationProperties properties) {
        super(dockingFactory, factory, colorMapFactory, algorithmFactory, expertMode, properties, null);
    }

    public abstract JavaTreeMapApplication<Window, Component, ?, JavaTreeMapDocument> getApplication();

    public void customizeFileOpen(CPMenu<Component> fileMenu) {
        CPWindow window = this.getApplication().getApplicationState().getWindow((View)this);
        fileMenu.addAction("Open Database...", null, new OpenDatabaseCommand(this.getApplication(), window));
        fileMenu.addAction("Open Directory...", null, new OpenDirectoryCommand<Window>(this.getApplication(), window));
        fileMenu.addAction("Open Google Spreadsheet...", null, new OpenGoogleSpreadsheetCommand(this.getApplication(), window));
        final CPMenu onlineMenu = fileMenu.addMenu("Open Dataset");
        String servers = (String)this.getApplication().getResourcesModel().getPropertiesModel().getValue("treemap.servers");
        if (servers != null) {
            for (final String server : servers.split(",")) {
                this.getApplication().runAsyncBackground(new PopulateOpenDatasetCommand<Window, Component>(this.getApplication(), window, server), new DocumentBasedApplication.Callback<PopulateOpenDatasetCommand<Window, Component>, Object>(){

                    public Object execute(final PopulateOpenDatasetCommand<Window, Component> arg) {
                        JavaTreeMapView.this.getApplication().runAsyncUIThread(new Command(){

                            public void execute() {
                                List<UICommand> commands = arg.getCommands();
                                if (commands != null && commands.size() > 0) {
                                    CPMenu serverMenu = onlineMenu.addMenu(server);
                                    for (UICommand command : commands) {
                                        serverMenu.addAction(command);
                                    }
                                }
                            }
                        });
                        return null;
                    }
                });
            }
        }
    }
}

