/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.java.document;

import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.Command;
import com.macrofocus.util.file.FileHelper;
import com.treemap.app.document.TreeMapApplication;
import com.treemap.app.document.TreeMapDocument;
import java.net.URL;

public class OpenDatasetCommand<Window, Component>
implements Command {
    private final TreeMapApplication<Window, Component, ?, TreeMapDocument> application;
    private final CPWindow<Window, Component> window;
    private final String server;
    private final String filename;

    public OpenDatasetCommand(TreeMapApplication application, CPWindow<Window, Component> window, String server, String filename) {
        this.application = application;
        this.server = server;
        this.filename = filename;
        this.window = window;
    }

    public void execute() {
        DocumentOpener documentOpener = new DocumentOpener(){

            public Document openDocument(CPWindow window) throws OpenDocumentException {
                try {
                    String url = new URL(OpenDatasetCommand.this.server + "rest/get/" + OpenDatasetCommand.this.filename.replaceAll(" ", "%20")).toExternalForm();
                    TreeMapDocument document = (TreeMapDocument)OpenDatasetCommand.this.application.openRemoteDocument(FileHelper.removeSuffix((String)OpenDatasetCommand.this.filename), url, null);
                    return document;
                }
                catch (Exception e) {
                    throw new OpenDocumentException("Error", (Throwable)e);
                }
            }
        };
        this.application.openAndShowDocument(this.window, documentOpener, null);
    }
}

