/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe;

import com.macrofocus.molap.dataframe.AbstractDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.Series;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class ArcGISJsonDataFrame
extends AbstractDataFrame<Integer, String, Object> {
    private String[] a;
    private Class[] b;
    private Map<String, String> c;
    private JsonArray d;
    private UniqueIndex<Integer> e = null;
    private UniqueIndex<String> f = null;

    /*
     * WARNING - void declaration
     */
    public ArcGISJsonDataFrame(String json) {
        this((JsonArray)((JsonObject)Json.instance().parse(json)).get("features"), (JsonArray)((JsonObject)Json.instance().parse((String)var1_1)).get("fields"));
        void var1_1;
    }

    public ArcGISJsonDataFrame(JsonArray array, JsonArray fields) {
        int n2;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        this.d = array;
        this.c = new HashMap<String, String>();
        if (fields != null) {
            for (int i2 = 0; i2 < fields.length(); ++i2) {
                jsonObject2 = fields.getObject(i2);
                String string = jsonObject2.getString("name");
                jsonObject = jsonObject2.getString("type");
                this.c.put(string, (String)jsonObject);
            }
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        jsonObject2 = new HashMap();
        for (n2 = 0; n2 < array.length(); ++n2) {
            jsonObject = (JsonObject)array.get(n2);
            JsonObject jsonObject3 = (JsonObject)jsonObject.get("geometry");
            if (jsonObject3 != null) {
                linkedHashSet.add("Longitude");
                linkedHashSet.add("Latitude");
                jsonObject2.put("Longitude", Double.class);
                jsonObject2.put("Latitude", Double.class);
            }
            JsonObject jsonObject4 = (JsonObject)jsonObject.get("attributes");
            for (String string : jsonObject4.keys()) {
                Object object;
                if (!linkedHashSet.contains(string)) {
                    linkedHashSet.add(string);
                    object = jsonObject4.get(string);
                    object = this.a(string, (JsonValue)object);
                    jsonObject2.put(string, object);
                    continue;
                }
                object = jsonObject4.get(string);
                if ((object = this.a(string, (JsonValue)object)) == null) continue;
                Class clazz = (Class)jsonObject2.get(string);
                if (clazz == null) {
                    jsonObject2.put(string, object);
                    continue;
                }
                if (clazz == object) continue;
                jsonObject2.put(string, Object.class);
            }
        }
        this.a = new String[linkedHashSet.size()];
        this.b = new Class[linkedHashSet.size()];
        n2 = 0;
        jsonObject = linkedHashSet.iterator();
        while (jsonObject.hasNext()) {
            String string;
            this.a[n2] = string = (String)jsonObject.next();
            Class<Object> clazz = (Class<Object>)jsonObject2.get(string);
            this.b[n2] = clazz != null ? clazz : Object.class;
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getColumnName(String column) {
        void var1_1;
        return this.a[this.getColumnIndex().getAddress((String)var1_1)];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Class getColumnClass(String column) {
        void var1_1;
        return this.b[this.getColumnIndex().getAddress((String)var1_1)];
    }

    @Override
    public int getRowCount() {
        return this.d.length();
    }

    @Override
    public int getColumnCount() {
        return this.a.length;
    }

    @Override
    public Class getRowClass(Integer row) {
        return Object.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getValueAt(Integer row, String column) {
        void var2_2;
        JsonValue jsonValue;
        if ("Longitude".equals(column)) {
            row = ((JsonObject)this.d.get(row.intValue())).getObject("geometry").get("x");
            return WebMercator.xToLongitude(row.asNumber());
        }
        if ("Latitude".equals(column)) {
            row = ((JsonObject)this.d.get(row.intValue())).getObject("geometry").get("y");
            return WebMercator.yToLatitude(row.asNumber());
        }
        jsonValue = ((JsonObject)this.d.get(jsonValue.intValue())).getObject("attributes").get(column);
        if ("esriFieldTypeDate".equals(this.c.get(var2_2))) {
            if (jsonValue != null && jsonValue.getType() != JsonType.NULL) {
                return new Date((long)jsonValue.asNumber());
            }
            return null;
        }
        return this.a(jsonValue);
    }

    @Override
    public Series<String, ?> getRow(Integer integer) {
        return null;
    }

    public DataFrame join(Series series, String[] strings) {
        return null;
    }

    private Object a(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.getType() == JsonType.NULL) {
            return null;
        }
        if (jsonValue.getType() == JsonType.NUMBER) {
            return jsonValue.asNumber();
        }
        if (jsonValue.getType() == JsonType.BOOLEAN) {
            return jsonValue.asBoolean();
        }
        if (jsonValue.getType() == JsonType.ARRAY) {
            jsonValue = (JsonArray)jsonValue;
            Object[] objectArray = new Object[jsonValue.length()];
            for (int i2 = 0; i2 < jsonValue.length(); ++i2) {
                objectArray[i2] = this.a(jsonValue.get(i2));
            }
            return objectArray;
        }
        if (jsonValue.getType() == JsonType.OBJECT) {
            return jsonValue.toNative();
        }
        return jsonValue.asString();
    }

    private Class a(String string, JsonValue jsonValue) {
        if ("esriFieldTypeDate".equals(this.c.get(string))) {
            return Date.class;
        }
        if (jsonValue == null || jsonValue.getType() == JsonType.NULL) {
            return null;
        }
        if (jsonValue.getType() == JsonType.NUMBER) {
            return Double.class;
        }
        if (jsonValue.getType() == JsonType.BOOLEAN) {
            return Boolean.class;
        }
        if (jsonValue.getType() == JsonType.ARRAY) {
            return Object[].class;
        }
        if (jsonValue.getType() == JsonType.OBJECT) {
            return JsonObject.class;
        }
        return String.class;
    }

    @Override
    public UniqueIndex<Integer> getRowIndex() {
        if (this.e == null) {
            this.e = new IntegerRangeUniqueIndex(0, this.d.length() - 1);
        }
        return this.e;
    }

    @Override
    public UniqueIndex<String> getColumnIndex() {
        if (this.f == null) {
            String[] stringArray = new String[this.a.length];
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                stringArray[i2] = this.a[i2];
            }
            this.f = new DefaultUniqueIndex<String>(stringArray);
        }
        return this.f;
    }

    private static final class WebMercator {
        public static double xToLongitude(double x2) {
            return WebMercator.xToLongitude(x2, true);
        }

        /*
         * WARNING - void declaration
         */
        public static double xToLongitude(double x2, boolean linear) {
            void var2_1;
            double d2 = x2 / 6378137.0;
            double d3 = d2 * 57.29577951308232;
            if (var2_1 != false) {
                return d3;
            }
            double d4 = Math.floor((d3 + 180.0) / 360.0);
            return d3 - d4 * 360.0;
        }

        public static double yToLatitude(double y2) {
            double d2;
            double d3 = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(d2 * -1.0 / 6378137.0));
            return d3 * 57.29577951308232;
        }
    }
}

