/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.subset;

import com.macrofocus.molap.colection.Lists;
import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;

public class SortedArraySetOperations {
    public static int[] diffSortedTIntArrays(int size, int[] indices) {
        int[] nArray = new int[size - indices.length];
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            if (n3 < indices.length && indices[n3] <= i2) {
                ++n3;
                continue;
            }
            nArray[n2++] = i2;
        }
        return nArray;
    }

    public static int[] diffSortedTIntList(int size, int[] indices) {
        TIntArrayList tIntArrayList = Lists.createTIntArrayList(size - indices.length);
        int n2 = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            if (n2 < indices.length && indices[n2] <= i2) {
                ++n2;
                continue;
            }
            tIntArrayList.add(i2);
        }
        return tIntArrayList.toArray();
    }

    public static int[] diffSortedTIntList(int[] a2, int[] b2) {
        if (a2 != null) {
            int[] nArray;
            if (b2 != null) {
                TIntArrayList tIntArrayList = Lists.createTIntArrayList(Math.max(a2.length, b2.length));
                int n2 = 0;
                int n3 = 0;
                while (n2 < a2.length && n3 < b2.length) {
                    if (a2[n2] < b2[n3]) {
                        tIntArrayList.add(a2[n2]);
                        ++n2;
                        continue;
                    }
                    if (a2[n2] > b2[n3]) {
                        ++n3;
                        continue;
                    }
                    ++n2;
                    ++n3;
                }
                while (n2 < a2.length) {
                    tIntArrayList.add(a2[n2]);
                    ++n2;
                }
                return tIntArrayList.toArray();
            }
            return nArray;
        }
        return null;
    }

    public static int[] unionSortedTIntList(int[] a2, int[] b2) {
        int n2;
        TIntArrayList tIntArrayList = Lists.createTIntArrayList(Math.max(a2.length, b2.length));
        int n3 = 0;
        int n4 = 0;
        while (n3 < a2.length && n4 < b2.length) {
            int n5 = n2 = a2[n3] < b2[n4] ? a2[n3++] : b2[n4++];
            while (n3 < a2.length && a2[n3] == n2) {
                ++n3;
            }
            while (n4 < b2.length && b2[n4] == n2) {
                ++n4;
            }
            tIntArrayList.add(n2);
        }
        while (n3 < a2.length) {
            n2 = a2[n3++];
            while (n3 < a2.length && a2[n3] == n2) {
                ++n3;
            }
            tIntArrayList.add(n2);
        }
        while (n4 < b2.length) {
            n2 = b2[n4++];
            while (n4 < b2.length && b2[n4] == n2) {
                ++n4;
            }
            tIntArrayList.add(n2);
        }
        return tIntArrayList.toArray();
    }

    public static int[] unionSortedArrays(int[] a2, int[] b2) {
        int n2;
        assert (a2 != null);
        assert (b2 != null);
        int[] nArray = new int[a2.length + b2.length];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < a2.length && n4 < b2.length) {
            int n6 = n2 = a2[n3] < b2[n4] ? a2[n3++] : b2[n4++];
            while (n3 < a2.length && a2[n3] == n2) {
                ++n3;
            }
            while (n4 < b2.length && b2[n4] == n2) {
                ++n4;
            }
            nArray[n5++] = n2;
        }
        while (n3 < a2.length) {
            n2 = a2[n3++];
            while (n3 < a2.length && a2[n3] == n2) {
                ++n3;
            }
            nArray[n5++] = n2;
        }
        while (n4 < b2.length) {
            n2 = b2[n4++];
            while (n4 < b2.length && b2[n4] == n2) {
                ++n4;
            }
            nArray[n5++] = n2;
        }
        return Arrays.copyOf(nArray, n5);
    }

    public static int[] intersectSortedArrays(int[] a2, int[] b2) {
        assert (a2 != null);
        assert (b2 != null);
        int[] nArray = new int[Math.min(a2.length, b2.length)];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < a2.length && n3 < b2.length) {
            if (a2[n2] < b2[n3]) {
                ++n2;
                continue;
            }
            if (a2[n2] > b2[n3]) {
                ++n3;
                continue;
            }
            if (n4 == 0 || a2[n2] != nArray[n4 - 1]) {
                nArray[n4++] = a2[n2];
            }
            ++n2;
            ++n3;
        }
        return Arrays.copyOfRange(nArray, 0, n4);
    }
}

