/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.hash.THash;
import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.iterator.TIterator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class THashIterator<V>
implements TIterator,
Iterator<V> {
    private final TObjectHash<V> a;
    protected final THash _hash;
    protected int _expectedSize;
    protected int _index;

    /*
     * WARNING - void declaration
     */
    protected THashIterator(TObjectHash<V> hash) {
        void var1_1;
        this._hash = hash;
        this._expectedSize = this._hash.size();
        this._index = this._hash.capacity();
        this.a = var1_1;
    }

    @Override
    public V next() {
        this.moveToNextIndex();
        THashIterator tHashIterator = this;
        return tHashIterator.objectAtIndex(tHashIterator._index);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex() >= 0;
    }

    @Override
    public void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        try {
            this._hash.tempDisableAutoCompaction();
            this._hash.removeAt(this._index);
        }
        finally {
            this._hash.reenableAutoCompaction(false);
        }
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] objectArray = this.a._set;
        int n2 = this._index;
        while (n2-- > 0 && (objectArray[n2] == TObjectHash.FREE || objectArray[n2] == TObjectHash.REMOVED)) {
        }
        return n2;
    }

    protected abstract V objectAtIndex(int var1);
}

