/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.iterator.TPrimitiveIterator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public abstract class THashPrimitiveIterator
implements TPrimitiveIterator {
    protected final TPrimitiveHash _hash;
    protected int _expectedSize;
    protected int _index;

    /*
     * WARNING - void declaration
     */
    public THashPrimitiveIterator(TPrimitiveHash hash) {
        void var1_1;
        this._hash = var1_1;
        this._expectedSize = this._hash.size();
        this._index = this._hash.capacity();
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        byte[] byArray = this._hash._states;
        int n2 = this._index;
        while (n2-- > 0 && byArray[n2] != 1) {
        }
        return n2;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex() >= 0;
    }

    @Override
    public void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        try {
            this._hash.tempDisableAutoCompaction();
            this._hash.removeAt(this._index);
        }
        finally {
            this._hash.reenableAutoCompaction(false);
        }
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }
}

