/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TIntCollection;
import gnu.trove.func.TIntFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TIntIntHash;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;

public class TIntIntHashMap
extends TIntIntHash
implements TIntIntMap {
    protected transient int[] _values;

    public TIntIntHashMap() {
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(int initialCapacity, float loadFactor, int noEntryKey, int noEntryValue) {
        super((int)var1_1, (float)var2_2, (int)var3_3, noEntryValue);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public TIntIntHashMap(int[] keys, int[] values) {
        super(Math.max(keys.length, values.length));
        int n2 = Math.min(keys.length, values.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.put(keys[i2], values[i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(TIntIntMap map) {
        super(map.size());
        void var1_1;
        if (map instanceof TIntIntHashMap) {
            TIntIntHashMap tIntIntHashMap = (TIntIntHashMap)map;
            this._loadFactor = tIntIntHashMap._loadFactor;
            this.no_entry_key = tIntIntHashMap.no_entry_key;
            this.no_entry_value = tIntIntHashMap.no_entry_value;
            if (this.no_entry_key != 0) {
                Arrays.fill(this._set, this.no_entry_key);
            }
            if (this.no_entry_value != 0) {
                Arrays.fill(this._values, this.no_entry_value);
            }
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.putAll((TIntIntMap)var1_1);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int n2;
        n2 = super.setUp(n2);
        this._values = new int[n2];
        return n2;
    }

    @Override
    protected void rehash(int newCapacity) {
        int n2;
        int n3 = this._set.length;
        int[] nArray = this._set;
        int[] nArray2 = this._values;
        byte[] byArray = this._states;
        this._set = new int[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[n2];
        n2 = n3;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            n3 = nArray[n2];
            n3 = this.insertKey(n3);
            this._values[n3] = nArray2[n2];
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int put(int key, int value) {
        void var2_2;
        int n2;
        n2 = this.insertKey(n2);
        return this.a((int)var2_2, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int putIfAbsent(int key, int value) {
        void var2_2;
        int n2;
        if ((n2 = this.insertKey(n2)) < 0) {
            return this._values[-n2 - 1];
        }
        return this.a((int)var2_2, n2);
    }

    private int a(int n2, int n3) {
        int n4 = this.no_entry_value;
        boolean bl = true;
        if (n3 < 0) {
            n3 = -n3 - 1;
            n4 = this._values[n3];
            bl = false;
        }
        this._values[n3] = n2;
        if (bl) {
            TIntIntHashMap tIntIntHashMap = this;
            tIntIntHashMap.postInsertHook(tIntIntHashMap.consumeFreeSlot);
        }
        return n4;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        Iterator iterator;
        this.ensureCapacity(map.size());
        for (Map.Entry entry : iterator.entrySet()) {
            this.put((Integer)entry.getKey(), (Integer)entry.getValue());
        }
    }

    @Override
    public void putAll(TIntIntMap map) {
        TIntIntIterator tIntIntIterator;
        this.ensureCapacity(map.size());
        tIntIntIterator = tIntIntIterator.iterator();
        while (tIntIntIterator.hasNext()) {
            tIntIntIterator.advance();
            this.put(tIntIntIterator.key(), tIntIntIterator.value());
        }
    }

    @Override
    public int get(int key) {
        int n2;
        if ((n2 = this.index(n2)) < 0) {
            return this.no_entry_value;
        }
        return this._values[n2];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._values, 0, this._values.length, this.no_entry_value);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public int remove(int key) {
        int n2;
        int n3 = this.no_entry_value;
        if ((n2 = this.index(n2)) >= 0) {
            n3 = this._values[n2];
            this.removeAt(n2);
        }
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void removeAt(int index) {
        void var1_1;
        this._values[index] = this.no_entry_value;
        super.removeAt((int)var1_1);
    }

    @Override
    public TIntSet keySet() {
        return new TKeyView(this);
    }

    @Override
    public int[] keys() {
        int[] nArray = new int[this.size()];
        if (nArray.length == 0) {
            return nArray;
        }
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n2 = nArray2.length;
        int n3 = 0;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n3++] = nArray2[n2];
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] keys(int[] array) {
        void var1_1;
        int n2 = this.size();
        if (n2 == 0) {
            return array;
        }
        if (array.length < n2) {
            array = new int[n2];
        }
        int[] nArray = this._set;
        byte[] byArray = this._states;
        int n3 = nArray.length;
        int n4 = 0;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            array[n4++] = nArray[n3];
        }
        return var1_1;
    }

    @Override
    public TIntCollection valueCollection() {
        return new TValueView(this);
    }

    @Override
    public int[] values() {
        int[] nArray = new int[this.size()];
        if (nArray.length == 0) {
            return nArray;
        }
        int[] nArray2 = this._values;
        byte[] byArray = this._states;
        int n2 = nArray2.length;
        int n3 = 0;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n3++] = nArray2[n2];
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] values(int[] array) {
        void var1_1;
        int n2 = this.size();
        if (n2 == 0) {
            return array;
        }
        if (array.length < n2) {
            array = new int[n2];
        }
        int[] nArray = this._values;
        byte[] byArray = this._states;
        int n3 = nArray.length;
        int n4 = 0;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            array[n4++] = nArray[n3];
        }
        return var1_1;
    }

    @Override
    public boolean containsValue(int val) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || val != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(int key) {
        void var1_1;
        return this.contains((int)var1_1);
    }

    @Override
    public TIntIntIterator iterator() {
        TIntIntHashMap tIntIntHashMap = this;
        return new a(tIntIntHashMap, tIntIntHashMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean forEachKey(TIntProcedure procedure) {
        void var1_1;
        return this.forEach((TIntProcedure)var1_1);
    }

    @Override
    public boolean forEachValue(TIntProcedure procedure) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || procedure.execute(nArray[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TIntIntProcedure procedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int[] nArray2 = this._values;
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || procedure.execute(nArray[n2], nArray2[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transformValues(TIntFunction func) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n2] = func.execute(nArray[n2]);
        }
    }

    @Override
    public boolean retainEntries(TIntIntProcedure procedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int[] nArray2 = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n2 = nArray.length;
            while (n2-- > 0) {
                if (byArray[n2] != 1 || procedure.execute(nArray[n2], nArray2[n2])) continue;
                this.removeAt(n2);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean increment(int key) {
        void var1_1;
        return this.adjustValue((int)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean adjustValue(int key, int amount) {
        void var2_2;
        int n2;
        if ((n2 = this.index(n2)) < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + var2_2;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int adjustOrPutValue(int key, int adjust_amount, int put_amount) {
        int n2;
        int n3;
        if ((n3 = this.insertKey(n3)) < 0) {
            int n4 = n3 = -n3 - 1;
            int n5 = this._values[n4] + n2;
            this._values[n4] = n5;
            n2 = n5;
            n3 = 0;
        } else {
            void var3_3;
            n2 = this._values[n3] = var3_3;
            n3 = 1;
        }
        if (n3 != 0) {
            TIntIntHashMap tIntIntHashMap = this;
            tIntIntHashMap.postInsertHook(tIntIntHashMap.consumeFreeSlot);
        }
        return n2;
    }

    public boolean equals(Object other) {
        TIntIntMap tIntIntMap;
        if (!(other instanceof TIntIntMap)) {
            return false;
        }
        if ((tIntIntMap = (TIntIntMap)tIntIntMap).size() != this.size()) {
            return false;
        }
        int[] nArray = this._values;
        byte[] byArray = this._states;
        int n2 = this.getNoEntryValue();
        int n3 = tIntIntMap.getNoEntryValue();
        int n4 = nArray.length;
        while (n4-- > 0) {
            if (byArray[n4] != 1) continue;
            int n5 = this._set[n4];
            int n6 = nArray[n4];
            if (n6 == (n5 = tIntIntMap.get(n5)) || n6 == n2 || n5 == n3) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this._states;
        int n3 = this._values.length;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            n2 += HashFunctions.hash(this._set[n3]) ^ HashFunctions.hash(this._values[n3]);
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        this.forEachEntry(new TIntIntProcedure(this, stringBuilder){
            private boolean a = true;
            private /* synthetic */ StringBuilder b;
            {
                this.b = stringBuilder;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean execute(int key, int value) {
                void var2_2;
                void var1_1;
                if (this.a) {
                    this.a = false;
                } else {
                    this.b.append(", ");
                }
                this.b.append((int)var1_1);
                this.b.append("=");
                this.b.append((int)var2_2);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    final class a
    extends THashPrimitiveIterator
    implements TIntIntIterator {
        private /* synthetic */ TIntIntHashMap a;

        a(TIntIntHashMap tIntIntHashMap, TIntIntHashMap tIntIntHashMap2) {
            this.a = tIntIntHashMap;
            super(tIntIntHashMap2);
        }

        @Override
        public final void advance() {
            this.moveToNextIndex();
        }

        @Override
        public final int key() {
            return this.a._set[this._index];
        }

        @Override
        public final int value() {
            return this.a._values[this._index];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int setValue(int val) {
            void var1_1;
            int n2 = this.value();
            this.a._values[this._index] = var1_1;
            return n2;
        }

        @Override
        public final void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                this.a.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    final class c
    extends THashPrimitiveIterator
    implements TIntIterator {
        private /* synthetic */ TIntIntHashMap a;

        c(TIntIntHashMap tIntIntHashMap, TPrimitiveHash tPrimitiveHash) {
            this.a = tIntIntHashMap;
            super(tPrimitiveHash);
        }

        @Override
        public final int next() {
            this.moveToNextIndex();
            return this.a._values[this._index];
        }

        @Override
        public final void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                this.a.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    final class b
    extends THashPrimitiveIterator
    implements TIntIterator {
        private /* synthetic */ TIntIntHashMap a;

        b(TIntIntHashMap tIntIntHashMap, TPrimitiveHash tPrimitiveHash) {
            this.a = tIntIntHashMap;
            super(tPrimitiveHash);
        }

        @Override
        public final int next() {
            this.moveToNextIndex();
            return this.a._set[this._index];
        }

        @Override
        public final void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                this.a.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    protected class TValueView
    implements TIntCollection {
        private /* synthetic */ TIntIntHashMap a;

        /*
         * WARNING - void declaration
         */
        protected TValueView(TIntIntHashMap this$0) {
            void var1_1;
            this.a = var1_1;
        }

        @Override
        public TIntIterator iterator() {
            return new c(this.a, this.a);
        }

        @Override
        public int getNoEntryValue() {
            return this.a.no_entry_value;
        }

        @Override
        public int size() {
            return this.a._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == this.a._size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(int entry) {
            void var1_1;
            return this.a.containsValue((int)var1_1);
        }

        @Override
        public int[] toArray() {
            return this.a.values();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int[] toArray(int[] dest) {
            void var1_1;
            return this.a.values((int[])var1_1);
        }

        @Override
        public boolean add(int entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(int entry) {
            int[] nArray = this.a._values;
            int[] nArray2 = this.a._set;
            int n2 = nArray.length;
            while (n2-- > 0) {
                if (nArray2[n2] == 0 || nArray2[n2] == 2 || entry != nArray[n2]) continue;
                this.a.removeAt(n2);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (obj instanceof Integer) {
                    int n2 = (Integer)obj;
                    if (this.a.containsValue(n2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TIntCollection collection) {
            TIntIterator tIntIterator = collection.iterator();
            while (tIntIterator.hasNext()) {
                if (this.a.containsValue(tIntIterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(int[] array) {
            int[] nArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                if (this.a.containsValue(n3)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TIntCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (collection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(TIntCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (collection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(int[] array) {
            boolean bl = false;
            Arrays.sort(array);
            int[] nArray = this.a._values;
            byte[] byArray = this.a._states;
            int n2 = nArray.length;
            while (n2-- > 0) {
                if (byArray[n2] != 1 || Arrays.binarySearch(array, nArray[n2]) >= 0) continue;
                this.a.removeAt(n2);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Iterator iterator;
            boolean bl = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                int n2;
                Object e2 = iterator.next();
                if (!(e2 instanceof Integer) || !this.remove(n2 = ((Integer)e2).intValue())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(TIntCollection collection) {
            TIntIterator tIntIterator;
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean bl = false;
            tIntIterator = tIntIterator.iterator();
            while (tIntIterator.hasNext()) {
                int n2 = tIntIterator.next();
                if (!this.remove(n2)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(int[] array) {
            boolean bl = false;
            int n2 = array.length;
            while (n2-- > 0) {
                if (!this.remove(array[n2])) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean forEach(TIntProcedure procedure) {
            void var1_1;
            return this.a.forEachValue((TIntProcedure)var1_1);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            this.a.forEachValue(new TIntProcedure(this, stringBuilder){
                private boolean a = true;
                private /* synthetic */ StringBuilder b;
                {
                    this.b = stringBuilder;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean execute(int value) {
                    void var1_1;
                    if (this.a) {
                        this.a = false;
                    } else {
                        this.b.append(", ");
                    }
                    this.b.append((int)var1_1);
                    return true;
                }
            });
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    protected class TKeyView
    implements TIntSet {
        private /* synthetic */ TIntIntHashMap a;

        /*
         * WARNING - void declaration
         */
        protected TKeyView(TIntIntHashMap this$0) {
            void var1_1;
            this.a = var1_1;
        }

        @Override
        public TIntIterator iterator() {
            return new b(this.a, this.a);
        }

        @Override
        public int getNoEntryValue() {
            return this.a.no_entry_key;
        }

        @Override
        public int size() {
            return this.a._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == this.a._size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(int entry) {
            void var1_1;
            return this.a.contains((int)var1_1);
        }

        @Override
        public int[] toArray() {
            return this.a.keys();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int[] toArray(int[] dest) {
            void var1_1;
            return this.a.keys((int[])var1_1);
        }

        @Override
        public boolean add(int entry) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(int entry) {
            void var1_1;
            return this.a.no_entry_value != this.a.remove((int)var1_1);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (obj instanceof Integer) {
                    int n2 = (Integer)obj;
                    if (this.a.containsKey(n2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TIntCollection collection) {
            TIntIterator tIntIterator = collection.iterator();
            while (tIntIterator.hasNext()) {
                if (this.a.containsKey(tIntIterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(int[] array) {
            int[] nArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                if (this.a.contains(n3)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TIntCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (collection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(TIntCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (collection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(int[] array) {
            boolean bl = false;
            Arrays.sort(array);
            int[] nArray = this.a._set;
            byte[] byArray = this.a._states;
            int n2 = nArray.length;
            while (n2-- > 0) {
                if (byArray[n2] != 1 || Arrays.binarySearch(array, nArray[n2]) >= 0) continue;
                this.a.removeAt(n2);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Iterator iterator;
            boolean bl = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                int n2;
                Object e2 = iterator.next();
                if (!(e2 instanceof Integer) || !this.remove(n2 = ((Integer)e2).intValue())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(TIntCollection collection) {
            TIntIterator tIntIterator;
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean bl = false;
            tIntIterator = tIntIterator.iterator();
            while (tIntIterator.hasNext()) {
                int n2 = tIntIterator.next();
                if (!this.remove(n2)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(int[] array) {
            boolean bl = false;
            int n2 = array.length;
            while (n2-- > 0) {
                if (!this.remove(array[n2])) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean forEach(TIntProcedure procedure) {
            void var1_1;
            return this.a.forEachKey((TIntProcedure)var1_1);
        }

        @Override
        public boolean equals(Object other) {
            TIntSet tIntSet;
            if (!(other instanceof TIntSet)) {
                return false;
            }
            if ((tIntSet = (TIntSet)tIntSet).size() != this.size()) {
                return false;
            }
            int n2 = this.a._states.length;
            while (n2-- > 0) {
                if (this.a._states[n2] != 1 || tIntSet.contains(this.a._set[n2])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n2 = 0;
            int n3 = this.a._states.length;
            while (n3-- > 0) {
                if (this.a._states[n3] != 1) continue;
                n2 += HashFunctions.hash(this.a._set[n3]);
            }
            return n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            this.a.forEachKey(new TIntProcedure(this, stringBuilder){
                private boolean a = true;
                private /* synthetic */ StringBuilder b;
                {
                    this.b = stringBuilder;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean execute(int key) {
                    void var1_1;
                    if (this.a) {
                        this.a = false;
                    } else {
                        this.b.append(", ");
                    }
                    this.b.append((int)var1_1);
                    return true;
                }
            });
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}

