/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TIntCollection;
import gnu.trove.func.TIntFunction;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THash;
import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TObjectIntHashMap<K>
extends TObjectHash<K>
implements TObjectIntMap<K> {
    private final TObjectIntProcedure<K> a = new TObjectIntProcedure<K>(this){
        private /* synthetic */ TObjectIntHashMap a;
        {
            this.a = tObjectIntHashMap;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean execute(K key, int value) {
            void var2_2;
            void var1_1;
            this.a.put(var1_1, (int)var2_2);
            return true;
        }
    };
    protected transient int[] _values;
    protected int no_entry_value;

    public TObjectIntHashMap() {
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(int initialCapacity, float loadFactor, int noEntryValue) {
        super((int)var1_1, (float)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.no_entry_value = var3_3;
        if (this.no_entry_value != 0) {
            Arrays.fill(this._values, this.no_entry_value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TObjectIntHashMap(TObjectIntMap<? extends K> map) {
        this(map.size(), 0.5f, map.getNoEntryValue());
        void var1_1;
        if (map instanceof TObjectIntHashMap) {
            TObjectIntHashMap tObjectIntHashMap = (TObjectIntHashMap)map;
            this._loadFactor = tObjectIntHashMap._loadFactor;
            this.no_entry_value = tObjectIntHashMap.no_entry_value;
            if (this.no_entry_value != 0) {
                Arrays.fill(this._values, this.no_entry_value);
            }
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.putAll((TObjectIntMap<K>)var1_1);
    }

    @Override
    public int setUp(int initialCapacity) {
        int n2;
        n2 = super.setUp(n2);
        this._values = new int[n2];
        return n2;
    }

    @Override
    protected void rehash(int newCapacity) {
        int n2;
        int n3 = this._set.length;
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        this._values = new int[n2];
        Arrays.fill(this._values, this.no_entry_value);
        n2 = n3;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED) continue;
            Object object = objectArray[n2];
            int n4 = this.insertKey(object);
            if (n4 < 0) {
                TObjectIntHashMap tObjectIntHashMap = this;
                tObjectIntHashMap.throwObjectContractViolation(tObjectIntHashMap._set[-n4 - 1], object);
            }
            this._set[n4] = object;
            this._values[n4] = nArray[n2];
        }
    }

    @Override
    public int getNoEntryValue() {
        return this.no_entry_value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.contains(var1_1);
    }

    @Override
    public boolean containsValue(int val) {
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || val != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int get(Object key) {
        void var1_1;
        int n2 = this.index(var1_1);
        if (n2 < 0) {
            return this.no_entry_value;
        }
        return this._values[n2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int put(K key, int value) {
        void var2_3;
        void var1_1;
        int n2 = this.insertKey(var1_1);
        return this.a((int)var2_3, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int putIfAbsent(K key, int value) {
        void var2_3;
        void var1_1;
        int n2 = this.insertKey(var1_1);
        if (n2 < 0) {
            return this._values[-n2 - 1];
        }
        return this.a((int)var2_3, n2);
    }

    private int a(int n2, int n3) {
        int n4 = this.no_entry_value;
        boolean bl = true;
        if (n3 < 0) {
            n3 = -n3 - 1;
            n4 = this._values[n3];
            bl = false;
        }
        this._values[n3] = n2;
        if (bl) {
            TObjectIntHashMap tObjectIntHashMap = this;
            tObjectIntHashMap.postInsertHook(tObjectIntHashMap.consumeFreeSlot);
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int remove(Object key) {
        void var1_1;
        int n2 = this.no_entry_value;
        int n3 = this.index(var1_1);
        if (n3 >= 0) {
            n2 = this._values[n3];
            this.removeAt(n3);
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void removeAt(int index) {
        void var1_1;
        this._values[index] = this.no_entry_value;
        super.removeAt((int)var1_1);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> map) {
        Object object = map.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.put(entry.getKey(), (Integer)entry.getValue());
        }
    }

    @Override
    public void putAll(TObjectIntMap<? extends K> map) {
        map.forEachEntry(this.a);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, FREE);
        Arrays.fill(this._values, 0, this._values.length, this.no_entry_value);
    }

    @Override
    public Set<K> keySet() {
        return new KeyView(this);
    }

    @Override
    public Object[] keys() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._set;
        int n2 = this._set.length;
        int n3 = 0;
        while (n2-- > 0) {
            if (objectArray2[n2] == FREE || objectArray2[n2] == REMOVED) continue;
            objectArray[n3++] = objectArray2[n2];
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K[] keys(K[] a2) {
        void var1_1;
        int n2 = this.size();
        if (a2.length < n2) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = this._set;
        int n3 = this._set.length;
        int n4 = 0;
        while (n3-- > 0) {
            if (objectArray[n3] == FREE || objectArray[n3] == REMOVED) continue;
            a2[n4++] = objectArray[n3];
        }
        return var1_1;
    }

    @Override
    public TIntCollection valueCollection() {
        return new TIntValueCollection(this);
    }

    @Override
    public int[] values() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._values;
        Object[] objectArray = this._set;
        int n2 = nArray2.length;
        int n3 = 0;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED) continue;
            nArray[n3++] = nArray2[n2];
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] values(int[] array) {
        void var1_1;
        int n2 = this.size();
        if (array.length < n2) {
            array = new int[n2];
        }
        int[] nArray = this._values;
        Object[] objectArray = this._set;
        int n3 = nArray.length;
        int n4 = 0;
        while (n3-- > 0) {
            if (objectArray[n3] == FREE || objectArray[n3] == REMOVED) continue;
            array[n4++] = nArray[n3];
        }
        if (array.length > n2) {
            array[n2] = this.no_entry_value;
        }
        return var1_1;
    }

    @Override
    public TObjectIntIterator<K> iterator() {
        TObjectIntHashMap tObjectIntHashMap = this;
        return new b(tObjectIntHashMap, tObjectIntHashMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean increment(K key) {
        void var1_1;
        return this.adjustValue(var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean adjustValue(K key, int amount) {
        void var2_3;
        void var1_1;
        int n2 = this.index(var1_1);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + var2_3;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int adjustOrPutValue(K key, int adjust_amount, int put_amount) {
        int n2;
        void var1_1;
        int n3 = this.insertKey(var1_1);
        if (n3 < 0) {
            int n4 = n3 = -n3 - 1;
            int n5 = this._values[n4] + n2;
            this._values[n4] = n5;
            n2 = n5;
            n3 = 0;
        } else {
            void var3_4;
            n2 = this._values[n3] = var3_4;
            n3 = 1;
        }
        if (n3 != 0) {
            TObjectIntHashMap tObjectIntHashMap = this;
            tObjectIntHashMap.postInsertHook(tObjectIntHashMap.consumeFreeSlot);
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean forEachKey(TObjectProcedure<? super K> procedure) {
        void var1_1;
        return this.forEach(var1_1);
    }

    @Override
    public boolean forEachValue(TIntProcedure procedure) {
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(nArray[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TObjectIntProcedure<? super K> procedure) {
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n2 = objectArray.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(objectArray[n2], nArray[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainEntries(TObjectIntProcedure<? super K> procedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n2 = objectArray.length;
            while (n2-- > 0) {
                if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(objectArray[n2], nArray[n2])) continue;
                this.removeAt(n2);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    @Override
    public void transformValues(TIntFunction func) {
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (objectArray[n2] == null || objectArray[n2] == REMOVED) continue;
            nArray[n2] = func.execute(nArray[n2]);
        }
    }

    @Override
    public boolean equals(Object other) {
        TObjectIntMap tObjectIntMap;
        if (!(other instanceof TObjectIntMap)) {
            return false;
        }
        if ((tObjectIntMap = (TObjectIntMap)tObjectIntMap).size() != this.size()) {
            return false;
        }
        try {
            TObjectIntIterator<K> tObjectIntIterator = this.iterator();
            while (tObjectIntIterator.hasNext()) {
                tObjectIntIterator.advance();
                K k2 = tObjectIntIterator.key();
                int n2 = tObjectIntIterator.value();
                if (!(n2 == this.no_entry_value ? tObjectIntMap.get(k2) != tObjectIntMap.getNoEntryValue() || !tObjectIntMap.containsKey(k2) : n2 != tObjectIntMap.get(k2))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {}
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n3 = this._values.length;
        while (n3-- > 0) {
            if (objectArray[n3] == FREE || objectArray[n3] == REMOVED) continue;
            n2 += HashFunctions.hash(nArray[n3]) ^ (objectArray[n3] == null ? 0 : objectArray[n3].hashCode());
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        this.forEachEntry(new TObjectIntProcedure<K>(this, stringBuilder){
            private boolean a = true;
            private /* synthetic */ StringBuilder b;
            {
                this.b = stringBuilder;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean execute(K key, int value) {
                void var2_2;
                void var1_1;
                if (this.a) {
                    this.a = false;
                } else {
                    this.b.append(",");
                }
                this.b.append(var1_1).append("=").append((int)var2_2);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    final class b<K>
    extends TObjectHashIterator<K>
    implements TObjectIntIterator<K> {
        private final TObjectIntHashMap<K> a;

        public b(TObjectIntHashMap tObjectIntHashMap, TObjectIntHashMap<K> tObjectIntHashMap2) {
            super(tObjectIntHashMap2);
            this.a = tObjectIntHashMap2;
        }

        @Override
        public final void advance() {
            this.moveToNextIndex();
        }

        @Override
        public final K key() {
            return (K)this.a._set[this._index];
        }

        @Override
        public final int value() {
            return this.a._values[this._index];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int setValue(int val) {
            void var1_1;
            int n2 = this.value();
            this.a._values[this._index] = var1_1;
            return n2;
        }
    }

    final class TIntValueCollection
    implements TIntCollection {
        final /* synthetic */ TObjectIntHashMap a;

        /*
         * WARNING - void declaration
         */
        TIntValueCollection(TObjectIntHashMap this$0) {
            void var1_1;
            this.a = var1_1;
        }

        @Override
        public final TIntIterator iterator() {
            return new TObjectIntValueHashIterator(this);
        }

        @Override
        public final int getNoEntryValue() {
            return this.a.no_entry_value;
        }

        @Override
        public final int size() {
            return this.a._size;
        }

        @Override
        public final boolean isEmpty() {
            return 0 == this.a._size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(int entry) {
            void var1_1;
            return this.a.containsValue((int)var1_1);
        }

        @Override
        public final int[] toArray() {
            return this.a.values();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int[] toArray(int[] dest) {
            void var1_1;
            return this.a.values((int[])var1_1);
        }

        @Override
        public final boolean add(int entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean remove(int entry) {
            int[] nArray = this.a._values;
            Object[] objectArray = this.a._set;
            int n2 = nArray.length;
            while (n2-- > 0) {
                if (objectArray[n2] == TObjectHash.FREE || objectArray[n2] == TObjectHash.REMOVED || entry != nArray[n2]) continue;
                this.a.removeAt(n2);
                return true;
            }
            return false;
        }

        @Override
        public final boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (obj instanceof Integer) {
                    int n2 = (Integer)obj;
                    if (this.a.containsValue(n2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public final boolean containsAll(TIntCollection collection) {
            TIntIterator tIntIterator = collection.iterator();
            while (tIntIterator.hasNext()) {
                if (this.a.containsValue(tIntIterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean containsAll(int[] array) {
            int[] nArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                if (this.a.containsValue(n3)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean addAll(Collection<? extends Integer> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(TIntCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(int[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (collection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean retainAll(TIntCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (collection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean retainAll(int[] array) {
            boolean bl = false;
            Arrays.sort(array);
            int[] nArray = this.a._values;
            Object[] objectArray = this.a._set;
            int n2 = this.a._set.length;
            while (n2-- > 0) {
                if (objectArray[n2] == TObjectHash.FREE || objectArray[n2] == TObjectHash.REMOVED || Arrays.binarySearch(array, nArray[n2]) >= 0) continue;
                this.a.removeAt(n2);
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean removeAll(Collection<?> collection) {
            Iterator iterator;
            boolean bl = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                int n2;
                Object e2 = iterator.next();
                if (!(e2 instanceof Integer) || !this.remove(n2 = ((Integer)e2).intValue())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean removeAll(TIntCollection collection) {
            TIntIterator tIntIterator;
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean bl = false;
            tIntIterator = tIntIterator.iterator();
            while (tIntIterator.hasNext()) {
                int n2 = tIntIterator.next();
                if (!this.remove(n2)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean removeAll(int[] array) {
            boolean bl = false;
            int n2 = array.length;
            while (n2-- > 0) {
                if (!this.remove(array[n2])) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public final void clear() {
            this.a.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean forEach(TIntProcedure procedure) {
            void var1_1;
            return this.a.forEachValue((TIntProcedure)var1_1);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            this.a.forEachValue(new TIntProcedure(this, stringBuilder){
                private boolean a = true;
                private /* synthetic */ StringBuilder b;
                {
                    this.b = stringBuilder;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean execute(int value) {
                    void var1_1;
                    if (this.a) {
                        this.a = false;
                    } else {
                        this.b.append(", ");
                    }
                    this.b.append((int)var1_1);
                    return true;
                }
            });
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        class TObjectIntValueHashIterator
        implements TIntIterator {
            protected THash _hash;
            protected int _expectedSize;
            protected int _index;
            private /* synthetic */ TIntValueCollection a;

            /*
             * WARNING - void declaration
             */
            TObjectIntValueHashIterator(TIntValueCollection this$1) {
                void var1_1;
                this.a = var1_1;
                this._hash = this.a.a;
                this._expectedSize = this._hash.size();
                this._index = this._hash.capacity();
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() >= 0;
            }

            @Override
            public int next() {
                this.moveToNextIndex();
                return this.a.a._values[this._index];
            }

            @Override
            public void remove() {
                if (this._expectedSize != this._hash.size()) {
                    throw new ConcurrentModificationException();
                }
                try {
                    this._hash.tempDisableAutoCompaction();
                    this.a.a.removeAt(this._index);
                }
                finally {
                    this._hash.reenableAutoCompaction(false);
                }
                --this._expectedSize;
            }

            protected final void moveToNextIndex() {
                this._index = this.nextIndex();
                if (this._index < 0) {
                    throw new NoSuchElementException();
                }
            }

            protected final int nextIndex() {
                if (this._expectedSize != this._hash.size()) {
                    throw new ConcurrentModificationException();
                }
                Object[] objectArray = this.a.a._set;
                int n2 = this._index;
                while (n2-- > 0 && (objectArray[n2] == TObjectHash.FREE || objectArray[n2] == TObjectHash.REMOVED)) {
                }
                return n2;
            }
        }
    }

    abstract class a<E>
    extends AbstractSet<E>
    implements Iterable<E>,
    Set<E> {
        private /* synthetic */ TObjectIntHashMap a;

        private a(TObjectIntHashMap tObjectIntHashMap) {
            this.a = tObjectIntHashMap;
        }

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object key) {
            void var1_1;
            return this.containsElement(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o2) {
            void var1_1;
            return this.removeElement(var1_1);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean add(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator iterator = this.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                objectArray[n2] = iterator.next();
                ++n2;
            }
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a2) {
            void var1_1;
            int n2 = this.size();
            if (a2.length < n2) {
                throw new IllegalArgumentException();
            }
            Iterator iterator = this.iterator();
            T[] TArray = a2;
            for (int i2 = 0; i2 < n2; ++i2) {
                TArray[i2] = iterator.next();
            }
            if (a2.length > n2) {
                a2[n2] = null;
            }
            return var1_1;
        }

        @Override
        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        /* synthetic */ a(TObjectIntHashMap tObjectIntHashMap, byte by) {
            this(tObjectIntHashMap);
        }
    }

    protected class KeyView
    extends a {
        private /* synthetic */ TObjectIntHashMap a;

        /*
         * WARNING - void declaration
         */
        protected KeyView(TObjectIntHashMap this$0) {
            void var1_1;
            this.a = this$0;
            super((TObjectIntHashMap)var1_1, (byte)0);
        }

        @Override
        public Iterator<K> iterator() {
            return new TObjectHashIterator(this.a);
        }

        /*
         * WARNING - void declaration
         */
        public boolean removeElement(K key) {
            void var1_1;
            return this.a.no_entry_value != this.a.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean containsElement(K key) {
            void var1_1;
            return this.a.contains(var1_1);
        }
    }
}

