/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.ArrayList;
import java.util.Iterator;
import prefuse.data.expression.AbstractPredicate;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.Predicate;

public abstract class CompositePredicate
extends AbstractPredicate {
    protected ArrayList<Predicate> m_clauses = new ArrayList(2);

    public CompositePredicate() {
    }

    /*
     * WARNING - void declaration
     */
    public CompositePredicate(Predicate p1, Predicate p2) {
        void var2_2;
        void var1_1;
        this.m_clauses.add((Predicate)var1_1);
        this.m_clauses.add((Predicate)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void add(Predicate p2) {
        void var1_1;
        if (this.m_clauses.contains(p2)) {
            throw new IllegalArgumentException("Duplicate predicate.");
        }
        this.m_clauses.add((Predicate)var1_1);
        this.fireExpressionChange();
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(Predicate p2) {
        void var1_1;
        if (this.m_clauses.remove(var1_1)) {
            this.fireExpressionChange();
            return true;
        }
        return false;
    }

    public void clear() {
        this.removeChildListeners();
        this.m_clauses.clear();
        this.fireExpressionChange();
    }

    public int size() {
        return this.m_clauses.size();
    }

    /*
     * WARNING - void declaration
     */
    public Predicate getSubPredicate(int idx) {
        void var1_1;
        return this.m_clauses.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void set(Predicate p2) {
        void var1_1;
        this.removeChildListeners();
        this.m_clauses.clear();
        this.m_clauses.add((Predicate)var1_1);
        if (this.hasListeners()) {
            this.addChildListeners();
        }
        this.fireExpressionChange();
    }

    public void set(Predicate[] p2) {
        this.removeChildListeners();
        this.m_clauses.clear();
        for (int i2 = 0; i2 < p2.length; ++i2) {
            if (this.m_clauses.contains(p2)) continue;
            this.m_clauses.add(p2[i2]);
        }
        if (this.hasListeners()) {
            this.addChildListeners();
        }
        this.fireExpressionChange();
    }

    @Override
    public void visit(ExpressionVisitor v2) {
        v2.visitExpression(this);
        Iterator<Predicate> iterator = this.m_clauses.iterator();
        while (iterator.hasNext()) {
            v2.down();
            ((Expression)iterator.next()).visit(v2);
            v2.up();
        }
    }

    @Override
    protected void addChildListeners() {
        Iterator<Predicate> iterator = this.m_clauses.iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).addExpressionListener(this);
        }
    }

    @Override
    protected void removeChildListeners() {
        Iterator<Predicate> iterator = this.m_clauses.iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).removeExpressionListener(this);
        }
    }

    protected String predicateToString(String op) {
        if (this.m_clauses.size() == 1) {
            return this.m_clauses.get(0).toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Iterator<Predicate> iterator = this.m_clauses.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
            stringBuffer.append(op);
            stringBuffer.append(" ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

