/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe.java;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.molap.dataframe.AbstractDataFrameFactory;
import com.macrofocus.molap.dataframe.DataFrameFactory;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class CPDataFrameFactory
extends AbstractDataFrameFactory {
    private static final CPDataFrameFactory ourInstance = new CPDataFrameFactory();

    public static CPDataFrameFactory getInstance() {
        return ourInstance;
    }

    public static <V> MutableDataFrame<Integer, String, V> fromRowMajorArray(String[] names, Class[] classes, V[][] data) {
        return new DefaultDataFrame(names, classes, (Object[][])data);
    }

    public void fromJson(String url, DataFrameFactory.Callback callback) throws IOException {
        callback.dataFrameCreated(this.fromJSON(url));
    }

    public MutableDataFrame<Integer, String, Object> fromJSON(String url) throws IOException {
        return this.fromJSON(new URL(url.replaceAll(" ", "%20")));
    }

    public MutableDataFrame<Integer, String, Object> fromJSON(URL url) throws IOException {
        String content = CPDataFrameFactory.convertStreamToString(url.openStream());
        return new DefaultDataFrame(this.fromJsonString(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

