/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.java.AbstractDataFrameWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelDataFrameWriter
extends AbstractDataFrameWriter {
    private TypemapModel typemapModel = new DefaultTypemapModel();
    private final OutputStream out;
    private int row = 0;
    private int column = 0;
    private Workbook wb = new HSSFWorkbook();
    private CellStyle dateCellStyle = null;
    private CreationHelper createHelper;
    private Sheet s = this.wb.createSheet();
    private Row r = null;

    public ExcelDataFrameWriter(OutputStream out) {
        this.out = out;
    }

    public void writeColumnName(String value, boolean hasMore) throws IOException {
        if (this.r == null) {
            this.r = this.s.createRow(this.row);
        }
        Cell cell = this.r.createCell(this.column);
        if (value != null) {
            cell.setCellValue(value);
        }
        this.nextColumn(hasMore);
    }

    public boolean includeType() {
        return false;
    }

    public void writeType(Class cl, boolean hasMore) throws IOException {
        String value = this.typemapModel.getType(cl);
        if (this.r == null) {
            this.r = this.s.createRow(this.row);
        }
        Cell cell = this.r.createCell(this.column);
        if (value != null) {
            cell.setCellValue(value);
        }
        this.nextColumn(hasMore);
    }

    public void writeCell(Object value, DataFrame dataFrame, Object rowKey, Object columnKey) throws IOException {
        if (this.r == null) {
            this.r = this.s.createRow(this.row);
        }
        Cell cell = this.r.createCell(this.column);
        if (value != null) {
            if (value instanceof String[]) {
                String[] array = (String[])value;
                String str = "";
                for (int i = 0; i < array.length; ++i) {
                    String s = array[i];
                    str = str + s;
                    if (i >= array.length - 1) continue;
                    str = str + ".";
                }
                cell.setCellValue(str);
            } else if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Number) {
                cell.setCellValue(((Number)value).doubleValue());
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
                cell.setCellStyle(this.getDateCellStyle());
            } else if (value instanceof Calendar) {
                cell.setCellValue((Calendar)value);
                cell.setCellStyle(this.getDateCellStyle());
            } else {
                cell.setCellValue(value.toString());
            }
        }
    }

    public void nextColumn(boolean hasMore) throws IOException {
        ++this.column;
    }

    public void nextRow() throws IOException {
        this.column = 0;
        ++this.row;
        this.r = null;
    }

    public void close() throws IOException {
        this.wb.write(this.out);
        this.out.close();
    }

    public CellStyle getDateCellStyle() {
        if (this.createHelper == null) {
            this.createHelper = this.wb.getCreationHelper();
        }
        if (this.dateCellStyle == null) {
            this.dateCellStyle = this.wb.createCellStyle();
            this.dateCellStyle.setDataFormat(this.createHelper.createDataFormat().getFormat("m/d/yyyy hh:mm"));
        }
        return this.dateCellStyle;
    }
}

