/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.java.AbstractDataFrameWriter;
import com.macrofocus.molap.exporter.java.JSONDataFrameWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeoJSONDataFrameWriter
extends AbstractDataFrameWriter {
    private final OutputStreamWriter writer;
    private int columnCount;
    private Map<Integer, String> columnNames;
    private Map<Integer, Class> columnClass;
    private String newLine;
    private int row = 0;
    private int column = 0;
    private int geoColumn = -1;

    public GeoJSONDataFrameWriter(OutputStreamWriter writer, int columnCount, String newLine) throws IOException {
        this.writer = writer;
        this.columnCount = columnCount;
        this.columnNames = new HashMap<Integer, String>();
        this.columnClass = new HashMap<Integer, Class>();
        this.newLine = newLine;
        writer.write("{");
        writer.write(newLine);
        writer.write("\t\"type\": \"FeatureCollection\",");
        writer.write(newLine);
        writer.write("\t\"features\": [");
    }

    public void writeColumnName(String name, boolean hasMore) throws IOException {
        this.columnNames.put(this.column, name);
        ++this.column;
    }

    public boolean includeType() {
        return true;
    }

    public void writeType(Class value, boolean hasMore) throws IOException {
        this.columnClass.put(this.column, value);
        if (this.geoColumn < 0 && Geometry.class.isAssignableFrom(value)) {
            this.geoColumn = this.column;
        }
        ++this.column;
    }

    public void writeCell(Object value, DataFrame dataFrame, Object rowKey, Object columnKey) throws IOException {
        if (this.column != this.geoColumn) {
            if (this.column == 0) {
                Geometry geometry;
                if (this.row > 2) {
                    this.writer.write(this.newLine);
                    this.writer.write("\t\t\t}");
                    this.writer.write(this.newLine);
                    this.writer.write("\t\t},");
                }
                this.writer.write(this.newLine);
                this.writer.write("\t\t{");
                this.writer.write(this.newLine);
                this.writer.write("\t\t\t\"type\": \"Feature\",");
                if (this.geoColumn > 0 && (geometry = (Geometry)dataFrame.getValueAt(rowKey, dataFrame.getColumnKey(this.geoColumn))) != null) {
                    this.writer.write(this.newLine);
                    this.writer.write("\t\t\t\"geometry\": ");
                    this.write(this.writer, geometry);
                    this.writer.write(",");
                }
                this.writer.write(this.newLine);
                this.writer.write("\t\t\t\"properties\": {");
                this.writer.write(this.newLine);
            } else if (value != null) {
                this.writer.write(", ");
                this.writer.write(this.newLine);
            }
            if (value != null) {
                this.writer.write("\t\t\t\t\"" + this.columnNames.get(this.column) + "\": ");
                String str = value instanceof Date ? this.dateToString(dataFrame, columnKey, (Date)value) : value.toString();
                if (value instanceof Number) {
                    str = GeoJSONDataFrameWriter.numberToString((Number)value);
                } else if (value instanceof String[]) {
                    String[] array = (String[])value;
                    str = "[";
                    for (int i = 0; i < array.length; ++i) {
                        String s = array[i];
                        str = str + "\"" + JSONDataFrameWriter.quote(s) + "\"";
                        if (i >= array.length - 1) continue;
                        str = str + ", ";
                    }
                    str = str + "]";
                } else {
                    str = "\"" + JSONDataFrameWriter.quote(str) + "\"";
                }
                this.writer.write(str);
            }
        }
    }

    public void write(Writer output, Geometry geom) throws IOException {
        NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(6);
        nf.setMinimumFractionDigits(0);
        if (geom instanceof Point) {
            Point v = (Point)geom;
            output.append("{\"type\":\"Point\",\"coordinates\":");
            this.write(output, nf, v.getCoordinate());
            output.append("}");
            return;
        }
        if (geom instanceof Polygon) {
            output.append("{\"type\":\"Polygon\",\"coordinates\":");
            this.write(output, nf, (Polygon)geom);
            output.append("}");
            return;
        }
        if (geom instanceof LineString) {
            LineString v = (LineString)geom;
            output.append("{\"type\":\"LineString\",\"coordinates\":");
            this.write(output, nf, v.getCoordinateSequence());
            output.append("}");
            return;
        }
        if (geom instanceof MultiPoint) {
            MultiPoint v = (MultiPoint)geom;
            output.append("{\"type\":\"MultiPoint\",\"coordinates\":");
            this.write(output, nf, v.getCoordinates());
            output.append("}");
            return;
        }
        if (geom instanceof MultiLineString) {
            MultiLineString v = (MultiLineString)geom;
            output.append("{\"type\":\"MultiLineString\",\"coordinates\":[");
            for (int i = 0; i < v.getNumGeometries(); ++i) {
                if (i > 0) {
                    output.append(',');
                }
                this.write(output, nf, v.getGeometryN(i).getCoordinates());
            }
            output.append("]}");
        } else if (geom instanceof MultiPolygon) {
            MultiPolygon v = (MultiPolygon)geom;
            output.append("{\"type\":\"MultiPolygon\",\"coordinates\":[");
            for (int i = 0; i < v.getNumGeometries(); ++i) {
                if (i > 0) {
                    output.append(',');
                }
                this.write(output, nf, (Polygon)v.getGeometryN(i));
            }
            output.append("]}");
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection v = (GeometryCollection)geom;
            output.append("{\"type\":\"GeometryCollection\",\"geometries\":[");
            for (int i = 0; i < v.getNumGeometries(); ++i) {
                if (i > 0) {
                    output.append(',');
                }
                this.write(output, v.getGeometryN(i));
            }
            output.append("]}");
        } else {
            throw new UnsupportedOperationException("unknown: " + geom);
        }
    }

    protected void write(Writer output, NumberFormat nf, Coordinate coord) throws IOException {
        output.write(91);
        output.write(nf.format(coord.getX()));
        output.write(44);
        output.write(nf.format(coord.getY()));
        output.write(93);
    }

    protected void write(Writer output, NumberFormat nf, CoordinateSequence coordseq) throws IOException {
        output.write(91);
        int dim = coordseq.getDimension();
        for (int i = 0; i < coordseq.size(); ++i) {
            double v;
            if (i > 0) {
                output.write(44);
            }
            output.write(91);
            output.write(nf.format(coordseq.getOrdinate(i, 0)));
            output.write(44);
            output.write(nf.format(coordseq.getOrdinate(i, 1)));
            if (dim > 2 && !Double.isNaN(v = coordseq.getOrdinate(i, 2))) {
                output.write(44);
                output.write(nf.format(v));
            }
            output.write(93);
        }
        output.write(93);
    }

    protected void write(Writer output, NumberFormat nf, Coordinate[] coord) throws IOException {
        output.write(91);
        for (int i = 0; i < coord.length; ++i) {
            if (i > 0) {
                output.append(',');
            }
            this.write(output, nf, coord[i]);
        }
        output.write(93);
    }

    protected void write(Writer output, NumberFormat nf, Polygon p) throws IOException {
        output.write(91);
        this.write(output, nf, p.getExteriorRing().getCoordinateSequence());
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            output.append(',');
            this.write(output, nf, p.getInteriorRingN(i).getCoordinateSequence());
        }
        output.write(93);
    }

    public void nextColumn(boolean hasMore) throws IOException {
        ++this.column;
    }

    public void nextRow() throws IOException {
        this.column = 0;
        ++this.row;
    }

    public void close() throws IOException {
        if (this.row > 2) {
            this.writer.write("}");
            this.writer.write(this.newLine);
            this.writer.write("\t\t}");
        }
        this.writer.write(this.newLine);
        this.writer.write("\t]");
        this.writer.write(this.newLine);
        this.writer.write("}");
        this.writer.close();
    }
}

