/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.java.AbstractDataFrameWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JSONDataFrameWriter
extends AbstractDataFrameWriter {
    private final Writer writer;
    private Map<Integer, String> columnNames;
    private String newLine;
    private int row = 0;
    private int column = 0;
    private boolean first = true;

    public JSONDataFrameWriter(Writer writer, String newLine) throws IOException {
        this.writer = writer;
        this.columnNames = new HashMap<Integer, String>();
        this.newLine = newLine;
        writer.write("{");
        writer.write(newLine);
    }

    @Override
    public void start() throws IOException {
        this.start("data");
    }

    public void start(String name) throws IOException {
        if (!this.first) {
            this.writer.write(",");
            this.writer.write(this.newLine);
        } else {
            this.first = false;
        }
        this.writer.write("\t\"" + name + "\": [");
    }

    public void writeColumnName(String name, boolean hasMore) throws IOException {
        this.columnNames.put(this.column, name);
        ++this.column;
    }

    public boolean includeType() {
        return false;
    }

    public void writeType(Class value, boolean hasMore) throws IOException {
    }

    public void writeCell(Object value, DataFrame dataFrame, Object rowKey, Object columnKey) throws IOException {
        String str;
        if (this.column == 0) {
            if (this.row > 1) {
                this.writer.write("},");
            }
            this.writer.write(this.newLine);
            this.writer.write("\t\t{");
        } else {
            this.writer.write(", ");
        }
        if (value == null) {
            str = "null";
        } else if (value instanceof Date) {
            str = "\"" + this.dateToString(dataFrame, columnKey, (Date)value) + "\"";
        } else if (value instanceof Number) {
            str = JSONDataFrameWriter.numberToString((Number)value);
        } else if (value instanceof Boolean) {
            str = value.toString();
        } else if (value instanceof String[]) {
            String[] array = (String[])value;
            str = "[";
            for (int i = 0; i < array.length; ++i) {
                String s = array[i];
                str = str + "\"" + JSONDataFrameWriter.quote(s) + "\"";
                if (i >= array.length - 1) continue;
                str = str + ", ";
            }
            str = str + "]";
        } else {
            str = value.toString();
            str = str.length() > 0 ? "\"" + JSONDataFrameWriter.quote(str) + "\"" : "null";
        }
        this.writer.write("\"" + this.columnNames.get(this.column) + "\": ");
        this.writer.write(str);
    }

    static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void nextColumn(boolean hasMore) throws IOException {
        ++this.column;
    }

    public void nextRow() throws IOException {
        this.column = 0;
        ++this.row;
    }

    public void end() throws IOException {
        if (this.row > 2) {
            this.writer.write("}");
        }
        this.writer.write(this.newLine);
        this.writer.write("\t]");
        this.row = 0;
        this.column = 0;
    }

    public void close() throws IOException {
        this.end();
        this.terminate();
    }

    public void terminate() throws IOException {
        this.writer.write(this.newLine);
        this.writer.write("}");
        this.writer.close();
    }
}

