/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.parquet;

import java.io.IOException;
import java.io.OutputStream;

public class PositionOutputStream
extends org.apache.parquet.io.PositionOutputStream
implements Comparable<PositionOutputStream> {
    private long position = 0L;
    private final OutputStream outputStream;

    public PositionOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public PositionOutputStream(OutputStream outputStream, long positionOffset) {
        this.outputStream = outputStream;
        this.position = positionOffset;
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
        ++this.position;
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        this.position += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.position += (long)len;
    }

    public long getPos() throws IOException {
        return this.position;
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.outputStream == null ? 0 : this.outputStream.hashCode());
        result = 31 * result + (int)(this.position ^ this.position >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PositionOutputStream other = (PositionOutputStream)obj;
        if (this.outputStream == null ? other.outputStream != null : !this.outputStream.equals(other.outputStream)) {
            return false;
        }
        return this.position == other.position;
    }

    @Override
    public int compareTo(PositionOutputStream o) {
        return Long.compare(this.position, o.position);
    }
}

