/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.openexi.proc.io.BitInputStream;
import org.openexi.proc.io.HeaderOptionsInputStream;

public final class BodyBitInputStream
extends BitInputStream {
    private static final int BYTEBUFFER_LENGTH = 8192;
    private final byte[] m_bytes = new byte[8192];
    private int m_bufLen = 0;
    private int m_curPos = 0;

    BodyBitInputStream() {
    }

    void setInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.nBits = 0;
        this.bitBuf = 0;
        this.m_bufLen = 0;
        this.m_curPos = 0;
    }

    void inheritResidue(HeaderOptionsInputStream headerOptionsInputStream) {
        this.in = headerOptionsInputStream.in;
        this.nBits = headerOptionsInputStream.nBits;
        this.bitBuf = headerOptionsInputStream.bitBuf;
        this.m_bufLen = 0;
        this.m_curPos = 0;
    }

    private int fill() throws IOException {
        assert (this.m_curPos == this.m_bufLen);
        this.m_curPos = 0;
        this.m_bufLen = this.in.read(this.m_bytes, 0, 8192);
        if (this.m_bufLen == -1) {
            this.m_bufLen = 0;
            return -1;
        }
        return this.m_bufLen;
    }

    public boolean getBit() throws IOException {
        if (--this.nBits != -1) {
            return (this.bitBuf >>> this.nBits & 1) == 1;
        }
        if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
            throw new EOFException();
        }
        this.nBits = 7;
        this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
        return (this.bitBuf >>> 7 & 1) == 1;
    }

    public int getBits(int n) throws IOException {
        int n2 = 0;
        while (n > this.nBits) {
            n2 |= (this.bitBuf & (1 << this.nBits) - 1) << (n -= this.nBits);
            if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                throw new EOFException();
            }
            this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
            this.nBits = 8;
        }
        return n2 | this.bitBuf >>> (this.nBits -= n) & (1 << n) - 1;
    }

    public int getOneBit() throws IOException {
        switch (this.nBits) {
            case 0: {
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 7;
                return this.bitBuf >>> 7 & 1;
            }
            case 1: {
                this.nBits = 0;
                return this.bitBuf & 1;
            }
            case 2: {
                this.nBits = 1;
                return this.bitBuf >>> 1 & 1;
            }
            case 3: {
                this.nBits = 2;
                return this.bitBuf >>> 2 & 1;
            }
            case 4: {
                this.nBits = 3;
                return this.bitBuf >>> 3 & 1;
            }
            case 5: {
                this.nBits = 4;
                return this.bitBuf >>> 4 & 1;
            }
            case 6: {
                this.nBits = 5;
                return this.bitBuf >>> 5 & 1;
            }
            case 7: {
                this.nBits = 6;
                return this.bitBuf >>> 6 & 1;
            }
            case 8: {
                this.nBits = 7;
                return this.bitBuf >>> 7 & 1;
            }
        }
        assert (false);
        return -1;
    }

    public int getTwoBits() throws IOException {
        switch (this.nBits) {
            case 0: {
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 6;
                return this.bitBuf >>> 6 & 3;
            }
            case 1: {
                int n = (this.bitBuf & 1) << 1;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 7;
                return n | this.bitBuf >>> 7 & 1;
            }
            case 2: {
                this.nBits = 0;
                return this.bitBuf & 3;
            }
            case 3: {
                this.nBits = 1;
                return this.bitBuf >>> 1 & 3;
            }
            case 4: {
                this.nBits = 2;
                return this.bitBuf >>> 2 & 3;
            }
            case 5: {
                this.nBits = 3;
                return this.bitBuf >>> 3 & 3;
            }
            case 6: {
                this.nBits = 4;
                return this.bitBuf >>> 4 & 3;
            }
            case 7: {
                this.nBits = 5;
                return this.bitBuf >>> 5 & 3;
            }
            case 8: {
                this.nBits = 6;
                return this.bitBuf >>> 6 & 3;
            }
        }
        assert (false);
        return -1;
    }

    public int getThreeBits() throws IOException {
        switch (this.nBits) {
            case 0: {
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 5;
                return this.bitBuf >>> 5 & 7;
            }
            case 1: {
                int n = (this.bitBuf & 1) << 2;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 6;
                return n | this.bitBuf >>> 6 & 3;
            }
            case 2: {
                int n = (this.bitBuf & 3) << 1;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 7;
                return n | this.bitBuf >>> 7 & 1;
            }
            case 3: {
                this.nBits = 0;
                return this.bitBuf & 7;
            }
            case 4: {
                this.nBits = 1;
                return this.bitBuf >>> 1 & 7;
            }
            case 5: {
                this.nBits = 2;
                return this.bitBuf >>> 2 & 7;
            }
            case 6: {
                this.nBits = 3;
                return this.bitBuf >>> 3 & 7;
            }
            case 7: {
                this.nBits = 4;
                return this.bitBuf >>> 4 & 7;
            }
            case 8: {
                this.nBits = 5;
                return this.bitBuf >>> 5 & 7;
            }
        }
        assert (false);
        return -1;
    }

    public int getFourBits() throws IOException {
        switch (this.nBits) {
            case 0: {
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 4;
                return this.bitBuf >>> 4 & 0xF;
            }
            case 1: {
                int n = (this.bitBuf & 1) << 3;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 5;
                return n | this.bitBuf >>> 5 & 7;
            }
            case 2: {
                int n = (this.bitBuf & 3) << 2;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 6;
                return n | this.bitBuf >>> 6 & 3;
            }
            case 3: {
                int n = (this.bitBuf & 7) << 1;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 7;
                return n | this.bitBuf >>> 7 & 1;
            }
            case 4: {
                this.nBits = 0;
                return this.bitBuf & 0xF;
            }
            case 5: {
                this.nBits = 1;
                return this.bitBuf >>> 1 & 0xF;
            }
            case 6: {
                this.nBits = 2;
                return this.bitBuf >>> 2 & 0xF;
            }
            case 7: {
                this.nBits = 3;
                return this.bitBuf >>> 3 & 0xF;
            }
            case 8: {
                this.nBits = 4;
                return this.bitBuf >>> 4 & 0xF;
            }
        }
        assert (false);
        return -1;
    }

    public int getFiveBits() throws IOException {
        switch (this.nBits) {
            case 0: {
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 3;
                return this.bitBuf >>> 3 & 0x1F;
            }
            case 1: {
                int n = (this.bitBuf & 1) << 4;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 4;
                return n | this.bitBuf >>> 4 & 0xF;
            }
            case 2: {
                int n = (this.bitBuf & 3) << 3;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 5;
                return n | this.bitBuf >>> 5 & 7;
            }
            case 3: {
                int n = (this.bitBuf & 7) << 2;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 6;
                return n | this.bitBuf >>> 6 & 3;
            }
            case 4: {
                int n = (this.bitBuf & 0xF) << 1;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++];
                this.nBits = 7;
                return n | this.bitBuf >>> 7 & 1;
            }
            case 5: {
                this.nBits = 0;
                return this.bitBuf & 0x1F;
            }
            case 6: {
                this.nBits = 1;
                return this.bitBuf >>> 1 & 0x1F;
            }
            case 7: {
                this.nBits = 2;
                return this.bitBuf >>> 2 & 0x1F;
            }
            case 8: {
                this.nBits = 3;
                return this.bitBuf >>> 3 & 0x1F;
            }
        }
        assert (false);
        return -1;
    }

    public int getEightBits() throws IOException {
        switch (this.nBits) {
            case 0: {
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                return this.m_bytes[this.m_curPos++] & 0xFF;
            }
            case 8: {
                this.nBits = 0;
                return this.bitBuf;
            }
            case 1: {
                int n = (this.bitBuf & 1) << 7;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
                return n | this.bitBuf >>> 1;
            }
            case 2: {
                int n = (this.bitBuf & 3) << 6;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
                return n | this.bitBuf >>> 2;
            }
            case 3: {
                int n = (this.bitBuf & 7) << 5;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
                return n | this.bitBuf >>> 3;
            }
            case 4: {
                int n = (this.bitBuf & 0xF) << 4;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
                return n | this.bitBuf >>> 4;
            }
            case 5: {
                int n = (this.bitBuf & 0x1F) << 3;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
                return n | this.bitBuf >>> 5;
            }
            case 6: {
                int n = (this.bitBuf & 0x3F) << 2;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
                return n | this.bitBuf >>> 6;
            }
            case 7: {
                int n = (this.bitBuf & 0x7F) << 1;
                if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
                    throw new EOFException();
                }
                this.bitBuf = this.m_bytes[this.m_curPos++] & 0xFF;
                return n | this.bitBuf >>> 7;
            }
        }
        assert (false);
        return -1;
    }
}

