/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.Iterator;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSNumericVariable;
import org.opendatafoundation.data.spss.SPSSStringVariable;
import org.opendatafoundation.data.spss.SPSSVariable;

public class SPSSDataRecord {
    SPSSFile file;
    long fileLocation;
    static byte[] cluster = new byte[8];
    static byte clusterIndex = (byte)8;

    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.read(sPSSFile, false);
    }

    public void read(SPSSFile sPSSFile, boolean bl) throws IOException, SPSSFileException {
        SPSSNumericVariable sPSSNumericVariable = null;
        double d = Double.NaN;
        SPSSStringVariable sPSSStringVariable = null;
        String string = "";
        this.file = sPSSFile;
        this.fileLocation = this.file.getFilePointer();
        Iterator<Integer> iterator = this.file.variableMap.keySet().iterator();
        while (iterator.hasNext()) {
            SPSSVariable sPSSVariable = this.file.variableMap.get(iterator.next());
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (sPSSVariable.type == SPSSVariable.VariableType.NUMERIC) {
                d = Double.NaN;
                n = 1;
            } else {
                string = "";
                n2 = sPSSVariable.variableRecord.variableTypeCode;
                n = (n2 - 1) / 8 + 1;
            }
            while (n > 0) {
                int n4;
                if (this.file.isCompressed()) {
                    if (clusterIndex > 7) {
                        this.file.read(cluster);
                        clusterIndex = 0;
                    }
                    n4 = 0xFF & cluster[clusterIndex];
                    clusterIndex = (byte)(clusterIndex + 1);
                    switch (n4) {
                        case 0: {
                            break;
                        }
                        case 252: {
                            throw new SPSSFileException("Error reading data: unexpected end of compressed data file (cluster code 252)");
                        }
                        case 253: {
                            if (sPSSVariable.type == SPSSVariable.VariableType.NUMERIC) {
                                d = this.file.readSPSSDouble();
                                break;
                            }
                            int n5 = Math.min(8, n2);
                            string = string + this.file.readSPSSString(n5);
                            if (n2 < 8) {
                                this.file.skipBytes(8 - n2);
                            }
                            n2 -= n5;
                            break;
                        }
                        case 254: {
                            if (sPSSVariable.type == SPSSVariable.VariableType.NUMERIC) {
                                d = 0.0;
                                break;
                            }
                            string = string + "        ";
                            break;
                        }
                        case 255: {
                            if (sPSSVariable.type == SPSSVariable.VariableType.NUMERIC) {
                                d = Double.NaN;
                                break;
                            }
                            throw new SPSSFileException("Error reading data: unexpected SYSMISS for string variable");
                        }
                        default: {
                            if (sPSSVariable.type == SPSSVariable.VariableType.NUMERIC) {
                                d = (double)n4 - this.file.infoRecord.compressionBias;
                                break;
                            }
                            throw new SPSSFileException("Error reading data: unexpected compression code for string variable");
                        }
                    }
                } else if (sPSSVariable.type == SPSSVariable.VariableType.NUMERIC) {
                    d = this.file.readSPSSDouble();
                } else {
                    n4 = Math.min(8, n2);
                    string = string + this.file.readSPSSString(n4);
                    if (n2 < 8) {
                        // empty if block
                    }
                    n2 -= n4;
                }
                --n;
            }
            if (sPSSVariable.type == SPSSVariable.VariableType.STRING) {
                string = string.trim().length() == 0 ? "" : string.replaceAll("\\s+$", "");
            }
            if (sPSSVariable.type == SPSSVariable.VariableType.NUMERIC) {
                sPSSNumericVariable = (SPSSNumericVariable)sPSSVariable;
                if (bl) {
                    sPSSNumericVariable.value = d;
                    continue;
                }
                sPSSNumericVariable.data.add(Double.NaN);
                n3 = sPSSNumericVariable.data.size() - 1;
                sPSSNumericVariable.data.set(n3, d);
                continue;
            }
            sPSSStringVariable = (SPSSStringVariable)sPSSVariable;
            if (bl) {
                sPSSStringVariable.value = string;
                continue;
            }
            sPSSStringVariable.data.add("");
            n3 = sPSSStringVariable.data.size() - 1;
            sPSSStringVariable.data.set(n3, string);
        }
    }
}

