/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType4
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int numberOfVariables;
    int[] variableIndex;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 4) {
            throw new SPSSFileException("Error reading Variable Index record: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 4.");
        }
        this.numberOfVariables = sPSSFile.readSPSSInt();
        this.variableIndex = new int[this.numberOfVariables];
        for (int i = 0; i < this.numberOfVariables; ++i) {
            this.variableIndex[i] = sPSSFile.readSPSSInt();
        }
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 4 - VARIABLE INDEX RECORD FOR VALUE LABELS";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nNumber of vars  : " + this.numberOfVariables;
        string = string + "\nVar indexes     : ";
        for (int i = 0; i < this.numberOfVariables; ++i) {
            string = string + this.variableIndex[i];
        }
        return string;
    }
}

