/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype13
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    Map<String, String> nameMap;
    String longNamesStr;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = sPSSFile.readSPSSInt();
        if (this.recordSubtypeCode != 13) {
            throw new SPSSFileException("Error reading record type 7 subtype 13: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 13.");
        }
        this.dataElementLength = sPSSFile.readSPSSInt();
        if (this.dataElementLength != 1) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad data element length [" + this.dataElementLength + "]. Expecting 1.");
        }
        this.numberOfDataElements = sPSSFile.readSPSSInt();
        this.longNamesStr = sPSSFile.readSPSSString(this.numberOfDataElements);
        this.nameMap = new LinkedHashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.longNamesStr, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            if (stringTokenizer2.countTokens() < 2) continue;
            this.nameMap.put(stringTokenizer2.nextToken(), stringTokenizer2.nextToken());
        }
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 7 SUBTYPE 13 - LONG VARIABLE NAMES";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nRecord Subtype  : " + this.recordSubtypeCode;
        string = string + "\nData elements   : " + this.numberOfDataElements;
        string = string + "\nElement length  : " + this.dataElementLength;
        string = string + "\nLong Names      : " + this.longNamesStr;
        for (Map.Entry<String, String> entry : this.nameMap.entrySet()) {
            string = string + "\n" + entry.getKey() + " = " + entry.getValue();
        }
        return string;
    }

    public class VariableDisplayParams {
        int measure;
        int width;
        int alignment;
    }
}

