/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.nio.charset.Charset;
import java.util.GregorianCalendar;

public class SPSSUtils {
    public static double byte8ToDouble(byte[] byArray) {
        long l = ((long)byArray[7] << 56) + ((long)(byArray[6] & 0xFF) << 48) + ((long)(byArray[5] & 0xFF) << 40) + ((long)(byArray[4] & 0xFF) << 32) + ((long)(byArray[3] & 0xFF) << 24) + ((long)(byArray[2] & 0xFF) << 16) + ((long)(byArray[1] & 0xFF) << 8) + (long)(byArray[0] & 0xFF);
        return Double.longBitsToDouble(l);
    }

    public static String byte8ToString(byte[] byArray) {
        String string = new String(byArray).replaceAll("\\s+$", "");
        return string;
    }

    public static String byte8ToString(byte[] byArray, Charset charset) {
        String string = new String(byArray, charset).replaceAll("\\s+$", "");
        return string;
    }

    public static int byte4ToInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n |= (byArray[i] & 0xFF) << i * 8;
        }
        return n;
    }

    public static GregorianCalendar numericToCalendar(double d) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1970, 0, 1, 0, 0, 0);
        int n = (int)((d -= 1.22193792E10) / 86400.0);
        int n2 = (int)((d -= (double)n * 86400.0) / 3600.0);
        int n3 = (int)((d -= (double)n2 * 3600.0) / 60.0);
        int n4 = (int)(d -= (double)n3 * 60.0);
        int n5 = (int)(d - (double)n4) * 100;
        gregorianCalendar.add(6, n);
        gregorianCalendar.add(11, n2);
        gregorianCalendar.add(12, n3);
        gregorianCalendar.add(13, n4);
        gregorianCalendar.add(14, n5 * 10);
        return gregorianCalendar;
    }
}

