/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.macrofocus.colormap.ColorMap;
import com.macrofocus.colormap.ColorMapEvent;
import com.macrofocus.colormap.ColorMapListener;
import com.macrofocus.colormap.swing.BasicColormapUI;
import com.macrofocus.colormap.swing.ColormapUI;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.format.CPFormat;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class ColormapView
extends JComponent {
    public static final String uiClassID = "ColormapUI";
    private Range range = Range.Data;
    private ColorMap colorMap;
    private Number min;
    private Number max;
    private CPFormat format;
    private boolean displayColors = true;
    private boolean displayValues = true;
    private ColorMapListener listener = new ColorMapListener(){

        public void colorMapChanged(ColorMapEvent event) {
            ColormapView.this.repaint();
        }
    };
    private IntervalListener intervalListener = new IntervalListener(){

        public void intervalChanged(IntervalEvent event) {
            ColormapView.this.repaint();
        }
    };

    public ColormapView(boolean expertMode) {
        this.updateUI();
        JPopupMenu popupMenu = new JPopupMenu();
        JMenu range = new JMenu("Range");
        JRadioButtonMenuItem data = new JRadioButtonMenuItem(new AbstractAction("Data Range"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColormapView.this.setRange(Range.Data);
            }
        });
        JRadioButtonMenuItem color = new JRadioButtonMenuItem(new AbstractAction("Colormap Range"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColormapView.this.setRange(Range.Colormap);
            }
        });
        data.setSelected(this.range == Range.Data);
        color.setSelected(this.range == Range.Colormap);
        ((Container)range).add(data);
        ((Container)range).add(color);
        ButtonGroup group = new ButtonGroup();
        group.add(data);
        group.add(color);
        popupMenu.add(range);
        popupMenu.add(new JSeparator());
        this.setComponentPopupMenu(popupMenu);
    }

    public void setScreenShotComponent(JComponent screenShotComponent) {
    }

    public void setUI(ColormapUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicColormapUI());
    }

    @Override
    public ColormapUI getUI() {
        return (ColormapUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setColorMap(ColorMap colorMap, Number min, Number max, CPFormat format) {
        if (this.colorMap != colorMap) {
            if (this.colorMap != null) {
                this.colorMap.removeColorMapListener(this.listener);
                if (this.colorMap.getInterval() != null) {
                    this.colorMap.getInterval().removeIntervalListener(this.intervalListener);
                }
            }
            this.colorMap = colorMap;
            if (this.colorMap != null) {
                this.colorMap.addColorMapListener(this.listener);
                if (this.colorMap.getInterval() != null) {
                    this.colorMap.getInterval().addIntervalListener(this.intervalListener);
                }
            }
        }
        this.min = min;
        this.max = max;
        this.format = format;
        this.repaint();
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public boolean isDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(boolean displayValues) {
        this.displayValues = displayValues;
    }

    public boolean isDisplayColors() {
        return this.displayColors;
    }

    public void setDisplayColors(boolean displayColors) {
        this.displayColors = displayColors;
    }

    protected double getMax() {
        switch (this.range) {
            case Data: {
                if (this.max != null) {
                    return this.max.doubleValue();
                }
            }
            case Colormap: {
                return this.colorMap.getInterval() != null ? this.colorMap.getInterval().getStart() + this.colorMap.getInterval().getExtent() * this.colorMap.getHighestFraction() : 1.0;
            }
        }
        return 1.0;
    }

    protected double getMin() {
        switch (this.range) {
            case Data: {
                if (this.min != null) {
                    return this.min.doubleValue();
                }
            }
            case Colormap: {
                return this.colorMap.getInterval() != null ? this.colorMap.getInterval().getStart() + this.colorMap.getInterval().getExtent() * this.colorMap.getLowestFraction() : 0.0;
            }
        }
        return 0.0;
    }

    public CPFormat getFormat() {
        return this.format;
    }

    public void setRange(Range range) {
        this.range = range;
        this.repaint();
    }

    public static enum Range {
        Data,
        Colormap;

    }
}

