/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class BoundedIntervalAdapter
implements BoundedRangeModel {
    private static boolean continuousUpdate = true;
    private final MutableBoundedInterval boundedRangeModel;
    private final EventListenerList listenerList;
    private ChangeEvent changeEvent = null;
    private boolean isAdjusting = false;
    private int adjustingValue;
    private boolean useExtent;

    public BoundedIntervalAdapter(MutableBoundedInterval boundedRangeModel, boolean useExtent) {
        this.boundedRangeModel = boundedRangeModel;
        this.useExtent = useExtent;
        this.listenerList = new EventListenerList();
        boundedRangeModel.addIntervalListener(new IntervalListener(){

            public void intervalChanged(IntervalEvent event) {
                BoundedIntervalAdapter.this.fireStateChanged();
            }
        });
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public static boolean isContinuousUpdate() {
        return continuousUpdate;
    }

    public static void setContinuousUpdate(boolean value) {
        continuousUpdate = value;
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    private double getMultiplier() {
        return this.getMaximum() - this.getMinimum();
    }

    @Override
    public void setMinimum(int minimum) {
        this.boundedRangeModel.setMinimum((double)minimum / this.getMultiplier());
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    @Override
    public void setValueIsAdjusting(boolean isAdjusting) {
        if (this.isAdjusting != isAdjusting) {
            this.isAdjusting = isAdjusting;
            if (!isAdjusting) {
                this.setValue(this.adjustingValue);
            }
        }
    }

    @Override
    public void setMaximum(int maximum) {
        this.boundedRangeModel.setMaximum((double)maximum / this.getMultiplier());
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public int getValue() {
        return (int)((this.boundedRangeModel.getStart() - this.boundedRangeModel.getMinimum()) * this.getMultiplier() / (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()));
    }

    @Override
    public int getExtent() {
        if (this.useExtent) {
            return (int)(this.boundedRangeModel.getExtent() * this.getMultiplier() / (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()));
        }
        return 0;
    }

    @Override
    public void setValue(int value) {
        this.adjustingValue = value;
        if (!this.isAdjusting || continuousUpdate) {
            double newValue = (double)value * (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()) / this.getMultiplier() + this.boundedRangeModel.getMinimum();
            if (newValue < this.boundedRangeModel.getMinimum()) {
                newValue = this.boundedRangeModel.getMinimum();
            }
            if (newValue > this.boundedRangeModel.getMaximum()) {
                newValue = this.boundedRangeModel.getMaximum();
            }
            this.boundedRangeModel.setStart(newValue);
        }
    }

    @Override
    public void setExtent(int extent) {
        if (this.useExtent) {
            double newValue = (double)extent * (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()) / this.getMultiplier();
            this.boundedRangeModel.setStart(newValue);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.boundedRangeModel + "]";
    }

    @Override
    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.setValue(value);
        this.setExtent(extent);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValueIsAdjusting(adjusting);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }
}

