/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.common.command.Command;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.helper.WeakActionListeners;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SwingButton
extends AbstractSwingComponent<JComponent>
implements CPButton<JComponent> {
    private final JButton nativeComponent;
    private Command command;
    private final WeakActionListeners actionListeners = new WeakActionListeners();
    private final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingButton.this.command != null) {
                SwingButton.this.command.execute();
            }
        }
    };

    public SwingButton(String text) {
        this.nativeComponent = new JButton(text);
        this.nativeComponent.addActionListener(this.actionListeners.create(this.actionListener, (Object)this.nativeComponent));
    }

    public SwingButton(Property<String> text) {
        this.nativeComponent = new JButton((String)text.getValue());
        text.addPropertyListener((PropertyListener)new PropertyListener<String>(){

            public void propertyChanged(PropertyEvent<String> event) {
                SwingButton.this.nativeComponent.setText((String)event.getNewValue());
            }
        });
        this.nativeComponent.addActionListener(this.actionListeners.create(this.actionListener, (Object)this.nativeComponent));
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void setEnabled(boolean enabled) {
        this.nativeComponent.setEnabled(enabled);
    }

    public void setVisible(boolean visible) {
        this.nativeComponent.setVisible(visible);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }
}

