/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.crossplatform.CPColorPicker;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;

public class SwingColorPicker
extends AbstractSwingComponent<JComponent>
implements CPColorPicker<JComponent, Color> {
    private final ColorChooserButton nativeComponent = new ColorChooserButton();

    public SwingColorPicker() {
    }

    public SwingColorPicker(MutableProperty<CPColor<Color>> color) {
        this();
        this.setProperty(color);
    }

    public void setProperty(final MutableProperty<CPColor<Color>> property) {
        this.nativeComponent.setSelectedColor(property.getValue() != null ? (Color)((CPColor)property.getValue()).getNativeColor() : null);
        this.nativeComponent.addColorChangedListener(new ColorChangedListener(){

            @Override
            public void colorChanged(Color newColor) {
                property.setValue((Object)new SwingColor(newColor));
            }
        });
    }

    public ColorChooserButton getNativeComponent() {
        return this.nativeComponent;
    }

    public static ImageIcon createIcon(Color main, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(main);
        graphics.fillRect(0, 0, width, height);
        graphics.setXORMode(Color.DARK_GRAY);
        graphics.drawRect(0, 0, width - 1, height - 1);
        image.flush();
        ImageIcon icon = new ImageIcon(image);
        return icon;
    }

    public static interface ColorChangedListener {
        public void colorChanged(Color var1);
    }

    public static class ColorChooserButton
    extends JButton {
        private Color current;
        private final WeakActionListeners actionListeners = new WeakActionListeners();
        private List<ColorChangedListener> listeners = new ArrayList<ColorChangedListener>();

        public ColorChooserButton() {
        }

        public ColorChooserButton(Color c) {
            this.setSelectedColor(c);
            this.addActionListener(this.actionListeners.create(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Color newColor = JColorChooser.showDialog(null, "Choose a color", current);
                    this.setSelectedColor(newColor);
                }
            }, (Object)this));
        }

        public Color getSelectedColor() {
            return this.current;
        }

        public void setSelectedColor(Color newColor) {
            this.setSelectedColor(newColor, true);
        }

        public void setSelectedColor(Color newColor, boolean notify) {
            if (newColor == null) {
                return;
            }
            this.current = newColor;
            this.setIcon(SwingColorPicker.createIcon(this.current, 16, 16));
            this.repaint();
            if (notify) {
                for (ColorChangedListener l : this.listeners) {
                    l.colorChanged(newColor);
                }
            }
        }

        public void addColorChangedListener(ColorChangedListener toAdd) {
            this.listeners.add(toAdd);
        }
    }
}

