/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing.layer;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.swing.layer.DirectSwingLayer;
import com.macrofocus.crossplatform.swing.layer.SwingLayer;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.IDrawing;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class BufferedSwingLayer
implements SwingLayer {
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    private CPCanvas.PaletteProvider paletteProvider;
    private CPColor<Color> color;
    private Composite composite;
    private int width;
    private int height;
    private BufferedImage image;
    private BufferedImage screenImage;

    public BufferedSwingLayer(IDrawing iDrawing, boolean antialiasing, CPCanvas.PaletteProvider paletteProvider) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.paletteProvider = paletteProvider;
    }

    public BufferedSwingLayer(IDrawing iDrawing, boolean antialiasing) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
    }

    public BufferedSwingLayer(IDrawing iDrawing, boolean antialiasing, CPColor<Color> color, Composite composite) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.color = color;
        this.composite = composite;
    }

    @Override
    public void prepare(int width, int height) {
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.resize(width, height);
            Graphics2D g2 = this.image.createGraphics();
            DirectSwingLayer.draw(g2, this.iDrawing, this.width, this.height, this.antialiasing, this.paletteProvider, this.color, this.composite);
            g2.dispose();
            BufferedSwingLayer.copySrcIntoDstAt(this.image, this.screenImage);
        }
    }

    void resize(int width, int height) {
        if (this.width != width || this.height != height) {
            this.image = new BufferedImage(width, height, 2);
            this.screenImage = new BufferedImage(width, height, 2);
            this.width = width;
            this.height = height;
        } else {
            this.clear();
        }
    }

    void clear() {
        if (this.image != null) {
            Graphics2D g2 = this.image.createGraphics();
            g2.setComposite(AlphaComposite.Clear);
            g2.setColor(new Color(255, 255, 255, 0));
            g2.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            g2.dispose();
        }
    }

    @Override
    public void render(Graphics2D g) {
        if (this.iDrawing.isActive() && this.image != null) {
            g.drawImage((Image)this.screenImage, 0, 0, null);
        }
    }

    private static void copySrcIntoDstAt(BufferedImage src, BufferedImage dst) {
        int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
        int[] dstbuf = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        System.arraycopy(srcbuf, 0, dstbuf, 0, srcbuf.length);
    }
}

