/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.swing;

import com.macrofocus.igraphics.CPFont;
import java.awt.Font;

public class SwingFont
implements CPFont<Font> {
    private final Font nativeFont;

    public SwingFont(Font nativeFont) {
        this.nativeFont = nativeFont;
    }

    public SwingFont(String name, int style, int size) {
        this.nativeFont = new Font(name, style, size);
    }

    public Font getNativeFont() {
        return this.nativeFont;
    }

    public double getSize2D() {
        return this.nativeFont.getSize2D();
    }

    public CPFont<Font> deriveFontSize(double fontSize) {
        return new SwingFont(this.nativeFont.deriveFont((float)fontSize));
    }

    public CPFont<Font> deriveFontWeight(CPFont.Weight weight) {
        int style = this.nativeFont.getStyle();
        switch (weight) {
            case NORMAL: {
                if ((style & 1) != 1) break;
                style ^= 1;
                break;
            }
            case BOLD: {
                style |= 1;
            }
        }
        return new SwingFont(this.nativeFont.deriveFont(style));
    }

    public String toString() {
        String strStyle = this.nativeFont.isBold() ? (this.nativeFont.isItalic() ? "bolditalic" : "bold") : (this.nativeFont.isItalic() ? "italic" : "plain");
        return this.nativeFont.getName() + "-" + strStyle + "-" + this.nativeFont.getSize();
    }
}

