/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.window;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.license.LicenseModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.OverlayLayout;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.StyleConstants;

public class SplashPanel
extends JPanel {
    private final ImageIcon image;
    private Color copyrightColor = new Color(65, 75, 83);
    private float alpha = 1.0f;
    private boolean oldOpaque;

    public SplashPanel(URL url, final ApplicationModel applicationModel, boolean displayCopyright, String copyrightText) {
        this.image = new ImageIcon(url);
        JLabel backgroundLabel = new JLabel((Icon)this.image){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setColor(new Color(65, 75, 83));
                String version = applicationModel.getVersionModel().getMajorMinorPatchString();
                int versionWidth = g.getFontMetrics().stringWidth(version) + 6;
                int x = Math.min(364, this.getWidth() - versionWidth);
                int y = 80;
                g.drawString(version, x, y);
                String build = applicationModel.getVersionModel().getBuildString();
                if (build != null) {
                    g.setFont(g.getFont().deriveFont(9.0f));
                    int buildWidth = g.getFontMetrics().stringWidth("build " + build) + 6;
                    x = x + versionWidth - buildWidth;
                    g.drawString("build " + build, x, y += g.getFontMetrics().getHeight());
                }
            }
        };
        backgroundLabel.setLayout(null);
        LicenseModel licenseModel = applicationModel.getLicenseModel();
        if (licenseModel != null) {
            Rectangle licenseBounds = new Rectangle(0, 130, 400, 40);
            Date expirationDate = licenseModel.getExpirationDate();
            String username = licenseModel.getUsername();
            JTextPane license = new JTextPane();
            String text = "Licensed to " + username + "\n";
            if (expirationDate != null) {
                DateFormat df = DateFormat.getDateInstance(1, Locale.US);
                text = text + "Expiration date: " + df.format(expirationDate);
            }
            license.setText(text);
            StyleConstants.setAlignment(license.getLogicalStyle(), 1);
            license.setOpaque(false);
            license.putClientProperty("Synthetica.opaque", Boolean.FALSE);
            license.setEditable(false);
            license.setForeground(new Color(65, 75, 83));
            license.setFont(MetalLookAndFeel.getControlTextFont());
            backgroundLabel.add(license);
            license.setBounds(licenseBounds);
        }
        if (displayCopyright) {
            Rectangle copyrightBounds = new Rectangle(0, 197, 400, 40);
            JTextPane copyright = new JTextPane();
            copyright.setText(copyrightText);
            StyleConstants.setAlignment(copyright.getLogicalStyle(), 1);
            copyright.setOpaque(false);
            copyright.putClientProperty("Synthetica.opaque", Boolean.FALSE);
            copyright.setEditable(false);
            copyright.setForeground(this.copyrightColor);
            copyright.setFont(MetalLookAndFeel.getSubTextFont());
            backgroundLabel.add(copyright);
            copyright.setBounds(copyrightBounds);
        }
        backgroundLabel.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.setLayout(new OverlayLayout(this));
        this.add(backgroundLabel);
        this.validate();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.image.getIconWidth(), this.image.getIconHeight());
    }

    public void setAlpha(float alpha) {
        if (this.alpha != alpha) {
            assert (alpha >= 0.0f && (double)alpha <= 1.0);
            float oldAlpha = this.alpha;
            this.alpha = alpha;
            if (alpha > 0.0f && alpha < 1.0f) {
                if (oldAlpha == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
            } else if (alpha == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", oldAlpha, alpha);
            this.repaint();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void paint(Graphics g) {
        if (this.alpha != 1.0f) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComp = g2d.getComposite();
            float alpha = this.getAlpha();
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, alpha);
            g2d.setComposite(alphaComp);
            super.paint(g2d);
            g2d.setComposite(oldComp);
        } else {
            super.paint(g);
        }
    }
}

