/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.utils.SwingUtils;
import com.treemap.AbstractLabeling;
import com.treemap.TreeMapController;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DefaultTreeMapController<N, Row, Column>
implements TreeMapController<JComponent, N, Row, Column, Color, Font> {
    protected TreeMapView<JComponent, N, Row, Column, Color, Font> _view;
    private JPopupMenu popupMenu;
    private Mode _mode = Mode.Selection;
    private final DefaultMouseListener _mouseListener = new DefaultMouseListener();
    private boolean multipleSelectionEnabled = true;
    private boolean selectOnPopupTrigger = false;
    private boolean zoomingEnabled = true;
    private boolean improvedBorderZooming = false;
    private final KeyListener _keyListener = new KeyAdapter(){
        Mode _oldMode;

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 83) {
                if (this._oldMode == null) {
                    this._oldMode = DefaultTreeMapController.this._mode;
                }
                DefaultTreeMapController.this._mode = Mode.Selection;
            }
            if (e.getKeyCode() == 90 || e.getKeyCode() == 16) {
                if (this._oldMode == null) {
                    this._oldMode = DefaultTreeMapController.this._mode;
                }
                DefaultTreeMapController.this._mode = Mode.Zooming;
            }
            if (e.getKeyCode() == 80 || e.getKeyCode() == 32) {
                if (this._oldMode == null) {
                    this._oldMode = DefaultTreeMapController.this._mode;
                }
                DefaultTreeMapController.this._mode = Mode.Panning;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this._oldMode != null) {
                DefaultTreeMapController.this._mode = this._oldMode;
                this._oldMode = null;
            }
        }
    };

    public DefaultTreeMapController() {
    }

    public DefaultTreeMapController(TreeMapView<JComponent, N, Row, Column, Color, Font> view) {
        this.setView(view);
    }

    private void zoom(double amount, Double xCenter, Double yCenter) {
        if (this.zoomingEnabled) {
            Rectangle2D viewport = this._view.getViewport();
            Rectangle2D world = this._view.getWorld();
            if (yCenter != null) {
                yCenter = world.getMaxY() - yCenter;
            }
            if (this.improvedBorderZooming) {
                double normalizedXCenter = this.normalize(xCenter, world.getMinX(), world.getMaxX());
                double normalizedYCenter = this.normalize(yCenter, world.getMinY(), world.getMaxY());
                xCenter = this.denormalize(this.zoomingCenterFunction(normalizedXCenter), world.getMinX(), world.getMaxX());
                yCenter = this.denormalize(this.zoomingCenterFunction(normalizedYCenter), world.getMinY(), world.getMaxY());
            }
            Dimension d = this._view.getSize();
            Range xRange = new Range(amount, xCenter, viewport.getMinX(), viewport.getWidth(), world.getMinX(), world.getMaxX(), d.getWidth()).invoke();
            double xMin = xRange.getMin();
            double xMax = xRange.getMax();
            Range yRange = new Range(amount, yCenter, viewport.getMinY(), viewport.getHeight(), world.getMinY(), world.getMaxY(), d.getHeight()).invoke();
            double yMin = yRange.getMin();
            double yMax = yRange.getMax();
            if (xMin < xMax && yMin < yMax) {
                this._view.zoom(false, xMin, xMax, yMin, yMax);
            }
        }
    }

    protected double zoomingCenterFunction(double center) {
        return Math.tanh(center * 3.0);
    }

    private double normalize(double center, double min, double extent) {
        return (center - min) / extent * 2.0 - 1.0;
    }

    private double denormalize(double x, double min, double extent) {
        return min + extent * ((x + 1.0) / 2.0);
    }

    public void setView(final TreeMapView<JComponent, N, Row, Column, Color, Font> view) {
        if (this._view != view) {
            Action zoomOutAction;
            Action zoomInAction;
            Action drillUpAction;
            Action drillDownAction;
            if (this._view != null) {
                ((JComponent)this._view.getNativeComponent()).removeKeyListener(this._keyListener);
                drillDownAction = ((JComponent)this._view.getNativeComponent()).getActionMap().get("drillDown");
                drillUpAction = ((JComponent)this._view.getNativeComponent()).getActionMap().get("drillUp");
                zoomInAction = ((JComponent)this._view.getNativeComponent()).getActionMap().get("zoomIn");
                zoomOutAction = ((JComponent)this._view.getNativeComponent()).getActionMap().get("zoomOut");
                if (zoomInAction != null) {
                    ((JComponent)this._view.getNativeComponent()).unregisterKeyboardAction((KeyStroke)zoomInAction.getValue("AcceleratorKey"));
                }
                if (zoomOutAction != null) {
                    ((JComponent)this._view.getNativeComponent()).unregisterKeyboardAction((KeyStroke)zoomOutAction.getValue("AcceleratorKey"));
                }
                if (drillDownAction != null) {
                    ((JComponent)this._view.getNativeComponent()).unregisterKeyboardAction((KeyStroke)drillDownAction.getValue("AcceleratorKey"));
                }
                if (drillUpAction != null) {
                    ((JComponent)this._view.getNativeComponent()).unregisterKeyboardAction((KeyStroke)drillUpAction.getValue("AcceleratorKey"));
                }
                ((JComponent)this._view.getNativeComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke("control ESCAPE"));
                ((JComponent)this._view.getNativeComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke("control alt Q"));
                ((JComponent)this._view.getNativeComponent()).removeMouseListener(this._mouseListener);
                ((JComponent)this._view.getNativeComponent()).removeMouseMotionListener(this._mouseListener);
                ((JComponent)this._view.getNativeComponent()).removeMouseWheelListener(this._mouseListener);
            }
            this._view = view;
            if (this._view != null) {
                ((JComponent)this._view.getNativeComponent()).setComponentPopupMenu(null);
                ((JComponent)view.getNativeComponent()).setFocusable(true);
                ((JComponent)view.getNativeComponent()).addKeyListener(this._keyListener);
                ((JComponent)view.getNativeComponent()).addMouseListener(this._mouseListener);
                ((JComponent)view.getNativeComponent()).addMouseMotionListener(this._mouseListener);
                ((JComponent)view.getNativeComponent()).addMouseWheelListener(this._mouseListener);
                this.popupMenu = new JPopupMenu();
                this.popupMenu.addPopupMenuListener(new PopupMenuListener(){
                    private final List<Component> actions = new ArrayList<Component>();

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                        Object node;
                        if (DefaultTreeMapController.this.selectOnPopupTrigger) {
                            node = view.getModel().getSelection().isActive() ? (Object)view.getModel().getSelection().iterator().next() : null;
                        } else {
                            java.awt.Point p = null;
                            try {
                                p = ((JComponent)view.getNativeComponent()).getMousePosition();
                            }
                            catch (HeadlessException headlessException) {
                                // empty catch block
                            }
                            node = p != null ? view.getNode(new Point(p.x, p.y)) : null;
                        }
                        if (node != null) {
                            for (int c = 0; c < view.getModel().getColumnCount(); ++c) {
                                Component comp = null;
                                try {
                                    TreeMapField column = view.getModel().getTreeMapField(c);
                                    comp = DefaultTreeMapController.this.createPopupMenuEntry(node, column.getIndex());
                                }
                                catch (URISyntaxException e) {
                                    e.printStackTrace();
                                }
                                if (comp == null) continue;
                                this.actions.add(comp);
                            }
                        }
                        for (Component action : this.actions) {
                            DefaultTreeMapController.this.popupMenu.insert(action, 0);
                        }
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        for (Component action : this.actions) {
                            DefaultTreeMapController.this.popupMenu.remove(action);
                        }
                        this.actions.clear();
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
                drillDownAction = ((JComponent)view.getNativeComponent()).getActionMap().get("drillDown");
                drillUpAction = ((JComponent)view.getNativeComponent()).getActionMap().get("drillUp");
                zoomInAction = ((JComponent)view.getNativeComponent()).getActionMap().get("zoomIn");
                zoomOutAction = ((JComponent)view.getNativeComponent()).getActionMap().get("zoomOut");
                if (zoomInAction != null) {
                    ((JComponent)view.getNativeComponent()).registerKeyboardAction(zoomInAction, (KeyStroke)zoomInAction.getValue("AcceleratorKey"), 1);
                    this.popupMenu.add(zoomInAction);
                }
                if (zoomOutAction != null) {
                    ((JComponent)view.getNativeComponent()).registerKeyboardAction(zoomOutAction, (KeyStroke)zoomOutAction.getValue("AcceleratorKey"), 1);
                    this.popupMenu.add(zoomOutAction);
                }
                if (drillDownAction != null) {
                    ((JComponent)view.getNativeComponent()).registerKeyboardAction(drillDownAction, (KeyStroke)drillDownAction.getValue("AcceleratorKey"), 1);
                    this.popupMenu.add(drillDownAction);
                }
                if (drillUpAction != null) {
                    ((JComponent)view.getNativeComponent()).registerKeyboardAction(drillUpAction, (KeyStroke)drillUpAction.getValue("AcceleratorKey"), 1);
                    this.popupMenu.add(drillUpAction);
                }
                ((JComponent)view.getNativeComponent()).registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        view.getModel().getSettings().resetToDefaults();
                    }
                }, KeyStroke.getKeyStroke("control ESCAPE"), 1);
                ((JComponent)view.getNativeComponent()).registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Layout Quality");
                        DefaultTreeMapController.this.assessQuality(DefaultTreeMapController.this._view.getModel(), DefaultTreeMapController.this._view.getModel().getCurrentRoot());
                    }
                }, KeyStroke.getKeyStroke("control alt Q"), 1);
            }
        }
    }

    private void assessQuality(TreeMapModel<N, Row, Column, Color, Font> model, N parent) {
        double sumSize = 0.0;
        double sumArea = 0.0;
        for (Object child : model.getChildren(parent)) {
            Shape shape = model.getShape(child);
            if (shape == null) continue;
            sumSize += model.getSize(child);
            sumArea += Math.abs(AbstractLabeling.getArea((Shape)shape));
        }
        double totalError = 0.0;
        for (Object child : model.getChildren(parent)) {
            double area;
            double areaRatio;
            Shape shape = model.getShape(child);
            if (shape == null) continue;
            double sizeRatio = model.getSize(child) / sumSize;
            double error = Math.abs(sizeRatio - (areaRatio = (area = Math.abs(AbstractLabeling.getArea((Shape)shape))) / sumArea));
            if (error > 0.03) {
                System.out.println("Error for " + child + ": desired=" + sizeRatio + ",actual=" + areaRatio + " (" + area + " pixels instead of " + sizeRatio * sumArea + " pixels)");
            }
            totalError += error;
        }
        System.out.println("Total error for " + parent + ": " + totalError);
        for (Object child : model.getChildren(parent)) {
            if (model.hasNoChildren(child)) continue;
            this.assessQuality(model, child);
        }
    }

    protected Component createPopupMenuEntry(N node, Column c) throws URISyntaxException {
        if (URL.class.isAssignableFrom(this._view.getModel().getColumnClass(c))) {
            Object value = this._view.getModel().getValueAt(node, c);
            if (value != null) {
                try {
                    Class<?> desktop = Class.forName("java.awt.Desktop");
                    Method isDesktopSupported = desktop.getMethod("isDesktopSupported", null);
                    Boolean b = (Boolean)isDesktopSupported.invoke(null, (Object[])null);
                    if (b.booleanValue()) {
                        final Object desktopInstance = desktop.getMethod("getDesktop", null).invoke(null, (Object[])null);
                        Class<?> desktopAction = Class.forName("java.awt.Desktop$Action");
                        Method isSupported = desktop.getMethod("isSupported", desktopAction);
                        Object browseConst = desktopAction.getField("BROWSE").get(null);
                        b = (Boolean)isSupported.invoke(desktopInstance, browseConst);
                        if (b.booleanValue()) {
                            final Method browse = desktop.getMethod("browse", URI.class);
                            final URI uri = ((URL)value).toURI();
                            AbstractAction a = new AbstractAction(this._view.getModel().getColumnName(c)){

                                @Override
                                public void actionPerformed(ActionEvent event) {
                                    try {
                                        browse.invoke(desktopInstance, uri);
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                }
                            };
                            return new JMenuItem(a);
                        }
                        return null;
                    }
                    return null;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return null;
        }
        if (File.class.isAssignableFrom(this._view.getModel().getColumnClass(c))) {
            final Object value = this._view.getModel().getValueAt(node, c);
            if (value != null) {
                try {
                    Class<?> desktop = Class.forName("java.awt.Desktop");
                    Method isDesktopSupported = desktop.getMethod("isDesktopSupported", null);
                    Boolean b = (Boolean)isDesktopSupported.invoke(null, (Object[])null);
                    if (b.booleanValue()) {
                        final Object desktopInstance = desktop.getMethod("getDesktop", null).invoke(null, (Object[])null);
                        Class<?> desktopAction = Class.forName("java.awt.Desktop$Action");
                        Method isSupported = desktop.getMethod("isSupported", desktopAction);
                        Object browseConst = desktopAction.getField("BROWSE").get(null);
                        b = (Boolean)isSupported.invoke(desktopInstance, browseConst);
                        if (b.booleanValue()) {
                            final Method browse = desktop.getMethod("browse", URI.class);
                            AbstractAction a = new AbstractAction(this._view.getModel().getColumnName(c)){

                                @Override
                                public void actionPerformed(ActionEvent event) {
                                    try {
                                        URI uri = ((File)value).toURI();
                                        browse.invoke(desktopInstance, uri);
                                    }
                                    catch (InvocationTargetException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (Exception e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            };
                            return new JMenuItem(a);
                        }
                        return null;
                    }
                    return null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        if (Action.class.isAssignableFrom(this._view.getModel().getColumnClass(c))) {
            Object value = this._view.getModel().getValueAt(node, c);
            if (value != null) {
                return new JMenuItem((Action)value);
            }
            return null;
        }
        return null;
    }

    public boolean isMultipleSelectionEnabled() {
        return this.multipleSelectionEnabled;
    }

    public void setMultipleSelectionEnabled(boolean multipleSelectionEnabled) {
        this.multipleSelectionEnabled = multipleSelectionEnabled;
    }

    public boolean isSelectOnPopupTrigger() {
        return this.selectOnPopupTrigger;
    }

    public void setSelectOnPopupTrigger(boolean selectOnPopupTrigger) {
        this.selectOnPopupTrigger = selectOnPopupTrigger;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public boolean isImprovedBorderZooming() {
        return this.improvedBorderZooming;
    }

    public void setImprovedBorderZooming(boolean improvedBorderZooming) {
        this.improvedBorderZooming = improvedBorderZooming;
    }

    public void setZoomingEnabled(boolean zoomingEnabled) {
        this.zoomingEnabled = zoomingEnabled;
    }

    public boolean isZoomingEnabled() {
        return this.zoomingEnabled;
    }

    TreeMapView<JComponent, N, Row, Column, Color, Font> getView() {
        return this._view;
    }

    private class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private java.awt.Point last;
        private N selectOnRelease = null;
        private java.awt.Point zoomOnRelease = null;
        private java.awt.Point zoomingPoint = null;
        private java.awt.Point pressedPoint = null;

        private DefaultMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (DefaultTreeMapController.this._view != null) {
                ((JComponent)DefaultTreeMapController.this._view.getNativeComponent()).requestFocusInWindow();
                if (DefaultTreeMapController.this._view.getModel() != null) {
                    DefaultTreeMapController.this._view.getModel().getProbing().setSelected(DefaultTreeMapController.this._view.getNode(new Point(e.getPoint().x, e.getPoint().y)));
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (DefaultTreeMapController.this._view != null && DefaultTreeMapController.this._view.getModel() != null) {
                DefaultTreeMapController.this._view.getModel().getProbing().clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            block22: {
                block26: {
                    block23: {
                        block24: {
                            block25: {
                                if (DefaultTreeMapController.this._view == null) break block22;
                                this.pressedPoint = e.getPoint();
                                if (e.isPopupTrigger()) break block23;
                                if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() <= 1) break block24;
                                if (DefaultTreeMapController.this._view.getNode(new Point(e.getPoint().x, e.getPoint().y)) == null) break block25;
                                switch (DefaultTreeMapController.this._mode) {
                                    case Zooming: {
                                        Action zoomInAction = ((JComponent)DefaultTreeMapController.this._view.getNativeComponent()).getActionMap().get("zoomIn");
                                        if (zoomInAction != null) {
                                            zoomInAction.actionPerformed(new ActionEvent(this, 0, null));
                                            break;
                                        }
                                        break block26;
                                    }
                                    default: {
                                        Action drillDownAction = ((JComponent)DefaultTreeMapController.this._view.getNativeComponent()).getActionMap().get("drillDown");
                                        if (drillDownAction != null) {
                                            drillDownAction.actionPerformed(new ActionEvent(this, 0, null));
                                            break;
                                        }
                                        break block26;
                                    }
                                }
                                break block26;
                            }
                            switch (DefaultTreeMapController.this._mode) {
                                case Zooming: {
                                    Action zoomOutAction = ((JComponent)DefaultTreeMapController.this._view.getNativeComponent()).getActionMap().get("zoomOut");
                                    if (zoomOutAction != null) {
                                        zoomOutAction.actionPerformed(new ActionEvent(this, 0, null));
                                        break;
                                    }
                                    break block26;
                                }
                                default: {
                                    Action drillUpAction = ((JComponent)DefaultTreeMapController.this._view.getNativeComponent()).getActionMap().get("drillUp");
                                    if (drillUpAction != null) {
                                        drillUpAction.actionPerformed(new ActionEvent(this, 0, null));
                                        break;
                                    }
                                    break block26;
                                }
                            }
                            break block26;
                        }
                        switch (DefaultTreeMapController.this._mode) {
                            case Selection: {
                                boolean isAlreadySelected;
                                if (!SwingUtilities.isLeftMouseButton(e)) break;
                                Object observation = DefaultTreeMapController.this._view.getNode(new Point(e.getPoint().x, e.getPoint().y));
                                this.selectOnRelease = null;
                                boolean bl = isAlreadySelected = DefaultTreeMapController.this._view.getModel().getSelection().isActive() && DefaultTreeMapController.this._view.getModel().getSelection().isSelected(observation);
                                if (!isAlreadySelected && !SwingUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                                    DefaultTreeMapController.this._view.getModel().getSelection().clearSelection();
                                }
                                if (SwingUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                                    if (!isAlreadySelected) {
                                        if (DefaultTreeMapController.this.multipleSelectionEnabled) {
                                            this.addToSelection(observation);
                                            break;
                                        }
                                        this.setSelection(observation);
                                        break;
                                    }
                                    this.removeFromSelection(observation);
                                    break;
                                }
                                if (isAlreadySelected) {
                                    this.selectOnRelease = observation;
                                    break;
                                }
                                if (DefaultTreeMapController.this.multipleSelectionEnabled) {
                                    this.addToSelection(observation);
                                    break;
                                }
                                this.setSelection(observation);
                                break;
                            }
                            case Zooming: {
                                this.zoomOnRelease = this.pressedPoint;
                            }
                        }
                        break block26;
                    }
                    if (DefaultTreeMapController.this.selectOnPopupTrigger) {
                        Object node = DefaultTreeMapController.this._view.getNode(new Point(e.getPoint().x, e.getPoint().y));
                        this.setSelection(node);
                    }
                    if (DefaultTreeMapController.this.popupMenu != null) {
                        DefaultTreeMapController.this.popupMenu.show((Component)DefaultTreeMapController.this._view.getNativeComponent(), e.getX(), e.getY());
                    }
                }
                this.zoomingPoint = this.pressedPoint;
                this.last = this.pressedPoint;
            }
        }

        private void removeFromSelection(N observation) {
            if (observation != null) {
                DefaultTreeMapController.this._view.getModel().getSelection().setSelectedState(observation, false);
            }
        }

        private void setSelection(N observation) {
            if (observation != null) {
                DefaultTreeMapController.this._view.getModel().getSelection().setSelectedElements(new Object[]{observation});
            } else {
                DefaultTreeMapController.this._view.getModel().getSelection().clearSelection();
            }
        }

        private void addToSelection(N observation) {
            if (observation != null) {
                DefaultTreeMapController.this._view.getModel().getSelection().setSelectedState(observation, true);
            }
        }

        private void addToSelection(List<N> newSelection) {
            DefaultTreeMapController.this._view.getModel().getSelection().setSelectedIterableState(newSelection, true);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (DefaultTreeMapController.this._view != null) {
                if (!e.isPopupTrigger()) {
                    if (this.selectOnRelease != null && SwingUtilities.isLeftMouseButton(e)) {
                        DefaultTreeMapController.this._view.getModel().getSelection().clearSelection();
                        if (DefaultTreeMapController.this.multipleSelectionEnabled) {
                            this.addToSelection(this.selectOnRelease);
                        } else {
                            this.setSelection(this.selectOnRelease);
                        }
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            DefaultTreeMapController.this.zoom(-0.05, DefaultTreeMapController.this._view.screenToWorldX(this.zoomOnRelease.x), DefaultTreeMapController.this._view.screenToWorldY(this.zoomOnRelease.y));
                        } else {
                            DefaultTreeMapController.this.zoom(0.05, DefaultTreeMapController.this._view.screenToWorldX(this.zoomOnRelease.x), DefaultTreeMapController.this._view.screenToWorldY(this.zoomOnRelease.y));
                        }
                        this.zoomOnRelease = null;
                    }
                    DefaultTreeMapController.this._view.getRubberBand().stopRubberBand();
                } else {
                    if (DefaultTreeMapController.this.selectOnPopupTrigger) {
                        Object node = DefaultTreeMapController.this._view.getNode(new Point(e.getPoint().x, e.getPoint().y));
                        this.setSelection(node);
                    }
                    if (DefaultTreeMapController.this.popupMenu != null) {
                        DefaultTreeMapController.this.popupMenu.show((Component)DefaultTreeMapController.this._view.getNativeComponent(), e.getX(), e.getY());
                    }
                }
                this.last = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (DefaultTreeMapController.this._view != null && DefaultTreeMapController.this._view.getModel() != null) {
                DefaultTreeMapController.this._view.getModel().getProbing().setSelected(DefaultTreeMapController.this._view.getNode(new Point(e.getPoint().x, e.getPoint().y)));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DefaultTreeMapController.this._view != null && DefaultTreeMapController.this._view.getModel() != null) {
                DefaultTreeMapController.this._view.getModel().getProbing().setSelected(DefaultTreeMapController.this._view.getNode(new Point(e.getPoint().x, e.getPoint().y)));
                if (this.last != null) {
                    switch (DefaultTreeMapController.this._mode) {
                        case Selection: {
                            boolean isAlreadySelected;
                            if (!SwingUtilities.isLeftMouseButton(e)) break;
                            if (e.isAltDown()) {
                                if (!DefaultTreeMapController.this.multipleSelectionEnabled) break;
                                if (DefaultTreeMapController.this._view.getRubberBand().getRubberBand().isActive()) {
                                    DefaultTreeMapController.this._view.getRubberBand().startRubberBand(this.pressedPoint.x, this.pressedPoint.y);
                                }
                                DefaultTreeMapController.this._view.getRubberBand().stretchRubberBand(e.getPoint().x, e.getPoint().y);
                                Rectangle2D r = DefaultTreeMapController.this._view.getRubberBand().getRubberBandScreen();
                                if (r == null) break;
                                List toSelect = DefaultTreeMapController.this.getView().getNodes(r.getBounds());
                                if (e.isControlDown()) {
                                    this.addToSelection(toSelect);
                                } else {
                                    DefaultTreeMapController.this._view.getModel().getSelection().setSelectedIterable((Iterable)toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            java.awt.Point p = e.getPoint();
                            Object observation = DefaultTreeMapController.this._view.getNode(new Point(p.x, p.y));
                            this.selectOnRelease = null;
                            boolean bl = isAlreadySelected = DefaultTreeMapController.this._view.getModel().getSelection().isActive() && DefaultTreeMapController.this._view.getModel().getSelection().isSelected(observation);
                            if (!isAlreadySelected && !SwingUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                                DefaultTreeMapController.this._view.getModel().getSelection().clearSelection();
                            }
                            if (SwingUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                                if (DefaultTreeMapController.this.multipleSelectionEnabled) {
                                    this.addToSelection(observation);
                                    break;
                                }
                                this.setSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            if (DefaultTreeMapController.this.multipleSelectionEnabled) {
                                this.addToSelection(observation);
                                break;
                            }
                            this.setSelection(observation);
                            break;
                        }
                        case Panning: {
                            if (!DefaultTreeMapController.this.zoomingEnabled || !SwingUtilities.isLeftMouseButton(e)) break;
                            Rectangle2D viewport = DefaultTreeMapController.this._view.getViewport();
                            Rectangle2D world = DefaultTreeMapController.this._view.getWorld();
                            double x1 = DefaultTreeMapController.this._view.screenToWorldX(this.last.x);
                            double x2 = DefaultTreeMapController.this._view.screenToWorldX(e.getPoint().x);
                            double worldDiffX = x1 - x2;
                            double xMin = viewport.getMinX() + worldDiffX;
                            double xMax = viewport.getMaxX() + worldDiffX;
                            double y1 = world.getMaxY() - DefaultTreeMapController.this._view.screenToWorldY(this.last.y);
                            double y2 = world.getMaxY() - DefaultTreeMapController.this._view.screenToWorldY(e.getPoint().y);
                            double worldDiffY = y1 - y2;
                            double yMin = viewport.getMinY() + worldDiffY;
                            double yMax = viewport.getMaxY() + worldDiffY;
                            if (xMin < world.getMinX()) {
                                xMax += world.getMinX() - xMin;
                                xMin = world.getMinX();
                            }
                            if (xMax > world.getMaxX()) {
                                xMin -= xMax - world.getMaxX();
                                xMax = world.getMaxX();
                            }
                            xMin = Math.max(world.getMinX(), xMin);
                            xMax = Math.min(world.getMaxX(), xMax);
                            if (yMin < world.getMinY()) {
                                yMax += world.getMinY() - yMin;
                                yMin = world.getMinY();
                            }
                            if (yMax > world.getMaxY()) {
                                yMin -= yMax - world.getMaxY();
                                yMax = world.getMaxY();
                            }
                            yMin = Math.max(world.getMinY(), yMin);
                            yMax = Math.min(world.getMaxY(), yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            DefaultTreeMapController.this._view.zoom(false, xMin, xMax, yMin, yMax);
                            break;
                        }
                        case Zooming: {
                            if (!SwingUtilities.isMiddleMouseButton(e)) break;
                            DefaultTreeMapController.this.zoom((e.getPoint().getY() - this.last.getY()) / 100.0, DefaultTreeMapController.this._view.screenToWorldX(this.zoomingPoint.x), DefaultTreeMapController.this._view.screenToWorldY(this.zoomingPoint.y));
                            this.zoomOnRelease = null;
                        }
                    }
                }
                this.last = e.getPoint();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (DefaultTreeMapController.this._view != null) {
                int amount = e.getWheelRotation();
                java.awt.Point p = e.getPoint();
                DefaultTreeMapController.this.zoom((double)amount / 20.0, DefaultTreeMapController.this._view.screenToWorldX(p.x), DefaultTreeMapController.this._view.screenToWorldY(p.y));
            }
        }
    }

    private class Range {
        private final double _amount;
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private double _min;
        private double _max;
        private final double _maxExtent;

        public Range(double amount, Double center, double start, double extent, double minRange, double maxRange, double maxExtent) {
            this._amount = amount;
            this._center = center;
            this._start = start;
            this._extent = extent;
            this._minRange = minRange;
            this._maxRange = maxRange;
            this._maxExtent = maxExtent;
        }

        public double getMin() {
            return this._min;
        }

        public double getMax() {
            return this._max;
        }

        public Range invoke() {
            double range = this._extent;
            double newRange = Math.min(this._maxExtent, range + range * this._amount);
            if (this._center != null) {
                this._min = this._center - newRange * ((this._center - this._start) / range);
                this._max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this._min = this._start;
                this._max = this._start + newRange;
            }
            if (this._min < this._minRange) {
                this._max += this._minRange - this._min;
                this._min = this._minRange;
            }
            if (this._max > this._maxRange) {
                this._min -= this._max - this._maxRange;
                this._max = this._maxRange;
            }
            this._min = Math.max(this._minRange, this._min);
            this._max = Math.min(this._maxRange, this._max);
            return this;
        }
    }

    public static enum Mode {
        Selection,
        Zooming,
        Panning,
        Drilling;

    }
}

