/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.geom.Rectangle2D;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class DrillUpAction<N, Row, Column>
extends AbstractAction {
    private final TreeMapView<JComponent, N, Row, Column, Color, Font> _view;

    public DrillUpAction(TreeMapView<JComponent, N, Row, Column, Color, Font> view) {
        super("Drill Up");
        this._view = view;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeMapModel model = this._view.getModel();
        model.getProbing().clearSelection();
        if (!model.isRoot(model.getCurrentRoot())) {
            Rectangle2D world = this._view.getWorld();
            this._view.zoom(false, world.getMinX(), world.getMaxX(), world.getMinY(), world.getMaxY());
            Object root = model.getParent(model.getCurrentRoot());
            model.setCurrentRoot(root);
        }
    }
}

