/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ZoomInAction<N, Row, Column>
extends AbstractAction {
    private final TreeMapView<JComponent, N, Row, Column, Color, Font> _view;

    public ZoomInAction(TreeMapView<JComponent, N, Row, Column, Color, Font> view) {
        super("Zoom In");
        this._view = view;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(34, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeMapModel model = this._view.getModel();
        Object root = model.getCurrentRoot();
        Point location = ((JComponent)this._view.getNativeComponent()).getMousePosition();
        if (location != null) {
            ArrayList v = new ArrayList();
            for (Object treeMapNode : model.breadthFirstIterator(root)) {
                if (!this._view.getRenderedShape(treeMapNode).contains((Point2D)new Point2D.Double((double)location.x, (double)location.y)) || model.hasNoChildren(treeMapNode)) continue;
                v.add(treeMapNode);
                if (v.size() <= 1) continue;
                Object target = v.get(1);
                Rectangle2D rect = model.getBounds(target);
                Rectangle2D world = this._view.getWorld();
                double xExtent = rect.getWidth();
                double yExtent = rect.getHeight();
                double xRangeRatio = xExtent / world.getWidth();
                double yRangeRatio = yExtent / world.getHeight();
                double rangeRatio = Math.max(xRangeRatio, yRangeRatio);
                xExtent = rangeRatio * world.getWidth();
                yExtent = rangeRatio * world.getHeight();
                double x1 = rect.getX();
                double x2 = x1 + xExtent;
                double y1 = world.getMaxY() - (rect.getY() + yExtent);
                double y2 = world.getMaxY() - rect.getY();
                if (x1 < world.getMinX()) {
                    x1 = world.getMinX();
                    x2 = x1 + xExtent;
                }
                if (x2 > world.getMaxX()) {
                    x1 = world.getMaxX() - xExtent;
                    x2 = world.getMaxX();
                }
                if (y1 < world.getMinY()) {
                    y1 = world.getMinY();
                    y2 = y1 + yExtent;
                }
                if (y2 > world.getMaxY()) {
                    y1 = world.getMaxY() - yExtent;
                    y2 = world.getMaxY();
                }
                this._view.zoom(true, x1, x2, y1, y2);
                break;
            }
            ((JComponent)this._view.getNativeComponent()).repaint();
        }
    }
}

