/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.convexhull;

import com.treemap.swing.fastvoronoi.convexhull.Facet;
import com.treemap.swing.fastvoronoi.convexhull.Vertex;
import java.util.ArrayList;
import java.util.List;

public class Polytope {
    protected List<Vertex> points = new ArrayList<Vertex>();
    private List<Facet> facets = new ArrayList<Facet>();
    private double diameter = 1.0;

    public Polytope() {
        this.clear();
    }

    public void clear() {
        this.points.clear();
        this.facets.clear();
    }

    public double getDiameter() {
        return this.diameter;
    }

    public void setDiameter(double diameter) {
        this.diameter = diameter;
    }

    public Vertex getVertex(int index) {
        if (index < 0 || index >= this.getVertexCount()) {
            return null;
        }
        return this.points.get(index);
    }

    public int getVertexCount() {
        return this.points.size();
    }

    public void addVertex(Vertex v) {
        v.setIndex(this.getVertexCount());
        this.points.add(v);
    }

    public void removeVertex(Vertex v) {
        int index = v.getIndex();
        v.setIndex(-1);
        if (index < 0 || index >= this.getVertexCount()) {
            return;
        }
        if (index == this.getVertexCount() - 1) {
            this.points.remove(this.getVertexCount() - 1);
        } else {
            Vertex last = this.points.remove(this.getVertexCount() - 1);
            last.setIndex(index);
            this.points.set(index, last);
        }
    }

    public Facet getFacet(int index) {
        if (index < 0 || index >= this.getFacetCount()) {
            return null;
        }
        return this.facets.get(index);
    }

    public int getFacetCount() {
        return this.facets.size();
    }

    public void addFacet(Facet f) {
        f.setIndex(this.getFacetCount());
        this.facets.add(f);
    }

    public void removeFacet(Facet f) {
        int index = f.getIndex();
        f.setIndex(-1);
        if (index < 0 || index >= this.getFacetCount()) {
            return;
        }
        if (index == this.getFacetCount() - 1) {
            this.facets.remove(this.getFacetCount() - 1);
        } else {
            Facet last = this.facets.remove(this.getFacetCount() - 1);
            last.setIndex(index);
            this.facets.set(index, last);
        }
    }
}

